/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.InnerHitContextBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.retriever.rankdoc.RankDocsQuery;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class RankDocsQueryBuilder
extends AbstractQueryBuilder<RankDocsQueryBuilder> {
    public static final String NAME = "rank_docs_query";
    private final RankDoc[] rankDocs;
    private final QueryBuilder[] queryBuilders;
    private final boolean onlyRankDocs;

    public RankDocsQueryBuilder(RankDoc[] rankDocs, QueryBuilder[] queryBuilders, boolean onlyRankDocs) {
        this.rankDocs = rankDocs;
        this.queryBuilders = queryBuilders;
        this.onlyRankDocs = onlyRankDocs;
    }

    public RankDocsQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.rankDocs = in.readArray(c -> c.readNamedWriteable(RankDoc.class), RankDoc[]::new);
        if (in.getTransportVersion().onOrAfter(TransportVersions.RRF_QUERY_REWRITE)) {
            this.queryBuilders = in.readOptionalArray(c -> c.readNamedWriteable(QueryBuilder.class), QueryBuilder[]::new);
            this.onlyRankDocs = in.readBoolean();
        } else {
            this.queryBuilders = null;
            this.onlyRankDocs = false;
        }
    }

    @Override
    protected void extractInnerHitBuilders(Map<String, InnerHitContextBuilder> innerHits) {
        if (this.queryBuilders != null) {
            for (QueryBuilder query : this.queryBuilders) {
                InnerHitContextBuilder.extractInnerHits(query, innerHits);
            }
        }
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        if (this.queryBuilders != null) {
            QueryBuilder[] newQueryBuilders = new QueryBuilder[this.queryBuilders.length];
            boolean changed = false;
            for (int i = 0; i < newQueryBuilders.length; ++i) {
                newQueryBuilders[i] = this.queryBuilders[i].rewrite(queryRewriteContext);
                changed |= newQueryBuilders[i] != this.queryBuilders[i];
            }
            if (changed) {
                return new RankDocsQueryBuilder(this.rankDocs, newQueryBuilders, this.onlyRankDocs);
            }
        }
        return super.doRewrite(queryRewriteContext);
    }

    public RankDoc[] rankDocs() {
        return this.rankDocs;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeArray(StreamOutput::writeNamedWriteable, this.rankDocs);
        if (out.getTransportVersion().onOrAfter(TransportVersions.RRF_QUERY_REWRITE)) {
            out.writeOptionalArray(StreamOutput::writeNamedWriteable, this.queryBuilders);
            out.writeBoolean(this.onlyRankDocs);
        }
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        String[] queryNames;
        Query[] queries;
        RankDoc[] shardRankDocs = (RankDoc[])Arrays.stream(this.rankDocs).filter(r -> r.shardIndex == context.getShardRequestIndex()).toArray(RankDoc[]::new);
        IndexReader reader = context.getIndexReader();
        if (this.queryBuilders != null) {
            queries = new Query[this.queryBuilders.length];
            queryNames = new String[this.queryBuilders.length];
            for (int i = 0; i < this.queryBuilders.length; ++i) {
                queries[i] = this.queryBuilders[i].toQuery(context);
                queryNames[i] = this.queryBuilders[i].queryName();
            }
        } else {
            queries = new Query[]{};
            queryNames = Strings.EMPTY_ARRAY;
        }
        return new RankDocsQuery(reader, shardRankDocs, queries, queryNames, this.onlyRankDocs);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startArray("rank_docs");
        for (RankDoc doc : this.rankDocs) {
            builder.startObject();
            doc.toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
    }

    @Override
    protected boolean doEquals(RankDocsQueryBuilder other) {
        return Arrays.equals(this.rankDocs, other.rankDocs) && Arrays.equals(this.queryBuilders, other.queryBuilders) && this.onlyRankDocs == other.onlyRankDocs;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(Arrays.hashCode(this.rankDocs), Arrays.hashCode(this.queryBuilders), this.onlyRankDocs);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.RANK_DOCS_RETRIEVER;
    }
}

