/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.IndexingStats;
import org.elasticsearch.index.shard.ShardId;

final class InternalIndexingStats
implements IndexingOperationListener {
    private final StatsHolder totalStats = new StatsHolder();

    InternalIndexingStats() {
    }

    IndexingStats stats(boolean isThrottled, long currentThrottleInMillis, long indexingTimeBeforeShardStartedInNanos, long timeSinceShardStartedInNanos) {
        IndexingStats.Stats total = this.totalStats.stats(isThrottled, currentThrottleInMillis, indexingTimeBeforeShardStartedInNanos, timeSinceShardStartedInNanos);
        return new IndexingStats(total);
    }

    long totalIndexingTimeInNanos() {
        return this.totalStats.indexMetric.sum();
    }

    @Override
    public Engine.Index preIndex(ShardId shardId, Engine.Index operation) {
        if (!operation.origin().isRecovery()) {
            this.totalStats.indexCurrent.inc();
        }
        return operation;
    }

    @Override
    public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
        switch (result.getResultType()) {
            case SUCCESS: {
                if (index.origin().isRecovery()) break;
                long took = result.getTook();
                this.totalStats.indexMetric.inc(took);
                this.totalStats.indexCurrent.dec();
                break;
            }
            case FAILURE: {
                this.postIndex(shardId, index, result.getFailure());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown result type: " + result.getResultType());
            }
        }
    }

    @Override
    public void postIndex(ShardId shardId, Engine.Index index, Exception ex) {
        if (!index.origin().isRecovery()) {
            this.totalStats.indexCurrent.dec();
            this.totalStats.indexFailed.inc();
        }
    }

    @Override
    public Engine.Delete preDelete(ShardId shardId, Engine.Delete delete) {
        if (!delete.origin().isRecovery()) {
            this.totalStats.deleteCurrent.inc();
        }
        return delete;
    }

    @Override
    public void postDelete(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
        switch (result.getResultType()) {
            case SUCCESS: {
                if (delete.origin().isRecovery()) break;
                long took = result.getTook();
                this.totalStats.deleteMetric.inc(took);
                this.totalStats.deleteCurrent.dec();
                break;
            }
            case FAILURE: {
                this.postDelete(shardId, delete, result.getFailure());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown result type: " + result.getResultType());
            }
        }
    }

    @Override
    public void postDelete(ShardId shardId, Engine.Delete delete, Exception ex) {
        if (!delete.origin().isRecovery()) {
            this.totalStats.deleteCurrent.dec();
        }
    }

    void noopUpdate() {
        this.totalStats.noopUpdates.inc();
    }

    static class StatsHolder {
        private final MeanMetric indexMetric = new MeanMetric();
        private final MeanMetric deleteMetric = new MeanMetric();
        private final CounterMetric indexCurrent = new CounterMetric();
        private final CounterMetric indexFailed = new CounterMetric();
        private final CounterMetric deleteCurrent = new CounterMetric();
        private final CounterMetric noopUpdates = new CounterMetric();

        StatsHolder() {
        }

        IndexingStats.Stats stats(boolean isThrottled, long currentThrottleMillis, long indexingTimeBeforeShardStartedInNanos, long timeSinceShardStartedInNanos) {
            long totalIndexingTimeInNanos = this.indexMetric.sum();
            long totalIndexingTimeSinceShardStartedInNanos = totalIndexingTimeInNanos - indexingTimeBeforeShardStartedInNanos;
            return new IndexingStats.Stats(this.indexMetric.count(), TimeUnit.NANOSECONDS.toMillis(totalIndexingTimeInNanos), this.indexCurrent.count(), this.indexFailed.count(), this.deleteMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.deleteMetric.sum()), this.deleteCurrent.count(), this.noopUpdates.count(), isThrottled, TimeUnit.MILLISECONDS.toMillis(currentThrottleMillis), totalIndexingTimeSinceShardStartedInNanos, timeSinceShardStartedInNanos);
        }
    }
}

