/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.features.ResetFeatureStateResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.TransportDeleteIndexAction;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.TriConsumer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.AssociatedIndexDescriptor;
import org.elasticsearch.indices.ExecutorSelector;
import org.elasticsearch.indices.IndexPatternMatcher;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.synonyms.SynonymsManagementAPIService;
import org.elasticsearch.tasks.TaskResultsService;

public class SystemIndices {
    public static final String SYSTEM_INDEX_ACCESS_CONTROL_HEADER_KEY = "_system_index_access_allowed";
    public static final String EXTERNAL_SYSTEM_INDEX_ACCESS_CONTROL_HEADER_KEY = "_external_system_index_access_origin";
    public static final String UPGRADED_INDEX_SUFFIX = "-reindexed-for-8";
    private static final Automaton EMPTY = Automata.makeEmpty();
    private static final Logger logger = LogManager.getLogger(SystemIndices.class);
    private static final Map<String, Feature> SERVER_SYSTEM_FEATURE_DESCRIPTORS = Stream.of(new Feature("tasks", "Manages task results", List.of(TaskResultsService.TASKS_DESCRIPTOR)), new Feature("synonyms", "Manages synonyms", List.of(SynonymsManagementAPIService.SYNONYMS_DESCRIPTOR))).collect(Collectors.toUnmodifiableMap(Feature::getName, Function.identity()));
    public static final Map<String, SystemIndexDescriptor.MappingsVersion> SERVER_SYSTEM_MAPPINGS_VERSIONS = SERVER_SYSTEM_FEATURE_DESCRIPTORS.values().stream().flatMap(feature -> feature.getIndexDescriptors().stream()).filter(SystemIndexDescriptor::isAutomaticallyManaged).collect(Collectors.toMap(SystemIndexDescriptor::getIndexPattern, SystemIndexDescriptor::getMappingsVersion));
    private final Map<String, Feature> featureDescriptors;
    private final Automaton systemNameAutomaton;
    private final CharacterRunAutomaton netNewSystemIndexAutomaton;
    private final CharacterRunAutomaton systemNameRunAutomaton;
    private final CharacterRunAutomaton systemIndexRunAutomaton;
    private final CharacterRunAutomaton systemDataStreamIndicesRunAutomaton;
    private final Predicate<String> systemDataStreamPredicate;
    private final SystemIndexDescriptor[] indexDescriptors;
    private final Map<String, SystemDataStreamDescriptor> dataStreamDescriptors;
    private final Map<String, CharacterRunAutomaton> productToSystemIndicesMatcher;
    private final ExecutorSelector executorSelector;

    public SystemIndices(List<Feature> pluginAndModuleFeatures) {
        this.featureDescriptors = SystemIndices.buildFeatureMap(pluginAndModuleFeatures);
        this.indexDescriptors = (SystemIndexDescriptor[])this.featureDescriptors.values().stream().flatMap(f -> f.getIndexDescriptors().stream()).toArray(SystemIndexDescriptor[]::new);
        this.dataStreamDescriptors = this.featureDescriptors.values().stream().flatMap(f -> f.getDataStreamDescriptors().stream()).collect(Collectors.toUnmodifiableMap(SystemDataStreamDescriptor::getDataStreamName, Function.identity()));
        SystemIndices.checkForOverlappingPatterns(this.featureDescriptors);
        SystemIndices.ensurePatternsAllowSuffix(this.featureDescriptors);
        SystemIndices.checkForDuplicateAliases(this.getSystemIndexDescriptors());
        Automaton systemIndexAutomata = SystemIndices.buildIndexAutomaton(this.featureDescriptors);
        this.systemIndexRunAutomaton = new CharacterRunAutomaton(systemIndexAutomata);
        Automaton systemDataStreamIndicesAutomata = SystemIndices.buildDataStreamBackingIndicesAutomaton(this.featureDescriptors);
        this.systemDataStreamIndicesRunAutomaton = new CharacterRunAutomaton(systemDataStreamIndicesAutomata);
        this.systemDataStreamPredicate = SystemIndices.buildDataStreamNamePredicate(this.featureDescriptors);
        this.netNewSystemIndexAutomaton = SystemIndices.buildNetNewIndexCharacterRunAutomaton(this.featureDescriptors);
        this.productToSystemIndicesMatcher = SystemIndices.getProductToSystemIndicesMap(this.featureDescriptors);
        this.executorSelector = new ExecutorSelector(this);
        this.systemNameAutomaton = MinimizationOperations.minimize((Automaton)Operations.union(List.of(systemIndexAutomata, systemDataStreamIndicesAutomata, SystemIndices.buildDataStreamAutomaton(this.featureDescriptors))), (int)10000);
        this.systemNameRunAutomaton = new CharacterRunAutomaton(this.systemNameAutomaton);
    }

    static void ensurePatternsAllowSuffix(Map<String, Feature> featureDescriptors) {
        String suffixPattern = "*-reindexed-for-8";
        List descriptorsWithNoRoomForSuffix = featureDescriptors.values().stream().flatMap(feature -> feature.getIndexDescriptors().stream().filter(descriptor -> !SystemIndices.overlaps(descriptor.getIndexPattern(), suffixPattern)).map(descriptor -> Strings.format((String)"pattern [%s] from feature [%s]", (Object[])new Object[]{descriptor.getIndexPattern(), feature.getName()}))).toList();
        if (!descriptorsWithNoRoomForSuffix.isEmpty()) {
            throw new IllegalStateException(Strings.format((String)"the following system index patterns do not allow suffix [%s] required to allow upgrades: [%s]", (Object[])new Object[]{UPGRADED_INDEX_SUFFIX, descriptorsWithNoRoomForSuffix}));
        }
    }

    private static void checkForDuplicateAliases(Collection<SystemIndexDescriptor> descriptors) {
        HashMap<String, Integer> aliasCounts = new HashMap<String, Integer>();
        for (SystemIndexDescriptor descriptor : descriptors) {
            String aliasName = descriptor.getAliasName();
            if (aliasName == null) continue;
            aliasCounts.compute(aliasName, (alias, existingCount) -> 1 + (existingCount == null ? 0 : existingCount));
        }
        List<String> duplicateAliases = aliasCounts.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).sorted().toList();
        if (!duplicateAliases.isEmpty()) {
            throw new IllegalStateException("Found aliases associated with multiple system index descriptors: " + duplicateAliases);
        }
    }

    private static Map<String, CharacterRunAutomaton> getProductToSystemIndicesMap(Map<String, Feature> featureDescriptors) {
        HashMap productToSystemIndicesMap = new HashMap();
        for (Feature feature : featureDescriptors.values()) {
            feature.getIndexDescriptors().forEach(systemIndexDescriptor -> {
                if (systemIndexDescriptor.isExternal()) {
                    systemIndexDescriptor.getAllowedElasticProductOrigins().forEach(origin -> productToSystemIndicesMap.compute(origin, (key, value) -> {
                        Automaton automaton = SystemIndexDescriptor.buildAutomaton(systemIndexDescriptor.getIndexPattern(), systemIndexDescriptor.getAliasName());
                        return value == null ? automaton : Operations.union((Automaton)value, (Automaton)automaton);
                    }));
                }
            });
            feature.getDataStreamDescriptors().forEach(dataStreamDescriptor -> {
                if (dataStreamDescriptor.isExternal()) {
                    dataStreamDescriptor.getAllowedElasticProductOrigins().forEach(origin -> productToSystemIndicesMap.compute(origin, (key, value) -> {
                        Automaton automaton = SystemIndexDescriptor.buildAutomaton(dataStreamDescriptor.getBackingIndexPattern(), dataStreamDescriptor.getDataStreamName());
                        return value == null ? automaton : Operations.union((Automaton)value, (Automaton)automaton);
                    }));
                }
            });
        }
        return productToSystemIndicesMap.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> new CharacterRunAutomaton(MinimizationOperations.minimize((Automaton)((Automaton)entry.getValue()), (int)10000))));
    }

    public boolean isSystemName(String name) {
        return this.systemNameRunAutomaton.run(name);
    }

    public boolean isSystemIndex(Index index) {
        return this.isSystemIndex(index.getName());
    }

    public boolean isSystemIndex(String indexName) {
        return this.systemIndexRunAutomaton.run(indexName);
    }

    public boolean isSystemDataStream(String name) {
        return this.systemDataStreamPredicate.test(name);
    }

    public boolean isSystemIndexBackingDataStream(String name) {
        return this.systemDataStreamIndicesRunAutomaton.run(name);
    }

    public Automaton getSystemNameAutomaton() {
        return this.systemNameAutomaton;
    }

    public boolean isNetNewSystemIndex(String indexName) {
        return this.netNewSystemIndexAutomaton.run(indexName);
    }

    public ExecutorSelector getExecutorSelector() {
        return this.executorSelector;
    }

    @Nullable
    public SystemIndexDescriptor findMatchingDescriptor(String name) {
        return SystemIndices.findMatchingDescriptor(this.indexDescriptors, name);
    }

    @Nullable
    static SystemIndexDescriptor findMatchingDescriptor(SystemIndexDescriptor[] indexDescriptors, String name) {
        SystemIndexDescriptor matchingDescriptor = null;
        for (SystemIndexDescriptor systemIndexDescriptor : indexDescriptors) {
            if (!systemIndexDescriptor.matchesIndexPattern(name)) continue;
            matchingDescriptor = systemIndexDescriptor;
            break;
        }
        return matchingDescriptor;
    }

    @Nullable
    public SystemDataStreamDescriptor findMatchingDataStreamDescriptor(String name) {
        return this.dataStreamDescriptors.get(name);
    }

    public Predicate<String> getProductSystemIndexNamePredicate(ThreadContext threadContext) {
        String product = threadContext.getHeader(EXTERNAL_SYSTEM_INDEX_ACCESS_CONTROL_HEADER_KEY);
        if (product == null) {
            return Predicates.never();
        }
        CharacterRunAutomaton automaton = this.productToSystemIndicesMatcher.get(product);
        if (automaton == null) {
            return Predicates.never();
        }
        return arg_0 -> ((CharacterRunAutomaton)automaton).run(arg_0);
    }

    public Set<String> getFeatureNames() {
        return Set.copyOf(this.featureDescriptors.keySet());
    }

    public Feature getFeature(String name) {
        return this.featureDescriptors.get(name);
    }

    public Collection<Feature> getFeatures() {
        return List.copyOf(this.featureDescriptors.values());
    }

    private static Automaton buildIndexAutomaton(Map<String, Feature> featureDescriptors) {
        Optional<Automaton> automaton = featureDescriptors.values().stream().map(SystemIndices::featureToIndexAutomaton).reduce(Operations::union);
        return MinimizationOperations.minimize((Automaton)automaton.orElse(EMPTY), (int)10000);
    }

    private static CharacterRunAutomaton buildNetNewIndexCharacterRunAutomaton(Map<String, Feature> featureDescriptors) {
        Optional<Automaton> automaton = featureDescriptors.values().stream().flatMap(feature -> feature.getIndexDescriptors().stream()).filter(SystemIndexDescriptor::isAutomaticallyManaged).filter(SystemIndexDescriptor::isNetNew).map(descriptor -> SystemIndexDescriptor.buildAutomaton(descriptor.getIndexPattern(), descriptor.getAliasName())).reduce(Operations::union);
        return new CharacterRunAutomaton(MinimizationOperations.minimize((Automaton)automaton.orElse(EMPTY), (int)10000));
    }

    private static Automaton featureToIndexAutomaton(Feature feature) {
        Optional<Automaton> systemIndexAutomaton = feature.getIndexDescriptors().stream().map(descriptor -> SystemIndexDescriptor.buildAutomaton(descriptor.getIndexPattern(), descriptor.getAliasName())).reduce(Operations::union);
        return systemIndexAutomaton.orElse(EMPTY);
    }

    private static Automaton buildDataStreamAutomaton(Map<String, Feature> featureDescriptors) {
        Optional<Automaton> automaton = featureDescriptors.values().stream().flatMap(feature -> feature.getDataStreamDescriptors().stream()).map(SystemDataStreamDescriptor::getDataStreamName).map(dsName -> SystemIndexDescriptor.buildAutomaton(dsName, null)).reduce(Operations::union);
        return automaton.isPresent() ? MinimizationOperations.minimize((Automaton)automaton.get(), (int)10000) : EMPTY;
    }

    private static Predicate<String> buildDataStreamNamePredicate(Map<String, Feature> featureDescriptors) {
        CharacterRunAutomaton characterRunAutomaton = new CharacterRunAutomaton(SystemIndices.buildDataStreamAutomaton(featureDescriptors));
        return arg_0 -> ((CharacterRunAutomaton)characterRunAutomaton).run(arg_0);
    }

    private static Automaton buildDataStreamBackingIndicesAutomaton(Map<String, Feature> featureDescriptors) {
        Optional<Automaton> automaton = featureDescriptors.values().stream().map(SystemIndices::featureToDataStreamBackingIndicesAutomaton).reduce(Operations::union);
        return MinimizationOperations.minimize((Automaton)automaton.orElse(EMPTY), (int)10000);
    }

    private static Automaton featureToDataStreamBackingIndicesAutomaton(Feature feature) {
        Optional<Automaton> systemDataStreamAutomaton = feature.getDataStreamDescriptors().stream().map(descriptor -> SystemIndexDescriptor.buildAutomaton(descriptor.getBackingIndexPattern(), null)).reduce(Operations::union);
        return systemDataStreamAutomaton.orElse(EMPTY);
    }

    public SystemDataStreamDescriptor validateDataStreamAccess(String dataStreamName, ThreadContext threadContext) {
        if (this.systemDataStreamPredicate.test(dataStreamName)) {
            SystemDataStreamDescriptor dataStreamDescriptor = this.featureDescriptors.values().stream().flatMap(feature -> feature.getDataStreamDescriptors().stream()).filter(descriptor -> descriptor.getDataStreamName().equals(dataStreamName)).findFirst().orElseThrow(() -> new IllegalStateException("system data stream descriptor not found for [" + dataStreamName + "]"));
            if (dataStreamDescriptor.isExternal()) {
                SystemIndexAccessLevel accessLevel = SystemIndices.getSystemIndexAccessLevel(threadContext);
                assert (accessLevel != SystemIndexAccessLevel.BACKWARDS_COMPATIBLE_ONLY) : "BACKWARDS_COMPATIBLE access level is leaking";
                if (accessLevel == SystemIndexAccessLevel.NONE) {
                    throw SystemIndices.dataStreamAccessException(null, dataStreamName);
                }
                if (accessLevel == SystemIndexAccessLevel.RESTRICTED) {
                    if (!this.getProductSystemIndexNamePredicate(threadContext).test(dataStreamName)) {
                        throw SystemIndices.dataStreamAccessException(threadContext.getHeader(EXTERNAL_SYSTEM_INDEX_ACCESS_CONTROL_HEADER_KEY), dataStreamName);
                    }
                    return dataStreamDescriptor;
                }
                assert (accessLevel == SystemIndexAccessLevel.ALL || accessLevel == SystemIndexAccessLevel.BACKWARDS_COMPATIBLE_ONLY);
                return dataStreamDescriptor;
            }
            return dataStreamDescriptor;
        }
        return null;
    }

    public static IllegalArgumentException dataStreamAccessException(ThreadContext threadContext, Collection<String> names) {
        return SystemIndices.dataStreamAccessException(threadContext.getHeader(EXTERNAL_SYSTEM_INDEX_ACCESS_CONTROL_HEADER_KEY), names.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY));
    }

    public static IllegalArgumentException netNewSystemIndexAccessException(ThreadContext threadContext, Collection<String> names) {
        String product = threadContext.getHeader(EXTERNAL_SYSTEM_INDEX_ACCESS_CONTROL_HEADER_KEY);
        if (product == null) {
            return new IllegalArgumentException("Indices " + Arrays.toString(names.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY)) + " use and access is reserved for system operations");
        }
        return new IllegalArgumentException("Indices " + Arrays.toString(names.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY)) + " may not be accessed by product [" + product + "]");
    }

    static IllegalArgumentException dataStreamAccessException(@Nullable String product, String ... dataStreamNames) {
        if (product == null) {
            return new IllegalArgumentException("Data stream(s) " + Arrays.toString(dataStreamNames) + " use and access is reserved for system operations");
        }
        return new IllegalArgumentException("Data stream(s) " + Arrays.toString(dataStreamNames) + " may not be accessed by product [" + product + "]");
    }

    public static SystemIndexAccessLevel getSystemIndexAccessLevel(ThreadContext threadContext) {
        String headerValue = threadContext.getHeader(SYSTEM_INDEX_ACCESS_CONTROL_HEADER_KEY);
        boolean allowed = Booleans.parseBoolean((String)headerValue, (boolean)true);
        if (allowed) {
            if (threadContext.getHeader(EXTERNAL_SYSTEM_INDEX_ACCESS_CONTROL_HEADER_KEY) != null) {
                return SystemIndexAccessLevel.RESTRICTED;
            }
            return SystemIndexAccessLevel.ALL;
        }
        return SystemIndexAccessLevel.NONE;
    }

    static void checkForOverlappingPatterns(Map<String, Feature> featureDescriptors) {
        List<Tuple> sourceDescriptorPair = featureDescriptors.values().stream().flatMap(feature -> feature.getIndexDescriptors().stream().map(descriptor -> new Tuple((Object)feature.getName(), descriptor))).sorted(Comparator.comparing(d -> (String)d.v1() + ":" + ((SystemIndexDescriptor)d.v2()).getIndexPattern())).toList();
        List<Tuple> sourceDataStreamDescriptorPair = featureDescriptors.values().stream().filter(feature -> !feature.getDataStreamDescriptors().isEmpty()).flatMap(feature -> feature.getDataStreamDescriptors().stream().map(descriptor -> new Tuple((Object)feature.getName(), descriptor))).sorted(Comparator.comparing(d -> (String)d.v1() + ":" + ((SystemDataStreamDescriptor)d.v2()).getDataStreamName())).toList();
        sourceDescriptorPair.forEach(descriptorToCheck -> {
            List<Tuple> descriptorsMatchingThisPattern = sourceDescriptorPair.stream().filter(d -> descriptorToCheck.v2() != d.v2()).filter(d -> SystemIndices.overlaps((SystemIndexDescriptor)descriptorToCheck.v2(), (SystemIndexDescriptor)d.v2()) || ((SystemIndexDescriptor)d.v2()).getAliasName() != null && ((SystemIndexDescriptor)descriptorToCheck.v2()).matchesIndexPattern(((SystemIndexDescriptor)d.v2()).getAliasName())).toList();
            if (!descriptorsMatchingThisPattern.isEmpty()) {
                throw new IllegalStateException("a system index descriptor [" + descriptorToCheck.v2() + "] from [" + (String)descriptorToCheck.v1() + "] overlaps with other system index descriptors: [" + descriptorsMatchingThisPattern.stream().map(descriptor -> descriptor.v2() + " from [" + (String)descriptor.v1() + "]").collect(Collectors.joining(", ")));
            }
            List<Tuple> dataStreamsMatching = sourceDataStreamDescriptorPair.stream().filter(dsTuple -> ((SystemIndexDescriptor)descriptorToCheck.v2()).matchesIndexPattern(((SystemDataStreamDescriptor)dsTuple.v2()).getDataStreamName()) || SystemIndices.overlaps(((SystemIndexDescriptor)descriptorToCheck.v2()).getIndexPattern(), ((SystemDataStreamDescriptor)dsTuple.v2()).getBackingIndexPattern())).toList();
            if (!dataStreamsMatching.isEmpty()) {
                throw new IllegalStateException("a system index descriptor [" + descriptorToCheck.v2() + "] from [" + (String)descriptorToCheck.v1() + "] overlaps with one or more data stream descriptors: [" + dataStreamsMatching.stream().map(descriptor -> descriptor.v2() + " from [" + (String)descriptor.v1() + "]").collect(Collectors.joining(", ")));
            }
        });
    }

    private static boolean overlaps(SystemIndexDescriptor a1, SystemIndexDescriptor a2) {
        return SystemIndices.overlaps(a1.getIndexPattern(), a2.getIndexPattern());
    }

    private static boolean overlaps(String pattern1, String pattern2) {
        Automaton a2Automaton;
        Automaton a1Automaton = SystemIndexDescriptor.buildAutomaton(pattern1, null);
        return !Operations.isEmpty((Automaton)Operations.intersection((Automaton)a1Automaton, (Automaton)(a2Automaton = SystemIndexDescriptor.buildAutomaton(pattern2, null))));
    }

    private static Map<String, Feature> buildFeatureMap(List<Feature> features) {
        Map map = Maps.newMapWithExpectedSize(features.size() + SERVER_SYSTEM_FEATURE_DESCRIPTORS.size());
        features.forEach(feature -> map.put(feature.getName(), feature));
        SERVER_SYSTEM_FEATURE_DESCRIPTORS.forEach((source, feature) -> {
            if (map.putIfAbsent(source, feature) != null) {
                throw new IllegalArgumentException("plugin or module attempted to define the same source [" + source + "] as a built-in system index");
            }
        });
        return Map.copyOf(map);
    }

    Collection<SystemIndexDescriptor> getSystemIndexDescriptors() {
        return this.featureDescriptors.values().stream().flatMap(f -> f.getIndexDescriptors().stream()).toList();
    }

    public Map<String, SystemIndexDescriptor.MappingsVersion> getMappingsVersions() {
        return this.getSystemIndexDescriptors().stream().filter(SystemIndexDescriptor::isAutomaticallyManaged).collect(Collectors.toMap(SystemIndexDescriptor::getPrimaryIndex, SystemIndexDescriptor::getMappingsVersion));
    }

    public static void validateFeatureName(String name, String plugin) {
        if ("none".equalsIgnoreCase(name)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "feature name cannot be reserved name [\"%s\"], but was for plugin [%s]", "none", plugin));
        }
    }

    public static class Feature {
        private final String name;
        private final String description;
        private final Collection<SystemIndexDescriptor> indexDescriptors;
        private final Collection<SystemDataStreamDescriptor> dataStreamDescriptors;
        private final Collection<AssociatedIndexDescriptor> associatedIndexDescriptors;
        private final TriConsumer<ClusterService, Client, ActionListener<ResetFeatureStateResponse.ResetFeatureStateStatus>> cleanUpFunction;
        private final MigrationPreparationHandler preMigrationFunction;
        private final MigrationCompletionHandler postMigrationFunction;

        public Feature(String name, String description, Collection<SystemIndexDescriptor> indexDescriptors, Collection<SystemDataStreamDescriptor> dataStreamDescriptors, Collection<AssociatedIndexDescriptor> associatedIndexDescriptors, TriConsumer<ClusterService, Client, ActionListener<ResetFeatureStateResponse.ResetFeatureStateStatus>> cleanUpFunction, MigrationPreparationHandler preMigrationFunction, MigrationCompletionHandler postMigrationFunction) {
            this.name = name;
            this.description = description;
            this.indexDescriptors = indexDescriptors;
            this.dataStreamDescriptors = dataStreamDescriptors;
            this.associatedIndexDescriptors = associatedIndexDescriptors;
            this.cleanUpFunction = cleanUpFunction;
            this.preMigrationFunction = preMigrationFunction;
            this.postMigrationFunction = postMigrationFunction;
        }

        public Feature(String name, String description, Collection<SystemIndexDescriptor> indexDescriptors) {
            this(name, description, indexDescriptors, Collections.emptyList(), Collections.emptyList(), (clusterService, client, listener) -> Feature.cleanUpFeature(indexDescriptors, Collections.emptyList(), name, clusterService, client, listener), Feature::noopPreMigrationFunction, Feature::noopPostMigrationFunction);
        }

        public Feature(String name, String description, Collection<SystemIndexDescriptor> indexDescriptors, Collection<SystemDataStreamDescriptor> dataStreamDescriptors) {
            this(name, description, indexDescriptors, dataStreamDescriptors, Collections.emptyList(), (clusterService, client, listener) -> Feature.cleanUpFeature(indexDescriptors, Collections.emptyList(), name, clusterService, client, listener), Feature::noopPreMigrationFunction, Feature::noopPostMigrationFunction);
        }

        public static Feature fromSystemIndexPlugin(SystemIndexPlugin plugin, Settings settings) {
            return new Feature(plugin.getFeatureName(), plugin.getFeatureDescription(), plugin.getSystemIndexDescriptors(settings), plugin.getSystemDataStreamDescriptors(), plugin.getAssociatedIndexDescriptors(), plugin::cleanUpFeature, plugin::prepareForIndicesMigration, plugin::indicesMigrationComplete);
        }

        public String getDescription() {
            return this.description;
        }

        public Collection<SystemIndexDescriptor> getIndexDescriptors() {
            return this.indexDescriptors;
        }

        public Collection<SystemDataStreamDescriptor> getDataStreamDescriptors() {
            return this.dataStreamDescriptors;
        }

        public Collection<AssociatedIndexDescriptor> getAssociatedIndexDescriptors() {
            return this.associatedIndexDescriptors;
        }

        public TriConsumer<ClusterService, Client, ActionListener<ResetFeatureStateResponse.ResetFeatureStateStatus>> getCleanUpFunction() {
            return this.cleanUpFunction;
        }

        public String getName() {
            return this.name;
        }

        public MigrationPreparationHandler getPreMigrationFunction() {
            return this.preMigrationFunction;
        }

        public MigrationCompletionHandler getPostMigrationFunction() {
            return this.postMigrationFunction;
        }

        private static void cleanUpFeatureForIndices(final String name, Client client, String[] indexNames, final ActionListener<ResetFeatureStateResponse.ResetFeatureStateStatus> listener) {
            DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest();
            deleteIndexRequest.indices(indexNames);
            client.execute(TransportDeleteIndexAction.TYPE, deleteIndexRequest, new ActionListener<AcknowledgedResponse>(){

                @Override
                public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                    listener.onResponse(ResetFeatureStateResponse.ResetFeatureStateStatus.success(name));
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onResponse(ResetFeatureStateResponse.ResetFeatureStateStatus.failure(name, e));
                }
            });
        }

        public static void cleanUpFeature(Collection<SystemIndexDescriptor> indexDescriptors, Collection<? extends IndexPatternMatcher> associatedIndexDescriptors, String name, ClusterService clusterService, Client client, ActionListener<ResetFeatureStateResponse.ResetFeatureStateStatus> listener) {
            Metadata metadata = clusterService.state().getMetadata();
            ArrayList exceptions = new ArrayList();
            CheckedConsumer handleResponse = resetFeatureStateStatus -> {
                if (resetFeatureStateStatus.getStatus() == ResetFeatureStateResponse.ResetFeatureStateStatus.Status.FAILURE) {
                    List list = exceptions;
                    synchronized (list) {
                        exceptions.add(resetFeatureStateStatus.getException());
                    }
                }
            };
            try (RefCountingListener listeners = new RefCountingListener(listener.map(ignored -> {
                if (exceptions.isEmpty()) {
                    return ResetFeatureStateResponse.ResetFeatureStateStatus.success(name);
                }
                for (Exception exception : exceptions) {
                    logger.warn(() -> "error while resetting feature [" + name + "]", (Throwable)exception);
                }
                return ResetFeatureStateResponse.ResetFeatureStateStatus.failure(name, new Exception(exceptions.stream().map(Throwable::getMessage).collect(Collectors.joining(", ", "[", "]"))));
            }));){
                String[] associatedIndices = (String[])associatedIndexDescriptors.stream().flatMap(descriptor -> descriptor.getMatchingIndices(metadata).stream()).toArray(String[]::new);
                if (associatedIndices.length > 0) {
                    Feature.cleanUpFeatureForIndices(name, client, associatedIndices, listeners.acquire(handleResponse));
                }
                for (SystemIndexDescriptor indexDescriptor : indexDescriptors) {
                    List<String> matchingIndices = indexDescriptor.getMatchingIndices(metadata);
                    if (matchingIndices.isEmpty()) continue;
                    Client clientWithOrigin = indexDescriptor.getOrigin() == null ? client : new OriginSettingClient(client, indexDescriptor.getOrigin());
                    Feature.cleanUpFeatureForIndices(name, clientWithOrigin, matchingIndices.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY), listeners.acquire(handleResponse));
                }
            }
        }

        private static void noopPreMigrationFunction(ClusterService clusterService, Client client, ActionListener<Map<String, Object>> listener) {
            listener.onResponse(Collections.emptyMap());
        }

        private static void noopPostMigrationFunction(Map<String, Object> preUpgradeMetadata, ClusterService clusterService, Client client, ActionListener<Boolean> listener) {
            listener.onResponse(true);
        }

        @FunctionalInterface
        public static interface MigrationPreparationHandler {
            public void prepareForIndicesMigration(ClusterService var1, Client var2, ActionListener<Map<String, Object>> var3);
        }

        @FunctionalInterface
        public static interface MigrationCompletionHandler {
            public void indicesMigrationComplete(Map<String, Object> var1, ClusterService var2, Client var3, ActionListener<Boolean> var4);
        }
    }

    public static enum SystemIndexAccessLevel {
        ALL,
        NONE,
        RESTRICTED,
        BACKWARDS_COMPATIBLE_ONLY;

    }
}

