/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference.configuration;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.inference.configuration.SettingsConfigurationValidationType;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;

public class SettingsConfigurationValidation
implements Writeable,
ToXContentObject {
    private final Object constraint;
    private final SettingsConfigurationValidationType type;
    private static final ParseField CONSTRAINT_FIELD = new ParseField("constraint", new String[0]);
    private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ConstructingObjectParser<SettingsConfigurationValidation, Void> PARSER = new ConstructingObjectParser("service_configuration_validation", true, args -> new Builder().setConstraint(args[0]).setType((SettingsConfigurationValidationType)((Object)((Object)args[1]))).build());

    private SettingsConfigurationValidation(Object constraint, SettingsConfigurationValidationType type) {
        this.constraint = constraint;
        this.type = type;
    }

    public SettingsConfigurationValidation(StreamInput in) throws IOException {
        this.constraint = in.readGenericValue();
        this.type = in.readEnum(SettingsConfigurationValidationType.class);
    }

    private static Object parseConstraintValue(XContentParser p) throws IOException {
        if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
            return p.text();
        }
        if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
            return p.numberValue();
        }
        if (p.currentToken() == XContentParser.Token.START_ARRAY) {
            return p.list();
        }
        throw new XContentParseException("Unsupported token [" + p.currentToken() + "]");
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(CONSTRAINT_FIELD.getPreferredName(), this.constraint);
        builder.field(TYPE_FIELD.getPreferredName(), this.type.toString());
        builder.endObject();
        return builder;
    }

    public Map<String, Object> toMap() {
        return Map.of(CONSTRAINT_FIELD.getPreferredName(), this.constraint, TYPE_FIELD.getPreferredName(), this.type.toString());
    }

    public static SettingsConfigurationValidation fromXContent(XContentParser parser) throws IOException {
        return (SettingsConfigurationValidation)PARSER.parse(parser, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeGenericValue(this.constraint);
        out.writeEnum(this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SettingsConfigurationValidation that = (SettingsConfigurationValidation)o;
        return Objects.equals(this.constraint, that.constraint) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.constraint, this.type});
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> SettingsConfigurationValidation.parseConstraintValue(p), CONSTRAINT_FIELD, ObjectParser.ValueType.VALUE_OBJECT_ARRAY);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> SettingsConfigurationValidationType.validationType(p.text()), TYPE_FIELD, ObjectParser.ValueType.STRING);
    }

    public static class Builder {
        private Object constraint;
        private SettingsConfigurationValidationType type;

        public Builder setConstraint(Object constraint) {
            this.constraint = constraint;
            return this;
        }

        public Builder setType(SettingsConfigurationValidationType type) {
            this.type = type;
            return this;
        }

        public SettingsConfigurationValidation build() {
            return new SettingsConfigurationValidation(this.constraint, this.type);
        }
    }
}

