/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.ingest.GraphStructureException;
import org.elasticsearch.ingest.IngestCtxMap;
import org.elasticsearch.ingest.IngestDocMetadata;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.ValueSource;
import org.elasticsearch.script.CtxMap;
import org.elasticsearch.script.TemplateScript;

public final class IngestDocument {
    public static final String INGEST_KEY = "_ingest";
    public static final String SOURCE_KEY = "_source";
    private static final String INGEST_KEY_PREFIX = "_ingest.";
    private static final String SOURCE_PREFIX = "_source.";
    private static final String PIPELINE_CYCLE_ERROR_MESSAGE = "Cycle detected for pipeline: ";
    static final String TIMESTAMP = "timestamp";
    public static final int MAX_PIPELINES = Integer.parseInt(System.getProperty("es.ingest.max_pipelines", "100"));
    private final IngestCtxMap ctxMap;
    private final Map<String, Object> ingestMetadata;
    private final DelegatingMapView templateModel;
    private final Set<String> executedPipelines = new LinkedHashSet<String>();
    private Set<String> indexHistory = new LinkedHashSet<String>();
    private boolean doNoSelfReferencesCheck = false;
    private boolean reroute = false;
    private boolean terminate = false;

    public IngestDocument(String index, String id, long version, String routing, VersionType versionType, Map<String, Object> source) {
        this.ctxMap = new IngestCtxMap(index, id, version, routing, versionType, ZonedDateTime.now(ZoneOffset.UTC), source);
        this.ingestMetadata = new HashMap<String, Object>();
        this.ingestMetadata.put(TIMESTAMP, ((IngestDocMetadata)this.ctxMap.getMetadata()).getNow());
        this.templateModel = this.initializeTemplateModel();
        this.indexHistory.add(index);
    }

    public IngestDocument(IngestDocument other) {
        this(new IngestCtxMap(IngestDocument.deepCopyMap(IngestDocument.ensureNoSelfReferences(other.ctxMap.getSource())), ((IngestDocMetadata)other.ctxMap.getMetadata()).clone()), IngestDocument.deepCopyMap(other.ingestMetadata));
        this.executedPipelines.addAll(other.executedPipelines);
    }

    private static Map<String, Object> ensureNoSelfReferences(Map<String, Object> source) {
        CollectionUtils.ensureNoSelfReferences(source, null);
        return source;
    }

    public IngestDocument(Map<String, Object> sourceAndMetadata, Map<String, Object> ingestMetadata) {
        Map<String, Object> metadata;
        HashMap<String, Object> source;
        if (sourceAndMetadata instanceof IngestCtxMap) {
            IngestCtxMap ingestCtxMap = (IngestCtxMap)sourceAndMetadata;
            source = new HashMap<String, Object>(ingestCtxMap.getSource());
            metadata = new HashMap<String, Object>(((IngestDocMetadata)ingestCtxMap.getMetadata()).getMap());
        } else {
            metadata = Maps.newHashMapWithExpectedSize(Metadata.METADATA_NAMES.size());
            source = new HashMap<String, Object>(sourceAndMetadata);
            for (String key : Metadata.METADATA_NAMES) {
                if (!sourceAndMetadata.containsKey(key)) continue;
                metadata.put(key, source.remove(key));
            }
        }
        this.ctxMap = new IngestCtxMap((Map<String, Object>)source, new IngestDocMetadata(metadata, IngestCtxMap.getTimestamp(ingestMetadata)));
        this.ingestMetadata = new HashMap<String, Object>(ingestMetadata);
        this.templateModel = this.initializeTemplateModel();
    }

    IngestDocument(IngestCtxMap ctxMap, Map<String, Object> ingestMetadata) {
        this.ctxMap = Objects.requireNonNull(ctxMap);
        this.ingestMetadata = Objects.requireNonNull(ingestMetadata);
        this.templateModel = this.initializeTemplateModel();
    }

    private DelegatingMapView initializeTemplateModel() {
        return new DelegatingMapView(this.ctxMap, Map.of(SOURCE_KEY, this.ctxMap, INGEST_KEY, this.ingestMetadata));
    }

    public <T> T getFieldValue(String path, Class<T> clazz) {
        return this.getFieldValue(path, clazz, false);
    }

    public <T> T getFieldValue(String path, Class<T> clazz, boolean ignoreMissing) {
        FieldPath fieldPath = new FieldPath(path);
        Object context = fieldPath.initialContext;
        for (String pathElement : fieldPath.pathElements) {
            ResolveResult result = IngestDocument.resolve(pathElement, path, context);
            if (!result.wasSuccessful) {
                if (ignoreMissing && !this.hasField(path)) {
                    return null;
                }
                throw new IllegalArgumentException(result.errorMessage);
            }
            context = result.resolvedObject;
        }
        return IngestDocument.cast(path, context, clazz);
    }

    public byte[] getFieldValueAsBytes(String path) {
        return this.getFieldValueAsBytes(path, false);
    }

    public byte[] getFieldValueAsBytes(String path, boolean ignoreMissing) {
        Object object = this.getFieldValue(path, Object.class, ignoreMissing);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return bytes;
        }
        if (object instanceof String) {
            String string = (String)object;
            return Base64.getDecoder().decode(string);
        }
        throw new IllegalArgumentException("Content field [" + path + "] of unknown type [" + object.getClass().getName() + "], must be string or byte array");
    }

    public boolean hasField(String path) {
        return this.hasField(path, false);
    }

    public boolean hasField(String path, boolean failOutOfRange) {
        FieldPath fieldPath = new FieldPath(path);
        Object context = fieldPath.initialContext;
        for (int i = 0; i < fieldPath.pathElements.length - 1; ++i) {
            String pathElement = fieldPath.pathElements[i];
            if (context == null) {
                return false;
            }
            if (context instanceof Map) {
                Map map = (Map)context;
                context = map.get(pathElement);
                continue;
            }
            if (context instanceof List) {
                List list = (List)context;
                try {
                    int index = Integer.parseInt(pathElement);
                    if (index < 0 || index >= list.size()) {
                        if (failOutOfRange) {
                            throw new IllegalArgumentException("[" + index + "] is out of bounds for array with length [" + list.size() + "] as part of path [" + path + "]");
                        }
                        return false;
                    }
                    context = list.get(index);
                    continue;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return false;
        }
        String leafKey = fieldPath.pathElements[fieldPath.pathElements.length - 1];
        if (context instanceof Map) {
            Map map = (Map)context;
            return map.containsKey(leafKey);
        }
        if (context instanceof List) {
            List list = (List)context;
            try {
                int index = Integer.parseInt(leafKey);
                if (index >= 0 && index < list.size()) {
                    return true;
                }
                if (failOutOfRange) {
                    throw new IllegalArgumentException("[" + index + "] is out of bounds for array with length [" + list.size() + "] as part of path [" + path + "]");
                }
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public void removeField(String path) {
        FieldPath fieldPath = new FieldPath(path);
        Object context = fieldPath.initialContext;
        for (int i = 0; i < fieldPath.pathElements.length - 1; ++i) {
            ResolveResult result = IngestDocument.resolve(fieldPath.pathElements[i], path, context);
            if (!result.wasSuccessful) {
                throw new IllegalArgumentException(result.errorMessage);
            }
            context = result.resolvedObject;
        }
        String leafKey = fieldPath.pathElements[fieldPath.pathElements.length - 1];
        if (context instanceof Map) {
            Map map = (Map)context;
            if (map.containsKey(leafKey)) {
                map.remove(leafKey);
                return;
            }
            throw new IllegalArgumentException("field [" + leafKey + "] not present as part of path [" + path + "]");
        }
        if (context instanceof List) {
            int index;
            List list = (List)context;
            try {
                index = Integer.parseInt(leafKey);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("[" + leafKey + "] is not an integer, cannot be used as an index as part of path [" + path + "]", e);
            }
            if (index < 0 || index >= list.size()) {
                throw new IllegalArgumentException("[" + index + "] is out of bounds for array with length [" + list.size() + "] as part of path [" + path + "]");
            }
            list.remove(index);
            return;
        }
        if (context == null) {
            throw new IllegalArgumentException("cannot remove [" + leafKey + "] from null as part of path [" + path + "]");
        }
        throw new IllegalArgumentException("cannot remove [" + leafKey + "] from object of type [" + context.getClass().getName() + "] as part of path [" + path + "]");
    }

    private static ResolveResult resolve(String pathElement, String fullPath, Object context) {
        if (context == null) {
            return ResolveResult.error("cannot resolve [" + pathElement + "] from null as part of path [" + fullPath + "]");
        }
        if (context instanceof Map) {
            Map map = (Map)context;
            if (map.containsKey(pathElement)) {
                return ResolveResult.success(map.get(pathElement));
            }
            return ResolveResult.error("field [" + pathElement + "] not present as part of path [" + fullPath + "]");
        }
        if (context instanceof List) {
            int index;
            List list = (List)context;
            try {
                index = Integer.parseInt(pathElement);
            }
            catch (NumberFormatException e) {
                return ResolveResult.error("[" + pathElement + "] is not an integer, cannot be used as an index as part of path [" + fullPath + "]");
            }
            if (index < 0 || index >= list.size()) {
                return ResolveResult.error("[" + index + "] is out of bounds for array with length [" + list.size() + "] as part of path [" + fullPath + "]");
            }
            return ResolveResult.success(list.get(index));
        }
        return ResolveResult.error("cannot resolve [" + pathElement + "] from object of type [" + context.getClass().getName() + "] as part of path [" + fullPath + "]");
    }

    public void appendFieldValue(String path, Object value) {
        this.appendFieldValue(path, value, true);
    }

    public void appendFieldValue(String path, Object value, boolean allowDuplicates) {
        this.setFieldValue(path, value, true, allowDuplicates);
    }

    public void appendFieldValue(String path, ValueSource valueSource, boolean allowDuplicates) {
        this.appendFieldValue(path, valueSource.copyAndResolve(this.templateModel), allowDuplicates);
    }

    public void setFieldValue(String path, Object value) {
        this.setFieldValue(path, value, false, true);
    }

    public void setFieldValue(String path, ValueSource valueSource) {
        this.setFieldValue(path, valueSource.copyAndResolve(this.templateModel));
    }

    public void setFieldValue(String path, ValueSource valueSource, boolean ignoreEmptyValue) {
        Object value = valueSource.copyAndResolve(this.templateModel);
        if (ignoreEmptyValue && valueSource instanceof ValueSource.TemplatedValue) {
            if (value == null) {
                return;
            }
            String valueStr = (String)value;
            if (valueStr.isEmpty()) {
                return;
            }
        }
        this.setFieldValue(path, value);
    }

    public void setFieldValue(String path, Object value, boolean ignoreEmptyValue) {
        if (ignoreEmptyValue) {
            String string;
            if (value == null) {
                return;
            }
            if (value instanceof String && (string = (String)value).isEmpty()) {
                return;
            }
        }
        this.setFieldValue(path, value);
    }

    private void setFieldValue(String path, Object value, boolean append, boolean allowDuplicates) {
        ArrayList<Object> list;
        FieldPath fieldPath = new FieldPath(path);
        HashMap context = fieldPath.initialContext;
        for (int i = 0; i < fieldPath.pathElements.length - 1; ++i) {
            String pathElement = fieldPath.pathElements[i];
            if (context == null) {
                throw new IllegalArgumentException("cannot resolve [" + pathElement + "] from null as part of path [" + path + "]");
            }
            if (context instanceof Map) {
                Map map = context;
                if (map.containsKey(pathElement)) {
                    context = map.get(pathElement);
                    continue;
                }
                HashMap newMap = new HashMap();
                map.put(pathElement, newMap);
                context = newMap;
                continue;
            }
            if (context instanceof List) {
                int index;
                list = (ArrayList<Object>)((Object)context);
                try {
                    index = Integer.parseInt(pathElement);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("[" + pathElement + "] is not an integer, cannot be used as an index as part of path [" + path + "]", e);
                }
                if (index < 0 || index >= list.size()) {
                    throw new IllegalArgumentException("[" + index + "] is out of bounds for array with length [" + list.size() + "] as part of path [" + path + "]");
                }
                context = list.get(index);
                continue;
            }
            throw new IllegalArgumentException("cannot resolve [" + pathElement + "] from object of type [" + context.getClass().getName() + "] as part of path [" + path + "]");
        }
        String leafKey = fieldPath.pathElements[fieldPath.pathElements.length - 1];
        if (context == null) {
            throw new IllegalArgumentException("cannot set [" + leafKey + "] with null parent as part of path [" + path + "]");
        }
        if (context instanceof Map) {
            Map map = context;
            if (append) {
                if (map.containsKey(leafKey)) {
                    Object object = map.get(leafKey);
                    Object list2 = IngestDocument.appendValues(object, value, allowDuplicates);
                    if (list2 != object) {
                        map.put(leafKey, list2);
                    }
                } else {
                    list = new ArrayList<Object>();
                    IngestDocument.appendValues(list, value);
                    map.put(leafKey, list);
                }
                return;
            }
            map.put(leafKey, value);
        } else if (context instanceof List) {
            int index;
            List list3 = (List)((Object)context);
            try {
                index = Integer.parseInt(leafKey);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("[" + leafKey + "] is not an integer, cannot be used as an index as part of path [" + path + "]", e);
            }
            if (index < 0 || index >= list3.size()) {
                throw new IllegalArgumentException("[" + index + "] is out of bounds for array with length [" + list3.size() + "] as part of path [" + path + "]");
            }
            if (append) {
                Object object = list3.get(index);
                Object newList = IngestDocument.appendValues(object, value, allowDuplicates);
                if (newList != object) {
                    list3.set(index, newList);
                }
                return;
            }
            list3.set(index, value);
        } else {
            throw new IllegalArgumentException("cannot set [" + leafKey + "] with parent object of type [" + context.getClass().getName() + "] as part of path [" + path + "]");
        }
    }

    private static Object appendValues(Object maybeList, Object value, boolean allowDuplicates) {
        ArrayList<Object> list;
        if (maybeList instanceof List) {
            list = (ArrayList<Object>)maybeList;
        } else {
            list = new ArrayList<Object>();
            list.add(maybeList);
        }
        if (allowDuplicates) {
            IngestDocument.appendValues(list, value);
            return list;
        }
        return IngestDocument.appendValuesWithoutDuplicates(list, value) ? list : maybeList;
    }

    private static void appendValues(List<Object> list, Object value) {
        if (value instanceof List) {
            List l = (List)value;
            list.addAll(l);
        } else {
            list.add(value);
        }
    }

    private static boolean appendValuesWithoutDuplicates(List<Object> list, Object value) {
        boolean valuesWereAppended = false;
        if (value instanceof List) {
            List valueList = (List)value;
            for (Object val : valueList) {
                if (list.contains(val)) continue;
                list.add(val);
                valuesWereAppended = true;
            }
        } else if (!list.contains(value)) {
            list.add(value);
            valuesWereAppended = true;
        }
        return valuesWereAppended;
    }

    private static <T> T cast(String path, Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        throw new IllegalArgumentException("field [" + path + "] of type [" + object.getClass().getName() + "] cannot be cast to [" + clazz.getName() + "]");
    }

    public String renderTemplate(TemplateScript.Factory template) {
        return template.newInstance(this.templateModel).execute();
    }

    public Map<String, Object> getSourceAndMetadata() {
        return this.ctxMap;
    }

    public CtxMap<?> getCtxMap() {
        return this.ctxMap;
    }

    public org.elasticsearch.script.Metadata getMetadata() {
        return this.ctxMap.getMetadata();
    }

    public Map<String, Object> getSource() {
        return this.ctxMap.getSource();
    }

    public Map<String, Object> getIngestMetadata() {
        return this.ingestMetadata;
    }

    public static <K, V> Map<K, V> deepCopyMap(Map<K, V> source) {
        return (Map)IngestDocument.deepCopy(source);
    }

    public static Object deepCopy(Object value) {
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            Map copy = Maps.newMapWithExpectedSize(mapValue.size());
            for (Map.Entry entry : mapValue.entrySet()) {
                copy.put(entry.getKey(), IngestDocument.deepCopy(entry.getValue()));
            }
            return copy;
        }
        if (value instanceof List) {
            List listValue = (List)value;
            ArrayList<Object> copy = new ArrayList<Object>(listValue.size());
            for (Object itemValue : listValue) {
                copy.add(IngestDocument.deepCopy(itemValue));
            }
            return copy;
        }
        if (value instanceof Set) {
            Set setValue = (Set)value;
            HashSet<Object> copy = Sets.newHashSetWithExpectedSize(setValue.size());
            for (Object itemValue : setValue) {
                copy.add(IngestDocument.deepCopy(itemValue));
            }
            return copy;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return Arrays.copyOf(bytes, bytes.length);
        }
        if (value instanceof double[][]) {
            double[][] doubles = (double[][])value;
            double[][] result = new double[doubles.length][];
            for (int i = 0; i < doubles.length; ++i) {
                result[i] = Arrays.copyOf(doubles[i], doubles[i].length);
            }
            return result;
        }
        if (value instanceof double[]) {
            double[] doubles = (double[])value;
            return Arrays.copyOf(doubles, doubles.length);
        }
        if (value == null || value instanceof String || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Boolean || value instanceof ZonedDateTime) {
            return value;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return date.clone();
        }
        throw new IllegalArgumentException("unexpected value type [" + value.getClass() + "]");
    }

    public static Set<String> getAllFields(Map<String, Object> input) {
        return IngestDocument.getAllFields(input, "");
    }

    private static Set<String> getAllFields(Map<String, Object> input, String prefix) {
        HashSet<String> allFields = Sets.newHashSet(new String[0]);
        input.forEach((k, v) -> {
            allFields.add(prefix + k);
            if (v instanceof Map) {
                Map mapValue = (Map)v;
                allFields.addAll(IngestDocument.getAllFields(mapValue, prefix + k + "."));
            }
        });
        return allFields;
    }

    public void executePipeline(Pipeline pipeline, BiConsumer<IngestDocument, Exception> handler) {
        if (pipeline.getProcessors().isEmpty()) {
            handler.accept(this, null);
            return;
        }
        if (this.executedPipelines.size() >= MAX_PIPELINES) {
            handler.accept(null, new GraphStructureException("Too many nested pipelines. Cannot have more than " + MAX_PIPELINES + " nested pipelines"));
        } else if (this.executedPipelines.add(pipeline.getId())) {
            Object previousPipeline = this.ingestMetadata.put("pipeline", pipeline.getId());
            pipeline.execute(this, (result, e) -> {
                this.executedPipelines.remove(pipeline.getId());
                if (previousPipeline != null) {
                    this.ingestMetadata.put("pipeline", previousPipeline);
                } else {
                    this.ingestMetadata.remove("pipeline");
                }
                handler.accept((IngestDocument)result, (Exception)e);
            });
        } else {
            handler.accept(null, new GraphStructureException(PIPELINE_CYCLE_ERROR_MESSAGE + pipeline.getId()));
        }
    }

    List<String> getPipelineStack() {
        ArrayList<String> pipelineStack = new ArrayList<String>(this.executedPipelines);
        Collections.reverse(pipelineStack);
        return pipelineStack;
    }

    public boolean updateIndexHistory(String index) {
        return this.indexHistory.add(index);
    }

    public Set<String> getIndexHistory() {
        return Collections.unmodifiableSet(this.indexHistory);
    }

    public boolean doNoSelfReferencesCheck() {
        return this.doNoSelfReferencesCheck;
    }

    public void doNoSelfReferencesCheck(boolean doNoSelfReferencesCheck) {
        this.doNoSelfReferencesCheck = doNoSelfReferencesCheck;
    }

    public String toString() {
        return "IngestDocument{ sourceAndMetadata=" + this.ctxMap + ", ingestMetadata=" + this.ingestMetadata + "}";
    }

    public void reroute(String destIndex) {
        this.getMetadata().setIndex(destIndex);
        this.reroute = true;
    }

    boolean isReroute() {
        return this.reroute;
    }

    void resetReroute() {
        this.reroute = false;
    }

    public void terminate() {
        this.terminate = true;
    }

    boolean isTerminate() {
        return this.terminate;
    }

    void resetTerminate() {
        this.terminate = false;
    }

    private record DelegatingMapView(Map<String, Object> primary, Map<String, Object> overrides) implements Map<String, Object>
    {
        @Override
        public boolean containsKey(Object key) {
            return this.primary.containsKey(key) || this.overrides.containsKey(key);
        }

        @Override
        public Object get(Object key) {
            Object result = this.overrides.get(key);
            return result != null ? result : this.primary.get(key);
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum Metadata {
        INDEX("_index"),
        TYPE("_type"),
        ID("_id"),
        ROUTING("_routing"),
        VERSION("_version"),
        VERSION_TYPE("_version_type"),
        IF_SEQ_NO("_if_seq_no"),
        IF_PRIMARY_TERM("_if_primary_term"),
        DYNAMIC_TEMPLATES("_dynamic_templates");

        private static final Set<String> METADATA_NAMES;
        private final String fieldName;

        private Metadata(String fieldName) {
            this.fieldName = fieldName;
        }

        public static boolean isMetadata(String field) {
            return METADATA_NAMES.contains(field);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        static {
            METADATA_NAMES = Arrays.stream(Metadata.values()).map(metadata -> metadata.fieldName).collect(Collectors.toSet());
        }
    }

    private class FieldPath {
        private final String[] pathElements;
        private final Object initialContext;

        private FieldPath(String path) {
            String newPath;
            if (Strings.isEmpty(path)) {
                throw new IllegalArgumentException("path cannot be null nor empty");
            }
            if (path.startsWith(IngestDocument.INGEST_KEY_PREFIX)) {
                this.initialContext = IngestDocument.this.ingestMetadata;
                newPath = path.substring(IngestDocument.INGEST_KEY_PREFIX.length());
            } else {
                this.initialContext = IngestDocument.this.ctxMap;
                newPath = path.startsWith(IngestDocument.SOURCE_PREFIX) ? path.substring(IngestDocument.SOURCE_PREFIX.length()) : path;
            }
            this.pathElements = newPath.split("\\.");
            if (this.pathElements.length == 1 && this.pathElements[0].isEmpty()) {
                throw new IllegalArgumentException("path [" + path + "] is not valid");
            }
        }
    }

    private static class ResolveResult {
        boolean wasSuccessful;
        String errorMessage;
        Object resolvedObject;

        private ResolveResult() {
        }

        static ResolveResult success(Object resolvedObject) {
            ResolveResult result = new ResolveResult();
            result.wasSuccessful = true;
            result.resolvedObject = resolvedObject;
            return result;
        }

        static ResolveResult error(String errorMessage) {
            ResolveResult result = new ResolveResult();
            result.wasSuccessful = false;
            result.errorMessage = errorMessage;
            return result;
        }
    }
}

