/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.spatial;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.lucene.spatial.DimensionalShapeType;
import org.elasticsearch.lucene.spatial.Extent;
import org.elasticsearch.lucene.spatial.TriangleTreeReader;
import org.elasticsearch.lucene.spatial.TriangleTreeVisitor;

public class GeometryDocValueReader {
    private final ByteArrayStreamInput input;
    private final Extent extent = new Extent();
    private int treeOffset;
    private int docValueOffset;
    private BytesRef bytesRef;

    public GeometryDocValueReader() {
        this.input = new ByteArrayStreamInput();
    }

    public void reset(BytesRef bytesRef) throws IOException {
        this.bytesRef = bytesRef;
        this.input.reset(bytesRef.bytes, bytesRef.offset, bytesRef.length);
        this.docValueOffset = bytesRef.offset;
        this.treeOffset = 0;
    }

    public Extent getExtent() throws IOException {
        if (this.treeOffset == 0) {
            this.getSumCentroidWeight();
            Extent.readFromCompressed(this.input, this.extent);
            this.treeOffset = this.input.getPosition();
        } else {
            this.input.setPosition(this.treeOffset);
        }
        return this.extent;
    }

    public int getCentroidX() throws IOException {
        this.input.setPosition(this.docValueOffset + 0);
        return this.input.readInt();
    }

    public int getCentroidY() throws IOException {
        this.input.setPosition(this.docValueOffset + 4);
        return this.input.readInt();
    }

    public DimensionalShapeType getDimensionalShapeType() {
        this.input.setPosition(this.docValueOffset + 8);
        return DimensionalShapeType.readFrom(this.input);
    }

    public double getSumCentroidWeight() throws IOException {
        this.input.setPosition(this.docValueOffset + 9);
        return Double.longBitsToDouble(this.input.readVLong());
    }

    public void visit(TriangleTreeVisitor visitor) throws IOException {
        Extent geometryExtent = this.getExtent();
        int thisMaxX = geometryExtent.maxX();
        int thisMinX = geometryExtent.minX();
        int thisMaxY = geometryExtent.maxY();
        int thisMinY = geometryExtent.minY();
        if (visitor.push(thisMinX, thisMinY, thisMaxX, thisMaxY)) {
            TriangleTreeReader.visit(this.input, visitor, thisMaxX, thisMaxY);
        }
    }

    public BytesRef getBytesRef() {
        return this.bytesRef;
    }
}

