/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ReservedStateErrorMetadata;
import org.elasticsearch.cluster.metadata.ReservedStateHandlerMetadata;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.core.Strings;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.reservedstate.ReservedClusterStateHandler;
import org.elasticsearch.reservedstate.TransformState;
import org.elasticsearch.reservedstate.service.ErrorState;
import org.elasticsearch.reservedstate.service.ReservedStateChunk;
import org.elasticsearch.reservedstate.service.ReservedStateVersion;
import org.elasticsearch.reservedstate.service.ReservedStateVersionCheck;

public class ReservedStateUpdateTask
implements ClusterStateTaskListener {
    private static final Logger logger = LogManager.getLogger(ReservedStateUpdateTask.class);
    private final String namespace;
    private final ReservedStateChunk stateChunk;
    private final ReservedStateVersionCheck versionCheck;
    private final Map<String, ReservedClusterStateHandler<?>> handlers;
    private final Collection<String> orderedHandlers;
    private final Consumer<ErrorState> errorReporter;
    private final ActionListener<ActionResponse.Empty> listener;

    public ReservedStateUpdateTask(String namespace, ReservedStateChunk stateChunk, ReservedStateVersionCheck versionCheck, Map<String, ReservedClusterStateHandler<?>> handlers, Collection<String> orderedHandlers, Consumer<ErrorState> errorReporter, ActionListener<ActionResponse.Empty> listener) {
        this.namespace = namespace;
        this.stateChunk = stateChunk;
        this.versionCheck = versionCheck;
        this.handlers = handlers;
        this.orderedHandlers = orderedHandlers;
        this.errorReporter = errorReporter;
        this.listener = listener;
    }

    @Override
    public void onFailure(Exception e) {
        this.listener.onFailure(e);
    }

    ActionListener<ActionResponse.Empty> listener() {
        return this.listener;
    }

    protected ClusterState execute(ClusterState currentState) {
        if (currentState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return currentState;
        }
        ReservedStateMetadata existingMetadata = currentState.metadata().reservedStateMetadata().get(this.namespace);
        Map<String, Object> reservedState = this.stateChunk.state();
        ReservedStateVersion reservedStateVersion = this.stateChunk.metadata();
        if (!ReservedStateUpdateTask.checkMetadataVersion(this.namespace, existingMetadata, reservedStateVersion, this.versionCheck)) {
            return currentState;
        }
        ReservedStateMetadata.Builder reservedMetadataBuilder = new ReservedStateMetadata.Builder(this.namespace).version(reservedStateVersion.version());
        ArrayList<String> errors = new ArrayList<String>();
        ClusterState state = currentState;
        for (String handlerName : this.orderedHandlers) {
            ReservedClusterStateHandler<?> handler = this.handlers.get(handlerName);
            try {
                Set<String> existingKeys = ReservedStateUpdateTask.keysForHandler(existingMetadata, handlerName);
                TransformState transformState = handler.transform(reservedState.get(handlerName), new TransformState(state, existingKeys));
                state = transformState.state();
                reservedMetadataBuilder.putHandler(new ReservedStateHandlerMetadata(handlerName, transformState.keys()));
            }
            catch (Exception e) {
                errors.add(Strings.format((String)"Error processing %s state change: %s", (Object[])new Object[]{handler.name(), ExceptionsHelper.stackTrace(e)}));
            }
        }
        this.checkAndThrowOnError(errors, reservedStateVersion, this.versionCheck);
        reservedMetadataBuilder.errorMetadata(null);
        ClusterState.Builder stateBuilder = new ClusterState.Builder(state);
        Metadata.Builder metadataBuilder = Metadata.builder(state.metadata()).put(reservedMetadataBuilder.build());
        return stateBuilder.metadata(metadataBuilder).build();
    }

    private void checkAndThrowOnError(List<String> errors, ReservedStateVersion version, ReservedStateVersionCheck versionCheck) {
        if (!errors.isEmpty()) {
            logger.debug("Error processing state change request for [{}] with the following errors [{}]", (Object)this.namespace, errors);
            ErrorState errorState = new ErrorState(this.namespace, version.version(), versionCheck, errors, ReservedStateErrorMetadata.ErrorKind.VALIDATION);
            this.errorReporter.accept(errorState);
            throw new IllegalStateException("Error processing state change request for " + this.namespace + ", errors: " + errorState);
        }
    }

    static Set<String> keysForHandler(ReservedStateMetadata reservedStateMetadata, String handlerName) {
        if (reservedStateMetadata == null || reservedStateMetadata.handlers().get(handlerName) == null) {
            return Collections.emptySet();
        }
        return reservedStateMetadata.handlers().get(handlerName).keys();
    }

    static boolean checkMetadataVersion(String namespace, ReservedStateMetadata existingMetadata, ReservedStateVersion reservedStateVersion, ReservedStateVersionCheck versionCheck) {
        if (Version.CURRENT.before(reservedStateVersion.minCompatibleVersion())) {
            logger.warn(() -> Strings.format((String)"Reserved cluster state version [%s] for namespace [%s] is not compatible with this Elasticsearch node", (Object[])new Object[]{reservedStateVersion.minCompatibleVersion(), namespace}));
            return false;
        }
        Long newVersion = reservedStateVersion.version();
        if (newVersion.equals(ReservedStateMetadata.EMPTY_VERSION)) {
            return true;
        }
        if (newVersion <= 0L) {
            logger.warn(() -> Strings.format((String)"Not updating reserved cluster state for namespace [%s], because version [%s] is less or equal to 0", (Object[])new Object[]{namespace, newVersion}));
            return false;
        }
        if (existingMetadata == null) {
            return true;
        }
        Long currentVersion = existingMetadata.version();
        if (versionCheck.test(currentVersion, newVersion)) {
            return true;
        }
        logger.warn(() -> {
            Object[] objectArray = new Object[4];
            objectArray[0] = namespace;
            objectArray[1] = newVersion;
            objectArray[2] = switch (versionCheck) {
                default -> throw new IncompatibleClassChangeError();
                case ReservedStateVersionCheck.HIGHER_OR_SAME_VERSION -> "less than";
                case ReservedStateVersionCheck.HIGHER_VERSION_ONLY -> "less than or equal to";
            };
            objectArray[3] = currentVersion;
            return Strings.format((String)"Not updating reserved cluster state for namespace [%s], because version [%s] is %s the current metadata version [%s]", (Object[])objectArray);
        });
        return false;
    }
}

