/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.path.PathTrie;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.Streams;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.http.HttpHeadersValidationException;
import org.elasticsearch.http.HttpRouteStats;
import org.elasticsearch.http.HttpRouteStatsTracker;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.rest.ApiNotAvailableException;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.rest.DeprecationRestHandler;
import org.elasticsearch.rest.MethodHandlers;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestInterceptor;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessApiProtections;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.usage.SearchUsageHolder;
import org.elasticsearch.usage.UsageService;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class RestController
implements HttpServerTransport.Dispatcher {
    private static final Logger logger = LogManager.getLogger(RestController.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestController.class);
    static final Set<String> SAFELISTED_MEDIA_TYPES = Set.of("application/x-www-form-urlencoded", "multipart/form-data", "text/plain");
    static final String ELASTIC_PRODUCT_HTTP_HEADER = "X-elastic-product";
    static final String ELASTIC_PRODUCT_HTTP_HEADER_VALUE = "Elasticsearch";
    static final Set<String> RESERVED_PATHS = Set.of("/__elb_health__", "/__elb_health__/zk", "/_health", "/_health/zk");
    private static final BytesReference FAVICON_RESPONSE;
    public static final String STATUS_CODE_KEY = "es_rest_status_code";
    public static final String HANDLER_NAME_KEY = "es_rest_handler_name";
    public static final String REQUEST_METHOD_KEY = "es_rest_request_method";
    private final PathTrie<MethodHandlers> handlers = new PathTrie(RestUtils.REST_DECODER);
    private final RestInterceptor interceptor;
    private final NodeClient client;
    private final CircuitBreakerService circuitBreakerService;
    private final UsageService usageService;
    private final Tracer tracer;
    private final LongCounter requestsCounter;
    private final ServerlessApiProtections apiProtections;
    public static final String METRIC_REQUESTS_TOTAL = "es.rest.requests.total";

    public RestController(RestInterceptor restInterceptor, NodeClient client, CircuitBreakerService circuitBreakerService, UsageService usageService, TelemetryProvider telemetryProvider) {
        this.usageService = usageService;
        this.tracer = telemetryProvider.getTracer();
        this.requestsCounter = telemetryProvider.getMeterRegistry().registerLongCounter(METRIC_REQUESTS_TOTAL, "The total number of rest requests/responses processed", "unit");
        if (restInterceptor == null) {
            restInterceptor = (request, channel, targetHandler, listener) -> listener.onResponse(Boolean.TRUE);
        }
        this.interceptor = restInterceptor;
        this.client = client;
        this.circuitBreakerService = circuitBreakerService;
        this.registerHandlerNoWrap(RestRequest.Method.GET, "/favicon.ico", RestApiVersion.current(), new RestFavIconHandler());
        this.apiProtections = new ServerlessApiProtections(false);
    }

    public ServerlessApiProtections getApiProtections() {
        return this.apiProtections;
    }

    protected void registerAsDeprecatedHandler(RestRequest.Method method, String path, RestApiVersion version, RestHandler handler, String deprecationMessage) {
        this.registerAsDeprecatedHandler(method, path, version, handler, deprecationMessage, null);
    }

    protected void registerAsDeprecatedHandler(RestRequest.Method method, String path, RestApiVersion version, RestHandler handler, String deprecationMessage, @Nullable Level deprecationLevel) {
        assert (!(handler instanceof DeprecationRestHandler));
        if (version == RestApiVersion.current()) {
            this.registerHandler(method, path, version, new DeprecationRestHandler(handler, method, path, deprecationLevel, deprecationMessage, deprecationLogger, false));
        } else if (version == RestApiVersion.minimumSupported()) {
            this.registerHandler(method, path, version, new DeprecationRestHandler(handler, method, path, deprecationLevel, deprecationMessage, deprecationLogger, true));
        } else {
            logger.debug("Deprecated route [" + method + " " + path + "] for handler [" + handler.getClass() + "] with version [" + version + "], which is less than the minimum supported version [" + RestApiVersion.minimumSupported() + "]");
        }
    }

    protected void registerAsReplacedHandler(RestRequest.Method method, String path, RestApiVersion version, RestHandler handler, RestRequest.Method replacedMethod, String replacedPath, RestApiVersion replacedVersion) {
        String replacedMessage = "[" + replacedMethod.name() + " " + replacedPath + "] is deprecated! Use [" + method.name() + " " + path + "] instead.";
        this.registerHandler(method, path, version, handler);
        this.registerAsDeprecatedHandler(replacedMethod, replacedPath, replacedVersion, handler, replacedMessage);
    }

    protected void registerHandler(RestRequest.Method method, String path, RestApiVersion version, RestHandler handler) {
        if (handler instanceof BaseRestHandler) {
            this.usageService.addRestHandler((BaseRestHandler)handler);
        }
        this.registerHandlerNoWrap(method, path, version, handler);
    }

    private void registerHandlerNoWrap(RestRequest.Method method, String path, RestApiVersion version, RestHandler handler) {
        assert (RestApiVersion.minimumSupported() == version || RestApiVersion.current() == version) : "REST API compatibility is only supported for version " + RestApiVersion.minimumSupported().major;
        if (RESERVED_PATHS.contains(path)) {
            throw new IllegalArgumentException("path [" + path + "] is a reserved path and may not be registered");
        }
        assert (method != RestRequest.Method.OPTIONS) : "There should be no handlers registered for the OPTIONS HTTP method";
        this.handlers.insertOrUpdate(path, new MethodHandlers(path).addMethod(method, version, handler), (handlers, ignoredHandler) -> handlers.addMethod(method, version, handler));
    }

    public void registerHandler(RestHandler.Route route, RestHandler handler) {
        if (route.isReplacement()) {
            RestHandler.Route replaced = route.getReplacedRoute();
            this.registerAsReplacedHandler(route.getMethod(), route.getPath(), route.getRestApiVersion(), handler, replaced.getMethod(), replaced.getPath(), replaced.getRestApiVersion());
        } else if (route.isDeprecated()) {
            this.registerAsDeprecatedHandler(route.getMethod(), route.getPath(), route.getRestApiVersion(), handler, route.getDeprecationMessage(), route.getDeprecationLevel());
        } else {
            this.registerHandler(route.getMethod(), route.getPath(), route.getRestApiVersion(), handler);
        }
    }

    public void registerHandler(RestHandler handler) {
        handler.routes().forEach(route -> this.registerHandler((RestHandler.Route)route, handler));
    }

    @Override
    public void dispatchRequest(RestRequest request, RestChannel channel, ThreadContext threadContext) {
        threadContext.addResponseHeader(ELASTIC_PRODUCT_HTTP_HEADER, ELASTIC_PRODUCT_HTTP_HEADER_VALUE);
        try {
            this.tryAllHandlers(request, channel, threadContext);
        }
        catch (Exception e) {
            try {
                this.sendFailure(channel, e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                logger.error(() -> "failed to send failure response for uri [" + request.uri() + "]", (Throwable)inner);
            }
        }
    }

    @Override
    public void dispatchBadRequest(RestChannel channel, ThreadContext threadContext, Throwable cause) {
        threadContext.addResponseHeader(ELASTIC_PRODUCT_HTTP_HEADER, ELASTIC_PRODUCT_HTTP_HEADER_VALUE);
        try {
            Exception e = cause == null ? new ElasticsearchException("unknown cause", new Object[0]) : (cause instanceof Exception ? (Exception)cause : new ElasticsearchException(cause));
            if (e instanceof HttpHeadersValidationException) {
                this.sendFailure(channel, (Exception)e.getCause());
            } else {
                channel.sendResponse(new RestResponse(channel, RestStatus.BAD_REQUEST, e));
                RestController.recordRequestMetric(RestStatus.BAD_REQUEST, this.requestsCounter);
            }
        }
        catch (IOException e) {
            if (cause != null) {
                e.addSuppressed(cause);
            }
            logger.warn("failed to send bad request response", (Throwable)e);
            channel.sendResponse(new RestResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", BytesArray.EMPTY));
            RestController.recordRequestMetric(RestStatus.INTERNAL_SERVER_ERROR, this.requestsCounter);
        }
    }

    public boolean checkSupported(RestRequest.Method method, String path, Set<String> parameters, Set<String> capabilities, RestApiVersion restApiVersion) {
        Iterator<MethodHandlers> allHandlers = this.getAllHandlers(null, path);
        while (allHandlers.hasNext()) {
            MethodHandlers handlers = allHandlers.next();
            RestHandler handler = handlers == null ? null : handlers.getHandler(method, restApiVersion);
            if (handler == null) continue;
            Set<String> supportedParams = handler.supportedQueryParameters();
            assert (supportedParams == handler.supportedQueryParameters()) : handler.getName() + ": did not return same instance from supportedQueryParameters()";
            return (supportedParams == null || supportedParams.containsAll(parameters)) && handler.supportedCapabilities().containsAll(capabilities);
        }
        return false;
    }

    @Override
    public Map<String, HttpRouteStats> getStats() {
        Iterator<MethodHandlers> methodHandlersIterator = this.handlers.allNodeValues();
        TreeMap<String, HttpRouteStats> allStats = new TreeMap<String, HttpRouteStats>();
        while (methodHandlersIterator.hasNext()) {
            MethodHandlers mh = methodHandlersIterator.next();
            HttpRouteStats stats = mh.getStats();
            if (stats.requestCount() <= 0L && stats.responseCount() <= 0L) continue;
            allStats.put(mh.getPath(), stats);
        }
        return Collections.unmodifiableSortedMap(allStats);
    }

    private void dispatchRequest(final RestRequest request, RestChannel channel, final RestHandler handler, MethodHandlers methodHandlers, ThreadContext threadContext) throws Exception {
        Scope scope;
        if (request.hasContent()) {
            if (RestController.isContentTypeDisallowed(request) || !handler.mediaTypesValid(request)) {
                RestController.sendContentTypeErrorMessage(request.getAllHeaderValues("Content-Type"), channel);
                return;
            }
            XContentType xContentType = request.getXContentType();
            if (handler.supportsBulkContent() && XContentType.JSON != xContentType.canonical() && XContentType.SMILE != xContentType.canonical()) {
                channel.sendResponse(RestResponse.createSimpleErrorResponse(channel, RestStatus.NOT_ACCEPTABLE, "Content-Type [" + xContentType + "] does not support stream parsing. Use JSON or SMILE instead"));
                return;
            }
        }
        RestChannel responseChannel = channel;
        if (this.apiProtections.isEnabled() && (scope = handler.getServerlessScope()) == null) {
            this.handleServerlessRequestToProtectedResource(request.uri(), request.method(), responseChannel);
            return;
        }
        int contentLength = request.isFullContent() ? request.contentLength() : 0;
        try {
            if (handler.canTripCircuitBreaker()) {
                RestController.inFlightRequestsBreaker(this.circuitBreakerService).addEstimateBytesAndMaybeBreak(contentLength, "<http_request>");
            } else {
                RestController.inFlightRequestsBreaker(this.circuitBreakerService).addWithoutBreaking(contentLength);
            }
            responseChannel = new ResourceHandlingHttpChannel(channel, this.circuitBreakerService, contentLength, methodHandlers);
            if (!handler.allowsUnsafeBuffers()) {
                request.ensureSafeBuffers();
            }
            if (!handler.allowSystemIndexAccessByDefault()) {
                String prodOriginValue = request.header("X-elastic-product-origin");
                if (prodOriginValue != null) {
                    threadContext.putHeader("_system_index_access_allowed", Boolean.TRUE.toString());
                    threadContext.putHeader("_external_system_index_access_origin", prodOriginValue);
                } else {
                    threadContext.putHeader("_system_index_access_allowed", Boolean.FALSE.toString());
                }
            } else {
                threadContext.putHeader("_system_index_access_allowed", Boolean.TRUE.toString());
            }
            if (this.apiProtections.isEnabled()) {
                request.markAsServerlessRequest();
                logger.trace("Marked request for uri [{}] as serverless request", (Object)request.uri());
            }
            final RestChannel finalChannel = responseChannel;
            this.interceptor.intercept(request, responseChannel, handler.getConcreteRestHandler(), new ActionListener<Boolean>(){

                @Override
                public void onResponse(Boolean processRequest) {
                    if (processRequest.booleanValue()) {
                        try {
                            RestController.this.validateRequest(request, handler, RestController.this.client);
                            handler.handleRequest(request, finalChannel, RestController.this.client);
                        }
                        catch (Exception e) {
                            this.onFailure(e);
                        }
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    try {
                        RestController.this.sendFailure(finalChannel, e);
                    }
                    catch (IOException ex) {
                        logger.info("Failed to send error [{}] to HTTP client", (Object)ex.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            this.sendFailure(responseChannel, e);
        }
    }

    protected void validateRequest(RestRequest request, RestHandler handler, NodeClient client) throws ElasticsearchStatusException {
    }

    private void sendFailure(RestChannel responseChannel, Exception e) throws IOException {
        RestResponse restResponse = new RestResponse(responseChannel, e);
        responseChannel.sendResponse(restResponse);
        RestController.recordRequestMetric(restResponse.status(), this.requestsCounter);
    }

    private static boolean isContentTypeDisallowed(RestRequest request) {
        return request.getParsedContentType() != null && SAFELISTED_MEDIA_TYPES.contains(request.getParsedContentType().mediaTypeWithoutParameters());
    }

    private boolean handleNoHandlerFound(ThreadContext threadContext, String rawPath, RestRequest.Method method, String uri, RestChannel channel) {
        Set<RestRequest.Method> validMethodSet = this.getValidHandlerMethodSet(rawPath);
        if (!validMethodSet.contains((Object)method)) {
            if (method == RestRequest.Method.OPTIONS) {
                this.startTrace(threadContext, channel);
                this.handleOptionsRequest(channel, validMethodSet);
                return true;
            }
            if (!validMethodSet.isEmpty()) {
                this.startTrace(threadContext, channel);
                this.handleUnsupportedHttpMethod(uri, method, channel, validMethodSet, null);
                return true;
            }
        }
        return false;
    }

    private void startTrace(ThreadContext threadContext, RestChannel channel) {
        this.startTrace(threadContext, channel, null);
    }

    private void startTrace(ThreadContext threadContext, RestChannel channel, String restPath) {
        RestRequest req = channel.request();
        if (restPath == null) {
            restPath = req.path();
        }
        String method = null;
        try {
            method = req.method().name();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Object name = method != null ? method + " " + restPath : restPath;
        Map<String, Object> attributes = Maps.newMapWithExpectedSize(req.getHeaders().size() + 3);
        req.getHeaders().forEach((key, values) -> {
            String lowerKey = key.toLowerCase(Locale.ROOT).replace('-', '_');
            attributes.put("http.request.headers." + lowerKey, values.size() == 1 ? values.get(0) : String.join((CharSequence)"; ", values));
        });
        attributes.put("http.method", method);
        attributes.put("http.url", req.uri());
        switch (req.getHttpRequest().protocolVersion()) {
            case HTTP_1_0: {
                attributes.put("http.flavour", "1.0");
                break;
            }
            case HTTP_1_1: {
                attributes.put("http.flavour", "1.1");
            }
        }
        this.tracer.startTrace(threadContext, channel.request(), (String)name, attributes);
    }

    private void traceException(RestChannel channel, Throwable e) {
        this.tracer.addError(channel.request(), e);
    }

    private static void sendContentTypeErrorMessage(@Nullable List<String> contentTypeHeader, RestChannel channel) throws IOException {
        Object errorMessage = contentTypeHeader == null ? "Content-Type header is missing" : "Content-Type header [" + Strings.collectionToCommaDelimitedString(contentTypeHeader) + "] is not supported";
        channel.sendResponse(RestResponse.createSimpleErrorResponse(channel, RestStatus.NOT_ACCEPTABLE, (String)errorMessage));
    }

    private void tryAllHandlers(RestRequest request, RestChannel channel, ThreadContext threadContext) throws Exception {
        RestRequest.Method requestMethod;
        try {
            RestController.validateErrorTrace(request, channel);
        }
        catch (IllegalArgumentException e) {
            this.startTrace(threadContext, channel);
            channel.sendResponse(RestResponse.createSimpleErrorResponse(channel, RestStatus.BAD_REQUEST, e.getMessage()));
            RestController.recordRequestMetric(RestStatus.BAD_REQUEST, this.requestsCounter);
            return;
        }
        String rawPath = request.rawPath();
        String uri = request.uri();
        RestApiVersion restApiVersion = request.getRestApiVersion();
        try {
            requestMethod = request.method();
            Iterator<MethodHandlers> allHandlers = this.getAllHandlers(request.params(), rawPath);
            while (allHandlers.hasNext()) {
                MethodHandlers handlers = allHandlers.next();
                RestHandler handler = handlers == null ? null : handlers.getHandler(requestMethod, restApiVersion);
                if (handler == null) {
                    if (!this.handleNoHandlerFound(threadContext, rawPath, requestMethod, uri, channel)) continue;
                    return;
                }
                this.startTrace(threadContext, channel, handlers.getPath());
                MeteringRestChannelDecorator decoratedChannel = new MeteringRestChannelDecorator(channel, this.requestsCounter, handler.getConcreteRestHandler());
                this.dispatchRequest(request, decoratedChannel, handler, handlers, threadContext);
                return;
            }
        }
        catch (IllegalArgumentException e) {
            this.startTrace(threadContext, channel);
            this.traceException(channel, e);
            this.handleUnsupportedHttpMethod(uri, null, channel, this.getValidHandlerMethodSet(rawPath), e);
            return;
        }
        this.startTrace(threadContext, channel);
        this.handleBadRequest(uri, requestMethod, channel);
    }

    private static void validateErrorTrace(RestRequest request, RestChannel channel) {
        if (request.paramAsBoolean("error_trace", false) && !channel.detailedErrorsEnabled()) {
            throw new IllegalArgumentException("error traces in responses are disabled.");
        }
    }

    Iterator<MethodHandlers> getAllHandlers(@Nullable Map<String, String> requestParamsRef, String rawPath) {
        Supplier<Map<String, String>> paramsSupplier;
        if (requestParamsRef == null) {
            paramsSupplier = () -> null;
        } else {
            Map<String, String> originalParams = Map.copyOf(requestParamsRef);
            paramsSupplier = () -> {
                requestParamsRef.clear();
                requestParamsRef.putAll(originalParams);
                return requestParamsRef;
            };
        }
        return this.handlers.retrieveAll(rawPath, paramsSupplier).iterator();
    }

    public SearchUsageHolder getSearchUsageHolder() {
        return this.usageService.getSearchUsageHolder();
    }

    private void handleUnsupportedHttpMethod(String uri, @Nullable RestRequest.Method method, RestChannel channel, Set<RestRequest.Method> validMethodSet, @Nullable IllegalArgumentException exception) {
        try {
            StringBuilder msg = new StringBuilder();
            if (exception == null) {
                msg.append("Incorrect HTTP method for uri [").append(uri);
                msg.append("] and method [").append((Object)method).append("]");
            } else {
                msg.append(exception.getMessage());
            }
            if (!validMethodSet.isEmpty()) {
                msg.append(", allowed: ").append(validMethodSet);
            }
            RestResponse restResponse = RestResponse.createSimpleErrorResponse(channel, RestStatus.METHOD_NOT_ALLOWED, msg.toString());
            if (!validMethodSet.isEmpty()) {
                restResponse.addHeader("Allow", Strings.collectionToDelimitedString(validMethodSet, ","));
            }
            channel.sendResponse(restResponse);
            RestController.recordRequestMetric(RestStatus.METHOD_NOT_ALLOWED, this.requestsCounter);
        }
        catch (IOException e) {
            logger.warn("failed to send bad request response", (Throwable)e);
            channel.sendResponse(new RestResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", BytesArray.EMPTY));
            RestController.recordRequestMetric(RestStatus.INTERNAL_SERVER_ERROR, this.requestsCounter);
        }
    }

    private void handleOptionsRequest(RestChannel channel, Set<RestRequest.Method> validMethodSet) {
        RestResponse restResponse = new RestResponse(RestStatus.OK, "text/plain; charset=UTF-8", BytesArray.EMPTY);
        if (!validMethodSet.isEmpty()) {
            restResponse.addHeader("Allow", Strings.collectionToDelimitedString(validMethodSet, ","));
        }
        channel.sendResponse(restResponse);
        RestController.recordRequestMetric(RestStatus.OK, this.requestsCounter);
    }

    private void handleBadRequest(String uri, RestRequest.Method method, RestChannel channel) throws IOException {
        try (XContentBuilder builder = channel.newErrorBuilder();){
            builder.startObject();
            builder.field("error", "no handler found for uri [" + uri + "] and method [" + method + "]");
            builder.endObject();
            channel.sendResponse(new RestResponse(RestStatus.BAD_REQUEST, builder));
            RestController.recordRequestMetric(RestStatus.BAD_REQUEST, this.requestsCounter);
        }
    }

    private void handleServerlessRequestToProtectedResource(String uri, RestRequest.Method method, RestChannel channel) throws IOException {
        String msg = "uri [" + uri + "] with method [" + method + "] exists but is not available when running in serverless mode";
        this.sendFailure(channel, new ApiNotAvailableException(msg, new Object[0]));
    }

    private Set<RestRequest.Method> getValidHandlerMethodSet(String rawPath) {
        EnumSet<RestRequest.Method> validMethods = EnumSet.noneOf(RestRequest.Method.class);
        Iterator<MethodHandlers> allHandlers = this.getAllHandlers(null, rawPath);
        while (allHandlers.hasNext()) {
            MethodHandlers methodHandlers = allHandlers.next();
            if (methodHandlers == null) continue;
            validMethods.addAll(methodHandlers.getValidMethods());
        }
        return validMethods;
    }

    private static void recordRequestMetric(RestStatus statusCode, String handlerName, String requestMethod, LongCounter requestsCounter) {
        try {
            Map<String, Object> attributes = Map.of(STATUS_CODE_KEY, statusCode.getStatus(), HANDLER_NAME_KEY, handlerName, REQUEST_METHOD_KEY, requestMethod);
            requestsCounter.incrementBy(1L, attributes);
        }
        catch (Exception ex) {
            logger.error("Cannot track request status code", (Throwable)ex);
        }
    }

    private static void recordRequestMetric(RestStatus statusCode, LongCounter requestsCounter) {
        try {
            Map<String, Object> attributes = Map.of(STATUS_CODE_KEY, statusCode.getStatus());
            requestsCounter.incrementBy(1L, attributes);
        }
        catch (Exception ex) {
            logger.error("Cannot track request status code", (Throwable)ex);
        }
    }

    private static CircuitBreaker inFlightRequestsBreaker(CircuitBreakerService circuitBreakerService) {
        return circuitBreakerService.getBreaker("inflight_requests");
    }

    static {
        try (InputStream stream = RestController.class.getResourceAsStream("/config/favicon.ico");){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Streams.copy((InputStream)stream, (OutputStream)out);
            FAVICON_RESPONSE = new BytesArray(out.toByteArray());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @ServerlessScope(value=Scope.PUBLIC)
    private static final class RestFavIconHandler
    implements RestHandler {
        private RestFavIconHandler() {
        }

        @Override
        public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
            channel.sendResponse(new RestResponse(RestStatus.OK, "image/x-icon", FAVICON_RESPONSE));
        }
    }

    private static final class ResourceHandlingHttpChannel
    extends DelegatingRestChannel {
        private final CircuitBreakerService circuitBreakerService;
        private final int contentLength;
        private final HttpRouteStatsTracker statsTracker;
        private final long startTime;
        private final AtomicBoolean closed = new AtomicBoolean();

        ResourceHandlingHttpChannel(RestChannel delegate, CircuitBreakerService circuitBreakerService, int contentLength, MethodHandlers methodHandlers) {
            super(delegate);
            this.circuitBreakerService = circuitBreakerService;
            this.contentLength = contentLength;
            this.statsTracker = methodHandlers.statsTracker();
            this.startTime = ResourceHandlingHttpChannel.rawRelativeTimeInMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendResponse(RestResponse response) {
            boolean success = false;
            try {
                this.close();
                this.statsTracker.addRequestStats(this.contentLength);
                this.statsTracker.addResponseTime(ResourceHandlingHttpChannel.rawRelativeTimeInMillis() - this.startTime);
                if (!response.isChunked()) {
                    this.statsTracker.addResponseStats(response.content().length());
                } else {
                    ResponseLengthRecorder responseLengthRecorder = new ResponseLengthRecorder(this.statsTracker);
                    Map<String, List<String>> headers = response.getHeaders();
                    response = RestResponse.chunked(response.status(), new EncodedLengthTrackingChunkedRestResponseBodyPart(response.chunkedContent(), responseLengthRecorder), Releasables.wrap((Releasable[])new Releasable[]{responseLengthRecorder, response}));
                    for (Map.Entry<String, List<String>> header : headers.entrySet()) {
                        for (String value : header.getValue()) {
                            response.addHeader(header.getKey(), value);
                        }
                    }
                }
                super.sendResponse(response);
                success = true;
            }
            finally {
                if (!success) {
                    this.releaseOutputBuffer();
                }
            }
        }

        private static long rawRelativeTimeInMillis() {
            return TimeValue.nsecToMSec((long)System.nanoTime());
        }

        private void close() {
            if (!this.closed.compareAndSet(false, true)) {
                throw new IllegalStateException("Channel is already closed");
            }
            RestController.inFlightRequestsBreaker(this.circuitBreakerService).addWithoutBreaking(-this.contentLength);
        }
    }

    private static final class MeteringRestChannelDecorator
    extends DelegatingRestChannel {
        private final LongCounter requestsCounter;
        private final RestHandler restHandler;

        private MeteringRestChannelDecorator(RestChannel delegate, LongCounter requestCounter, RestHandler restHandler) {
            super(delegate);
            this.requestsCounter = requestCounter;
            this.restHandler = restHandler;
        }

        @Override
        public void sendResponse(RestResponse response) {
            super.sendResponse(response);
            RestController.recordRequestMetric(response.status(), this.restHandler.getName(), this.request().method().name(), this.requestsCounter);
        }
    }

    private static class EncodedLengthTrackingChunkedRestResponseBodyPart
    implements ChunkedRestResponseBodyPart {
        private final ChunkedRestResponseBodyPart delegate;
        private final ResponseLengthRecorder responseLengthRecorder;

        private EncodedLengthTrackingChunkedRestResponseBodyPart(ChunkedRestResponseBodyPart delegate, ResponseLengthRecorder responseLengthRecorder) {
            this.delegate = delegate;
            this.responseLengthRecorder = responseLengthRecorder;
        }

        @Override
        public boolean isPartComplete() {
            return this.delegate.isPartComplete();
        }

        @Override
        public boolean isLastPart() {
            return this.delegate.isLastPart();
        }

        @Override
        public void getNextPart(ActionListener<ChunkedRestResponseBodyPart> listener) {
            this.delegate.getNextPart(listener.map(continuation -> new EncodedLengthTrackingChunkedRestResponseBodyPart((ChunkedRestResponseBodyPart)continuation, this.responseLengthRecorder)));
        }

        @Override
        public ReleasableBytesReference encodeChunk(int sizeHint, Recycler<BytesRef> recycler) throws IOException {
            ReleasableBytesReference bytesReference = this.delegate.encodeChunk(sizeHint, recycler);
            this.responseLengthRecorder.addChunkLength(bytesReference.length());
            if (this.isPartComplete() && this.isLastPart()) {
                this.responseLengthRecorder.close();
            }
            return bytesReference;
        }

        @Override
        public String getResponseContentTypeString() {
            return this.delegate.getResponseContentTypeString();
        }
    }

    private static class ResponseLengthRecorder
    extends AtomicReference<HttpRouteStatsTracker>
    implements Releasable {
        private long responseLength;

        private ResponseLengthRecorder(HttpRouteStatsTracker routeStatsTracker) {
            super(routeStatsTracker);
        }

        public void close() {
            HttpRouteStatsTracker routeStatsTracker = this.getAndSet(null);
            if (routeStatsTracker != null) {
                assert (this.responseLength == 0L || Transports.assertTransportThread());
                routeStatsTracker.addResponseStats(this.responseLength);
            }
        }

        void addChunkLength(long chunkLength) {
            assert (chunkLength >= 0L) : chunkLength;
            assert (Transports.assertTransportThread());
            assert (this.get() != null) : "already closed";
            this.responseLength += chunkLength;
        }
    }

    private static class DelegatingRestChannel
    implements RestChannel {
        private final RestChannel delegate;

        private DelegatingRestChannel(RestChannel delegate) {
            this.delegate = delegate;
        }

        @Override
        public XContentBuilder newBuilder() throws IOException {
            return this.delegate.newBuilder();
        }

        @Override
        public XContentBuilder newErrorBuilder() throws IOException {
            return this.delegate.newErrorBuilder();
        }

        @Override
        public XContentBuilder newBuilder(@Nullable XContentType xContentType, boolean useFiltering) throws IOException {
            return this.delegate.newBuilder(xContentType, useFiltering);
        }

        @Override
        public XContentBuilder newBuilder(XContentType xContentType, XContentType responseContentType, boolean useFiltering) throws IOException {
            return this.delegate.newBuilder(xContentType, responseContentType, useFiltering);
        }

        @Override
        public XContentBuilder newBuilder(XContentType xContentType, XContentType responseContentType, boolean useFiltering, OutputStream out) throws IOException {
            return this.delegate.newBuilder(xContentType, responseContentType, useFiltering, out);
        }

        @Override
        public BytesStream bytesOutput() {
            return this.delegate.bytesOutput();
        }

        @Override
        public void releaseOutputBuffer() {
            this.delegate.releaseOutputBuffer();
        }

        @Override
        public RestRequest request() {
            return this.delegate.request();
        }

        @Override
        public boolean detailedErrorsEnabled() {
            return this.delegate.detailedErrorsEnabled();
        }

        @Override
        public void sendResponse(RestResponse response) {
            this.delegate.sendResponse(response);
        }
    }
}

