/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.Streams;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class StreamingXContentResponse
implements Releasable {
    @Nullable
    private BytesStream targetStream;
    private final XContentBuilder xContentBuilder;
    private final RestChannel restChannel;
    private final ToXContent.Params params;
    private final Releasable onCompletion;
    @Nullable
    private SubscribableListener<ChunkedRestResponseBodyPart> nextAvailableFragmentListener;
    @Nullable
    private Releasable currentFragmentReleasable;
    private final Queue<StreamingFragment> fragmentQueue = new LinkedBlockingQueue<StreamingFragment>();
    private final AtomicInteger queueLength = new AtomicInteger();
    private final RefCounted queueRefs = AbstractRefCounted.of(this::drainQueue);
    private final AtomicBoolean isRestResponseFinished = new AtomicBoolean();
    private static final Iterator<? extends ToXContent> NO_MORE_FRAGMENTS = new Iterator<ToXContent>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public ToXContent next() {
            assert (false) : "not called";
            return ToXContent.EMPTY;
        }
    };

    public StreamingXContentResponse(RestChannel restChannel, ToXContent.Params params, Releasable onCompletion) throws IOException {
        this.restChannel = restChannel;
        this.params = params;
        this.onCompletion = onCompletion;
        this.xContentBuilder = restChannel.newBuilder(restChannel.request().getXContentType(), null, true, Streams.noCloseStream((OutputStream)new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                assert (StreamingXContentResponse.this.targetStream != null);
                StreamingXContentResponse.this.targetStream.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                assert (StreamingXContentResponse.this.targetStream != null);
                StreamingXContentResponse.this.targetStream.write(b, off, len);
            }
        }));
    }

    public void close() {
        this.writeFragment(p -> NO_MORE_FRAGMENTS, () -> {
            if (this.isRestResponseFinished.compareAndSet(false, true)) {
                this.queueRefs.decRef();
            }
        });
    }

    private Iterator<? extends ToXContent> getChunksIterator(StreamingFragment fragment) {
        return this.xContentBuilder.getRestApiVersion() == RestApiVersion.V_7 ? fragment.fragment().toXContentChunkedV7(this.params) : fragment.fragment().toXContentChunked(this.params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeFragment(ChunkedToXContent fragment, Releasable releasable) {
        if (this.tryAcquireQueueRef()) {
            try {
                this.fragmentQueue.add(new StreamingFragment(fragment, releasable));
                if (this.queueLength.getAndIncrement() != 0) return;
                StreamingFragment nextFragment = this.fragmentQueue.poll();
                assert (nextFragment != null);
                AvailableFragmentsResponseBodyPart availableFragments = new AvailableFragmentsResponseBodyPart(this.getChunksIterator(nextFragment));
                assert (this.currentFragmentReleasable == null);
                this.currentFragmentReleasable = nextFragment.releasable();
                SubscribableListener<ChunkedRestResponseBodyPart> currentAvailableFragmentListener = this.nextAvailableFragmentListener;
                this.nextAvailableFragmentListener = new SubscribableListener();
                if (currentAvailableFragmentListener == null) {
                    this.restChannel.sendResponse(RestResponse.chunked(RestStatus.OK, availableFragments, this::restResponseFinished));
                    return;
                }
                assert (!currentAvailableFragmentListener.isDone());
                currentAvailableFragmentListener.onResponse(availableFragments);
                return;
            }
            finally {
                this.queueRefs.decRef();
            }
        } else {
            Releasables.closeExpectNoException((Releasable)releasable);
        }
    }

    private boolean tryAcquireQueueRef() {
        return !this.isRestResponseFinished.get() && this.queueRefs.tryIncRef();
    }

    private void restResponseFinished() {
        assert (Transports.assertTransportThread());
        if (this.isRestResponseFinished.compareAndSet(false, true)) {
            this.queueRefs.decRef();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainQueue() {
        assert (this.isRestResponseFinished.get());
        assert (!this.queueRefs.hasReferences());
        int taskCount = this.queueLength.get() + 2;
        ArrayList<Releasable> releasables = new ArrayList<Releasable>(taskCount);
        try {
            StreamingFragment fragment;
            releasables.add(this.currentFragmentReleasable);
            this.currentFragmentReleasable = null;
            while ((fragment = this.fragmentQueue.poll()) != null) {
                releasables.add(fragment.releasable());
            }
            assert (this.fragmentQueue.isEmpty()) : this.fragmentQueue.size();
            assert (releasables.size() == taskCount - 1 || releasables.size() == taskCount - 2) : taskCount + " vs " + releasables.size();
        }
        finally {
            releasables.add(this.onCompletion);
            Releasables.closeExpectNoException((Releasable)Releasables.wrap(releasables));
        }
    }

    private record StreamingFragment(ChunkedToXContent fragment, Releasable releasable) {
    }

    private final class AvailableFragmentsResponseBodyPart
    implements ChunkedRestResponseBodyPart {
        private Iterator<? extends ToXContent> fragmentChunksIterator;
        private boolean isResponsePaused;
        private boolean isResponseComplete;
        private SubscribableListener<ChunkedRestResponseBodyPart> getNextPartListener;
        private ArrayList<Releasable> nextReleasablesCache = new ArrayList();

        AvailableFragmentsResponseBodyPart(Iterator<? extends ToXContent> fragmentChunksIterator) {
            this.fragmentChunksIterator = fragmentChunksIterator;
        }

        @Override
        public boolean isPartComplete() {
            return this.isResponsePaused || this.isResponseComplete;
        }

        @Override
        public boolean isLastPart() {
            return this.isResponseComplete;
        }

        @Override
        public void getNextPart(ActionListener<ChunkedRestResponseBodyPart> listener) {
            assert (this.getNextPartListener != null);
            this.getNextPartListener.addListener(listener);
        }

        private void transferCurrentFragmentReleasable(ArrayList<Releasable> releasables) {
            assert (StreamingXContentResponse.this.queueRefs.hasReferences());
            if (StreamingXContentResponse.this.currentFragmentReleasable == null) {
                return;
            }
            if (releasables == this.nextReleasablesCache) {
                this.nextReleasablesCache = new ArrayList();
            }
            releasables.add(StreamingXContentResponse.this.currentFragmentReleasable);
            StreamingXContentResponse.this.currentFragmentReleasable = null;
        }

        /*
         * Exception decompiling
         */
        @Override
        public ReleasableBytesReference encodeChunk(int sizeHint, Recycler<BytesRef> recycler) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void completeCurrentFragment(ArrayList<Releasable> releasables) throws IOException {
            this.transferCurrentFragmentReleasable(releasables);
            SubscribableListener<ChunkedRestResponseBodyPart> localNextAvailableFragmentListener = StreamingXContentResponse.this.nextAvailableFragmentListener;
            int newQueueLength = StreamingXContentResponse.this.queueLength.decrementAndGet();
            if (this.fragmentChunksIterator == NO_MORE_FRAGMENTS) {
                StreamingXContentResponse.this.xContentBuilder.close();
                this.isResponseComplete = true;
            } else if (newQueueLength == 0) {
                StreamingXContentResponse.this.xContentBuilder.flush();
                this.isResponsePaused = true;
                assert (this.getNextPartListener == null);
                assert (localNextAvailableFragmentListener != null);
                this.getNextPartListener = localNextAvailableFragmentListener;
            } else {
                StreamingFragment nextFragment = StreamingXContentResponse.this.fragmentQueue.poll();
                assert (nextFragment != null);
                StreamingXContentResponse.this.currentFragmentReleasable = nextFragment.releasable();
                this.fragmentChunksIterator = StreamingXContentResponse.this.getChunksIterator(nextFragment);
            }
        }

        @Override
        public String getResponseContentTypeString() {
            return StreamingXContentResponse.this.xContentBuilder.getResponseContentTypeString();
        }

        private static /* synthetic */ void lambda$encodeChunk$1() {
        }

        private static /* synthetic */ void lambda$encodeChunk$0(RecyclerBytesStreamOutput chunkStream) {
            Releasables.closeExpectNoException((Releasable)chunkStream);
        }
    }
}

