/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.vectors.VectorEncoderDecoder;
import org.elasticsearch.script.field.vectors.MultiDenseVector;

public class ByteMultiDenseVector
implements MultiDenseVector {
    protected final Iterator<byte[]> vectorValues;
    protected final int numVecs;
    protected final int dims;
    private Iterator<float[]> floatDocVectors;
    private float[] magnitudes;
    private final BytesRef magnitudesBytes;

    public ByteMultiDenseVector(Iterator<byte[]> vectorValues, BytesRef magnitudesBytes, int numVecs, int dims) {
        assert (magnitudesBytes.length == numVecs * 4);
        this.vectorValues = vectorValues;
        this.numVecs = numVecs;
        this.dims = dims;
        this.magnitudesBytes = magnitudesBytes;
    }

    @Override
    public Iterator<float[]> getVectors() {
        if (this.floatDocVectors == null) {
            this.floatDocVectors = new ByteToFloatIteratorWrapper(this.vectorValues, this.dims);
        }
        return this.floatDocVectors;
    }

    @Override
    public float[] getMagnitudes() {
        if (this.magnitudes == null) {
            this.magnitudes = VectorEncoderDecoder.getMultiMagnitudes(this.magnitudesBytes);
        }
        return this.magnitudes;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public int size() {
        return this.numVecs;
    }

    static class ByteToFloatIteratorWrapper
    implements Iterator<float[]> {
        private final Iterator<byte[]> byteIterator;
        private final float[] buffer;
        private final int dims;

        ByteToFloatIteratorWrapper(Iterator<byte[]> byteIterator, int dims) {
            this.byteIterator = byteIterator;
            this.buffer = new float[dims];
            this.dims = dims;
        }

        @Override
        public boolean hasNext() {
            return this.byteIterator.hasNext();
        }

        @Override
        public float[] next() {
            byte[] next = this.byteIterator.next();
            for (int i = 0; i < this.dims; ++i) {
                this.buffer[i] = next[i];
            }
            return this.buffer;
        }
    }
}

