/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.countedterms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.BytesKeyedBucketOrds;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

class CountedTermsAggregator
extends TermsAggregator {
    private final BytesKeyedBucketOrds bucketOrds;
    protected final ValuesSource.Bytes.WithOrdinals valuesSource;

    CountedTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, bucketCountThresholds, order, format, Aggregator.SubAggCollectionMode.DEPTH_FIRST, metadata);
        this.valuesSource = valuesSource;
        this.bucketOrds = BytesKeyedBucketOrds.build(context.bigArrays(), cardinality);
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        SortedSetDocValues ords = this.valuesSource.ordinalsValues(aggCtx.getLeafReaderContext());
        SortedDocValues singleton = DocValues.unwrapSingleton((SortedSetDocValues)ords);
        return singleton != null ? this.getLeafCollector(singleton, sub) : this.getLeafCollector(ords, sub);
    }

    private LeafBucketCollector getLeafCollector(final SortedSetDocValues ords, final LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, ords){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (ords.advanceExact(doc)) {
                    long ord = ords.nextOrd();
                    while (ord != -1L) {
                        CountedTermsAggregator.this.collectOrdinal(CountedTermsAggregator.this.bucketOrds.add(owningBucketOrd, ords.lookupOrd(ord)), doc, sub);
                        ord = ords.nextOrd();
                    }
                }
            }
        };
    }

    private LeafBucketCollector getLeafCollector(final SortedDocValues ords, final LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, ords){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (ords.advanceExact(doc)) {
                    CountedTermsAggregator.this.collectOrdinal(CountedTermsAggregator.this.bucketOrds.add(owningBucketOrd, ords.lookupOrd(ords.ordValue())), doc, sub);
                }
            }
        };
    }

    private void collectOrdinal(long bucketOrdinal, int doc, LeafBucketCollector sub) throws IOException {
        if (bucketOrdinal < 0L) {
            bucketOrdinal = -1L - bucketOrdinal;
            this.collectExistingBucket(sub, doc, bucketOrdinal);
        } else {
            this.collectBucket(sub, doc, bucketOrdinal);
        }
    }

    @Override
    public InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
        try (LongArray otherDocCounts = this.bigArrays().newLongArray(owningBucketOrds.size());){
            InternalAggregation[] internalAggregationArray;
            block24: {
                ObjectArray<B[]> topBucketsPerOrd = this.bigArrays().newObjectArray(owningBucketOrds.size());
                try {
                    for (long ordIdx = 0L; ordIdx < topBucketsPerOrd.size(); ++ordIdx) {
                        int size = (int)Math.min(this.bucketOrds.size(), (long)this.bucketCountThresholds.getShardSize());
                        try (BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.bigArrays(), this.partiallyBuiltBucketComparator);){
                            StringTerms.Bucket spare = null;
                            BytesKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrds.get(ordIdx));
                            Supplier<StringTerms.Bucket> emptyBucketBuilder = () -> new StringTerms.Bucket(new BytesRef(), 0L, null, false, 0L, this.format);
                            while (ordsEnum.next()) {
                                long docCount = this.bucketDocCount(ordsEnum.ord());
                                otherDocCounts.increment(ordIdx, docCount);
                                if (spare == null) {
                                    spare = emptyBucketBuilder.get();
                                }
                                ordsEnum.readValue(spare.getTermBytes());
                                spare.setDocCount(docCount);
                                spare.setBucketOrd(ordsEnum.ord());
                                spare = ordered.insertWithOverflow(spare);
                            }
                            topBucketsPerOrd.set(ordIdx, new StringTerms.Bucket[(int)ordered.size()]);
                            for (int i = (int)ordered.size() - 1; i >= 0; --i) {
                                ((StringTerms.Bucket[])topBucketsPerOrd.get((long)ordIdx))[i] = (StringTerms.Bucket)ordered.pop();
                                otherDocCounts.increment(ordIdx, -((StringTerms.Bucket[])topBucketsPerOrd.get(ordIdx))[i].getDocCount());
                                ((StringTerms.Bucket[])topBucketsPerOrd.get(ordIdx))[i].setTermBytes(BytesRef.deepCopyOf((BytesRef)((StringTerms.Bucket[])topBucketsPerOrd.get(ordIdx))[i].getTermBytes()));
                            }
                            continue;
                        }
                    }
                    this.buildSubAggsForAllBuckets(topBucketsPerOrd, InternalTerms.Bucket::getBucketOrd, InternalTerms.Bucket::setAggregations);
                    InternalAggregation[] result = new InternalAggregation[Math.toIntExact(topBucketsPerOrd.size())];
                    for (int ordIdx = 0; ordIdx < result.length; ++ordIdx) {
                        BucketOrder reduceOrder;
                        if (!InternalOrder.isKeyOrder(this.order)) {
                            reduceOrder = InternalOrder.key(true);
                            Arrays.sort((StringTerms.Bucket[])topBucketsPerOrd.get(ordIdx), reduceOrder.comparator());
                        } else {
                            reduceOrder = this.order;
                        }
                        result[ordIdx] = new StringTerms(this.name, reduceOrder, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.metadata(), this.format, this.bucketCountThresholds.getShardSize(), false, otherDocCounts.get(ordIdx), Arrays.asList((StringTerms.Bucket[])topBucketsPerOrd.get(ordIdx)), null);
                    }
                    internalAggregationArray = result;
                    if (topBucketsPerOrd == null) break block24;
                }
                catch (Throwable throwable) {
                    if (topBucketsPerOrd != null) {
                        try {
                            topBucketsPerOrd.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                topBucketsPerOrd.close();
            }
            return internalAggregationArray;
        }
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new StringTerms(this.name, this.order, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.metadata(), this.format, this.bucketCountThresholds.getShardSize(), false, 0L, Collections.emptyList(), (Long)0L);
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("total_buckets", this.bucketOrds.size());
    }

    @Override
    protected void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }
}

