/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Map;
import java.util.Random;
import org.elasticsearch.common.util.SetBackedScalingCuckooFilter;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.DeferableBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.nested.NestedAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public abstract class AbstractRareTermsAggregator
extends DeferableBucketAggregator {
    static final BucketOrder ORDER = BucketOrder.compound(BucketOrder.count(true), BucketOrder.key(true));
    protected final long maxDocCount;
    private final double precision;
    protected final DocValueFormat format;
    private final int filterSeed;

    AbstractRareTermsAggregator(String name, AggregatorFactories factories, AggregationContext context, Aggregator parent, Map<String, Object> metadata, long maxDocCount, double precision, DocValueFormat format) throws IOException {
        super(name, factories, context, parent, metadata);
        this.maxDocCount = maxDocCount;
        this.precision = precision;
        this.format = format;
        this.filterSeed = context.shardRandomSeed();
        String scoringAgg = this.subAggsNeedScore();
        String nestedAgg = AbstractRareTermsAggregator.descendsFromNestedAggregator(parent);
        if (scoringAgg != null && nestedAgg != null) {
            throw new IllegalStateException("RareTerms agg [" + this.name() + "] is the child of the nested agg [" + nestedAgg + "], and also has a scoring child agg [" + scoringAgg + "].  This combination is not supported because it requires executing in [depth_first] mode, which the RareTerms agg cannot do.");
        }
    }

    protected SetBackedScalingCuckooFilter newFilter() {
        SetBackedScalingCuckooFilter filter = new SetBackedScalingCuckooFilter(10000, new Random(this.filterSeed), this.precision);
        filter.registerBreaker(x$0 -> this.addRequestCircuitBreakerBytes((long)x$0));
        return filter;
    }

    @Override
    protected boolean shouldDefer(Aggregator aggregator) {
        return true;
    }

    private String subAggsNeedScore() {
        for (Aggregator subAgg : this.subAggregators) {
            if (!subAgg.scoreMode().needsScores()) continue;
            return subAgg.name();
        }
        return null;
    }

    private static String descendsFromNestedAggregator(Aggregator parent) {
        while (parent != null) {
            if (parent.getClass() == NestedAggregator.class) {
                return parent.name();
            }
            parent = parent.parent();
        }
        return null;
    }
}

