/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.common.util.ObjectArrayPriorityQueue;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.BucketSignificancePriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.DoubleTerms;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.InternalMappedTerms;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.SignificanceLookup;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantLongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public final class NumericTermsAggregator
extends TermsAggregator {
    private final ResultStrategy<?, ?> resultStrategy;
    private final ValuesSource.Numeric valuesSource;
    private final LongKeyedBucketOrds bucketOrds;
    private final IncludeExclude.LongFilter longFilter;
    private final boolean excludeDeletedDocs;

    public NumericTermsAggregator(String name, AggregatorFactories factories, Function<NumericTermsAggregator, ResultStrategy<?, ?>> resultStrategy, ValuesSource.Numeric valuesSource, DocValueFormat format, BucketOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, AggregationContext context, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, IncludeExclude.LongFilter longFilter, CardinalityUpperBound cardinality, Map<String, Object> metadata, boolean excludeDeletedDocs) throws IOException {
        super(name, factories, context, parent, bucketCountThresholds, order, format, subAggCollectMode, metadata);
        this.resultStrategy = resultStrategy.apply(this);
        this.valuesSource = valuesSource;
        this.longFilter = longFilter;
        this.bucketOrds = LongKeyedBucketOrds.build(this.bigArrays(), cardinality);
        this.excludeDeletedDocs = excludeDeletedDocs;
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        SortedNumericDocValues values = this.resultStrategy.getValues(aggCtx.getLeafReaderContext());
        NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        return this.resultStrategy.wrapCollector(singleton != null ? this.getLeafCollector(singleton, sub) : this.getLeafCollector(values, sub));
    }

    private LeafBucketCollector getLeafCollector(final SortedNumericDocValues values, final LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    long previous = Long.MAX_VALUE;
                    for (int i = 0; i < values.docValueCount(); ++i) {
                        long val = values.nextValue();
                        if (previous == val && i != 0) continue;
                        NumericTermsAggregator.this.collectValue(val, doc, owningBucketOrd, sub);
                        previous = val;
                    }
                }
            }
        };
    }

    private LeafBucketCollector getLeafCollector(final NumericDocValues values, final LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    NumericTermsAggregator.this.collectValue(values.longValue(), doc, owningBucketOrd, sub);
                }
            }
        };
    }

    private void collectValue(long val, int doc, long owningBucketOrd, LeafBucketCollector sub) throws IOException {
        if (this.longFilter == null || this.longFilter.accept(val)) {
            long bucketOrdinal = this.bucketOrds.add(owningBucketOrd, val);
            if (bucketOrdinal < 0L) {
                bucketOrdinal = -1L - bucketOrdinal;
                this.collectExistingBucket(sub, doc, bucketOrdinal);
            } else {
                this.collectBucket(sub, doc, bucketOrdinal);
            }
        }
    }

    @Override
    public InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
        return this.resultStrategy.buildAggregations(owningBucketOrds);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.resultStrategy.buildEmptyResult();
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{() -> super.doClose(), this.bucketOrds, this.resultStrategy});
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("result_strategy", this.resultStrategy.describe());
        add.accept("total_buckets", this.bucketOrds.size());
    }

    abstract class ResultStrategy<R extends InternalAggregation, B extends InternalMultiBucketAggregation.InternalBucket>
    implements Releasable {
        ResultStrategy() {
        }

        private InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
            try (LongArray otherDocCounts = NumericTermsAggregator.this.bigArrays().newLongArray(owningBucketOrds.size(), true);){
                InternalAggregation[] internalAggregationArray;
                block23: {
                    ObjectArray<B[]> topBucketsPerOrd = this.buildTopBucketsPerOrd(owningBucketOrds.size());
                    try {
                        for (long ordIdx = 0L; ordIdx < topBucketsPerOrd.size(); ++ordIdx) {
                            long owningBucketOrd = owningBucketOrds.get(ordIdx);
                            this.collectZeroDocEntriesIfNeeded(owningBucketOrd, NumericTermsAggregator.this.excludeDeletedDocs);
                            long bucketsInOrd = NumericTermsAggregator.this.bucketOrds.bucketsInOrd(owningBucketOrd);
                            int size = (int)Math.min(bucketsInOrd, (long)NumericTermsAggregator.this.bucketCountThresholds.getShardSize());
                            try (ObjectArrayPriorityQueue<B> ordered = this.buildPriorityQueue(size);){
                                InternalMultiBucketAggregation.InternalBucket spare = null;
                                LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = NumericTermsAggregator.this.bucketOrds.ordsEnum(owningBucketOrd);
                                Supplier<B> emptyBucketBuilder = this.emptyBucketBuilder(owningBucketOrd);
                                while (ordsEnum.next()) {
                                    long docCount = NumericTermsAggregator.this.bucketDocCount(ordsEnum.ord());
                                    otherDocCounts.increment(ordIdx, docCount);
                                    if (docCount < NumericTermsAggregator.this.bucketCountThresholds.getShardMinDocCount()) continue;
                                    if (spare == null) {
                                        spare = (InternalMultiBucketAggregation.InternalBucket)emptyBucketBuilder.get();
                                    }
                                    this.updateBucket(spare, ordsEnum, docCount);
                                    spare = ordered.insertWithOverflow(spare);
                                }
                                InternalMultiBucketAggregation.InternalBucket[] bucketsForOrd = this.buildBuckets((int)ordered.size());
                                topBucketsPerOrd.set(ordIdx, bucketsForOrd);
                                for (int b = (int)ordered.size() - 1; b >= 0; --b) {
                                    ((InternalMultiBucketAggregation.InternalBucket[])topBucketsPerOrd.get((long)ordIdx))[b] = (InternalMultiBucketAggregation.InternalBucket)ordered.pop();
                                    otherDocCounts.increment(ordIdx, -((InternalMultiBucketAggregation.InternalBucket[])topBucketsPerOrd.get(ordIdx))[b].getDocCount());
                                }
                                continue;
                            }
                        }
                        this.buildSubAggs(topBucketsPerOrd);
                        InternalAggregation[] result = new InternalAggregation[Math.toIntExact(topBucketsPerOrd.size())];
                        for (int ordIdx = 0; ordIdx < result.length; ++ordIdx) {
                            result[ordIdx] = this.buildResult(owningBucketOrds.get(ordIdx), otherDocCounts.get(ordIdx), (InternalMultiBucketAggregation.InternalBucket[])topBucketsPerOrd.get(ordIdx));
                        }
                        internalAggregationArray = result;
                        if (topBucketsPerOrd == null) break block23;
                    }
                    catch (Throwable throwable) {
                        if (topBucketsPerOrd != null) {
                            try {
                                topBucketsPerOrd.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    topBucketsPerOrd.close();
                }
                return internalAggregationArray;
            }
        }

        abstract String describe();

        abstract SortedNumericDocValues getValues(LeafReaderContext var1) throws IOException;

        abstract LeafBucketCollector wrapCollector(LeafBucketCollector var1);

        abstract ObjectArray<B[]> buildTopBucketsPerOrd(long var1);

        abstract B[] buildBuckets(int var1);

        abstract Supplier<B> emptyBucketBuilder(long var1);

        abstract void updateBucket(B var1, LongKeyedBucketOrds.BucketOrdsEnum var2, long var3) throws IOException;

        abstract ObjectArrayPriorityQueue<B> buildPriorityQueue(int var1);

        abstract void buildSubAggs(ObjectArray<B[]> var1) throws IOException;

        abstract void collectZeroDocEntriesIfNeeded(long var1, boolean var3) throws IOException;

        abstract R buildResult(long var1, long var3, B[] var5);

        abstract R buildEmptyResult();
    }

    class SignificantLongTermsResults
    extends ResultStrategy<SignificantLongTerms, SignificantLongTerms.Bucket> {
        private final SignificanceLookup.BackgroundFrequencyForLong backgroundFrequencies;
        private final long supersetSize;
        private final SignificanceHeuristic significanceHeuristic;
        private LongArray subsetSizes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SignificantLongTermsResults(SignificanceLookup significanceLookup, SignificanceHeuristic significanceHeuristic, CardinalityUpperBound cardinality) {
            this.backgroundFrequencies = significanceLookup.longLookup(NumericTermsAggregator.this.bigArrays(), cardinality);
            this.supersetSize = significanceLookup.supersetSize();
            this.significanceHeuristic = significanceHeuristic;
            boolean success = false;
            try {
                this.subsetSizes = NumericTermsAggregator.this.bigArrays().newLongArray(1L, true);
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        @Override
        SortedNumericDocValues getValues(LeafReaderContext ctx) throws IOException {
            return NumericTermsAggregator.this.valuesSource.longValues(ctx);
        }

        @Override
        String describe() {
            return "significant_terms";
        }

        @Override
        LeafBucketCollector wrapCollector(LeafBucketCollector primary) {
            return new LeafBucketCollectorBase(primary, null){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    super.collect(doc, owningBucketOrd);
                    SignificantLongTermsResults.this.subsetSizes = NumericTermsAggregator.this.bigArrays().grow(SignificantLongTermsResults.this.subsetSizes, owningBucketOrd + 1L);
                    SignificantLongTermsResults.this.subsetSizes.increment(owningBucketOrd, 1L);
                }
            };
        }

        @Override
        ObjectArray<SignificantLongTerms.Bucket[]> buildTopBucketsPerOrd(long size) {
            return NumericTermsAggregator.this.bigArrays().newObjectArray(size);
        }

        SignificantLongTerms.Bucket[] buildBuckets(int size) {
            return new SignificantLongTerms.Bucket[size];
        }

        @Override
        Supplier<SignificantLongTerms.Bucket> emptyBucketBuilder(long owningBucketOrd) {
            long subsetSize = this.subsetSizes.get(owningBucketOrd);
            return () -> new SignificantLongTerms.Bucket(0L, subsetSize, 0L, this.supersetSize, 0L, null, NumericTermsAggregator.this.format, 0.0);
        }

        @Override
        void updateBucket(SignificantLongTerms.Bucket spare, LongKeyedBucketOrds.BucketOrdsEnum ordsEnum, long docCount) throws IOException {
            spare.term = ordsEnum.value();
            spare.subsetDf = docCount;
            spare.supersetDf = this.backgroundFrequencies.freq(spare.term);
            spare.bucketOrd = ordsEnum.ord();
            spare.updateScore(this.significanceHeuristic);
        }

        @Override
        ObjectArrayPriorityQueue<SignificantLongTerms.Bucket> buildPriorityQueue(int size) {
            return new BucketSignificancePriorityQueue<SignificantLongTerms.Bucket>(size, NumericTermsAggregator.this.bigArrays());
        }

        @Override
        void buildSubAggs(ObjectArray<SignificantLongTerms.Bucket[]> topBucketsPerOrd) throws IOException {
            NumericTermsAggregator.this.buildSubAggsForAllBuckets(topBucketsPerOrd, b -> b.bucketOrd, (b, aggs) -> {
                b.aggregations = aggs;
            });
        }

        @Override
        void collectZeroDocEntriesIfNeeded(long owningBucketOrd, boolean excludeDeletedDocs) throws IOException {
        }

        SignificantLongTerms buildResult(long owningBucketOrd, long otherDocCoun, SignificantLongTerms.Bucket[] topBuckets) {
            return new SignificantLongTerms(NumericTermsAggregator.this.name, NumericTermsAggregator.this.bucketCountThresholds.getRequiredSize(), NumericTermsAggregator.this.bucketCountThresholds.getMinDocCount(), NumericTermsAggregator.this.metadata(), NumericTermsAggregator.this.format, this.subsetSizes.get(owningBucketOrd), this.supersetSize, this.significanceHeuristic, Arrays.asList(topBuckets));
        }

        @Override
        SignificantLongTerms buildEmptyResult() {
            return new SignificantLongTerms(NumericTermsAggregator.this.name, NumericTermsAggregator.this.bucketCountThresholds.getRequiredSize(), NumericTermsAggregator.this.bucketCountThresholds.getMinDocCount(), NumericTermsAggregator.this.metadata(), NumericTermsAggregator.this.format, 0L, this.supersetSize, this.significanceHeuristic, Collections.emptyList());
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.backgroundFrequencies, this.subsetSizes});
        }
    }

    class DoubleTermsResults
    extends StandardTermsResultStrategy<DoubleTerms, DoubleTerms.Bucket> {
        DoubleTermsResults(boolean showTermDocCountError) {
            super(showTermDocCountError);
        }

        @Override
        String describe() {
            return "double_terms";
        }

        @Override
        SortedNumericDocValues getValues(LeafReaderContext ctx) throws IOException {
            return FieldData.toSortableLongBits(NumericTermsAggregator.this.valuesSource.doubleValues(ctx));
        }

        @Override
        ObjectArray<DoubleTerms.Bucket[]> buildTopBucketsPerOrd(long size) {
            return NumericTermsAggregator.this.bigArrays().newObjectArray(size);
        }

        DoubleTerms.Bucket[] buildBuckets(int size) {
            return new DoubleTerms.Bucket[size];
        }

        @Override
        DoubleTerms.Bucket buildEmptyBucket() {
            return new DoubleTerms.Bucket(0.0, 0L, null, this.showTermDocCountError, 0L, NumericTermsAggregator.this.format);
        }

        @Override
        void updateBucket(DoubleTerms.Bucket spare, LongKeyedBucketOrds.BucketOrdsEnum ordsEnum, long docCount) {
            spare.term = NumericUtils.sortableLongToDouble((long)ordsEnum.value());
            spare.docCount = docCount;
            spare.bucketOrd = ordsEnum.ord();
        }

        DoubleTerms buildResult(long owningBucketOrd, long otherDocCount, DoubleTerms.Bucket[] topBuckets) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(NumericTermsAggregator.this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBuckets, reduceOrder.comparator());
            } else {
                reduceOrder = NumericTermsAggregator.this.order;
            }
            return new DoubleTerms(NumericTermsAggregator.this.name, reduceOrder, NumericTermsAggregator.this.order, NumericTermsAggregator.this.bucketCountThresholds.getRequiredSize(), NumericTermsAggregator.this.bucketCountThresholds.getMinDocCount(), NumericTermsAggregator.this.metadata(), NumericTermsAggregator.this.format, NumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, Arrays.asList(topBuckets), null);
        }

        @Override
        DoubleTerms buildEmptyResult() {
            return new DoubleTerms(NumericTermsAggregator.this.name, NumericTermsAggregator.this.order, NumericTermsAggregator.this.order, NumericTermsAggregator.this.bucketCountThresholds.getRequiredSize(), NumericTermsAggregator.this.bucketCountThresholds.getMinDocCount(), NumericTermsAggregator.this.metadata(), NumericTermsAggregator.this.format, NumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, 0L, Collections.emptyList(), (Long)0L);
        }
    }

    class LongTermsResults
    extends StandardTermsResultStrategy<LongTerms, LongTerms.Bucket> {
        LongTermsResults(boolean showTermDocCountError) {
            super(showTermDocCountError);
        }

        @Override
        String describe() {
            return "long_terms";
        }

        @Override
        SortedNumericDocValues getValues(LeafReaderContext ctx) throws IOException {
            return NumericTermsAggregator.this.valuesSource.longValues(ctx);
        }

        @Override
        ObjectArray<LongTerms.Bucket[]> buildTopBucketsPerOrd(long size) {
            return NumericTermsAggregator.this.bigArrays().newObjectArray(size);
        }

        LongTerms.Bucket[] buildBuckets(int size) {
            return new LongTerms.Bucket[size];
        }

        @Override
        LongTerms.Bucket buildEmptyBucket() {
            return new LongTerms.Bucket(0L, 0L, null, this.showTermDocCountError, 0L, NumericTermsAggregator.this.format);
        }

        @Override
        void updateBucket(LongTerms.Bucket spare, LongKeyedBucketOrds.BucketOrdsEnum ordsEnum, long docCount) {
            spare.term = ordsEnum.value();
            spare.docCount = docCount;
            spare.bucketOrd = ordsEnum.ord();
        }

        LongTerms buildResult(long owningBucketOrd, long otherDocCount, LongTerms.Bucket[] topBuckets) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(NumericTermsAggregator.this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBuckets, reduceOrder.comparator());
            } else {
                reduceOrder = NumericTermsAggregator.this.order;
            }
            return new LongTerms(NumericTermsAggregator.this.name, reduceOrder, NumericTermsAggregator.this.order, NumericTermsAggregator.this.bucketCountThresholds.getRequiredSize(), NumericTermsAggregator.this.bucketCountThresholds.getMinDocCount(), NumericTermsAggregator.this.metadata(), NumericTermsAggregator.this.format, NumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, Arrays.asList(topBuckets), null);
        }

        @Override
        LongTerms buildEmptyResult() {
            return new LongTerms(NumericTermsAggregator.this.name, NumericTermsAggregator.this.order, NumericTermsAggregator.this.order, NumericTermsAggregator.this.bucketCountThresholds.getRequiredSize(), NumericTermsAggregator.this.bucketCountThresholds.getMinDocCount(), NumericTermsAggregator.this.metadata(), NumericTermsAggregator.this.format, NumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, 0L, Collections.emptyList(), (Long)0L);
        }
    }

    abstract class StandardTermsResultStrategy<R extends InternalMappedTerms<R, B>, B extends InternalTerms.Bucket<B>>
    extends ResultStrategy<R, B> {
        protected final boolean showTermDocCountError;

        StandardTermsResultStrategy(boolean showTermDocCountError) {
            this.showTermDocCountError = showTermDocCountError;
        }

        @Override
        final LeafBucketCollector wrapCollector(LeafBucketCollector primary) {
            return primary;
        }

        @Override
        final ObjectArrayPriorityQueue<B> buildPriorityQueue(int size) {
            return new BucketPriorityQueue(size, NumericTermsAggregator.this.bigArrays(), NumericTermsAggregator.this.partiallyBuiltBucketComparator);
        }

        @Override
        final void buildSubAggs(ObjectArray<B[]> topBucketsPerOrd) throws IOException {
            NumericTermsAggregator.this.buildSubAggsForAllBuckets(topBucketsPerOrd, b -> b.bucketOrd, (b, aggs) -> {
                b.aggregations = aggs;
            });
        }

        @Override
        Supplier<B> emptyBucketBuilder(long owningBucketOrd) {
            return this::buildEmptyBucket;
        }

        abstract B buildEmptyBucket();

        @Override
        final void collectZeroDocEntriesIfNeeded(long owningBucketOrd, boolean excludeDeletedDocs) throws IOException {
            if (NumericTermsAggregator.this.bucketCountThresholds.getMinDocCount() != 0L) {
                return;
            }
            if (InternalOrder.isCountDesc(NumericTermsAggregator.this.order) && NumericTermsAggregator.this.bucketOrds.bucketsInOrd(owningBucketOrd) >= (long)NumericTermsAggregator.this.bucketCountThresholds.getRequiredSize()) {
                return;
            }
            for (LeafReaderContext ctx : NumericTermsAggregator.this.searcher().getTopReaderContext().leaves()) {
                SortedNumericDocValues values = this.getValues(ctx);
                for (int docId = 0; docId < ctx.reader().maxDoc(); ++docId) {
                    if (excludeDeletedDocs && ctx.reader().getLiveDocs() != null && !ctx.reader().getLiveDocs().get(docId) || !values.advanceExact(docId)) continue;
                    int valueCount = values.docValueCount();
                    for (int v = 0; v < valueCount; ++v) {
                        long value = values.nextValue();
                        if (NumericTermsAggregator.this.longFilter != null && !NumericTermsAggregator.this.longFilter.accept(value)) continue;
                        NumericTermsAggregator.this.bucketOrds.add(owningBucketOrd, value);
                    }
                }
            }
        }

        public final void close() {
        }
    }
}

