/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.profile.ProfileResult;
import org.elasticsearch.search.profile.query.CollectorResult;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class QueryProfileShardResult
implements Writeable,
ToXContentObject {
    public static final String COLLECTOR = "collector";
    public static final String REWRITE_TIME = "rewrite_time";
    public static final String QUERY_ARRAY = "query";
    public static final String VECTOR_OPERATIONS_COUNT = "vector_operations_count";
    private final List<ProfileResult> queryProfileResults;
    private final CollectorResult profileCollector;
    private final long rewriteTime;
    private final Long vectorOperationsCount;

    public QueryProfileShardResult(List<ProfileResult> queryProfileResults, long rewriteTime, CollectorResult profileCollector, @Nullable Long vectorOperationsCount) {
        assert (profileCollector != null);
        this.queryProfileResults = queryProfileResults;
        this.profileCollector = profileCollector;
        this.rewriteTime = rewriteTime;
        this.vectorOperationsCount = vectorOperationsCount;
    }

    public QueryProfileShardResult(StreamInput in) throws IOException {
        int profileSize = in.readVInt();
        this.queryProfileResults = new ArrayList<ProfileResult>(profileSize);
        for (int j = 0; j < profileSize; ++j) {
            this.queryProfileResults.add(new ProfileResult(in));
        }
        this.profileCollector = new CollectorResult(in);
        this.rewriteTime = in.readLong();
        this.vectorOperationsCount = in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? in.readOptionalLong() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.queryProfileResults.size());
        for (ProfileResult p : this.queryProfileResults) {
            p.writeTo(out);
        }
        this.profileCollector.writeTo(out);
        out.writeLong(this.rewriteTime);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            out.writeOptionalLong(this.vectorOperationsCount);
        }
    }

    public List<ProfileResult> getQueryResults() {
        return Collections.unmodifiableList(this.queryProfileResults);
    }

    public long getRewriteTime() {
        return this.rewriteTime;
    }

    public CollectorResult getCollectorResult() {
        return this.profileCollector;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.vectorOperationsCount != null) {
            builder.field(VECTOR_OPERATIONS_COUNT, this.vectorOperationsCount);
        }
        builder.startArray(QUERY_ARRAY);
        for (ProfileResult p : this.queryProfileResults) {
            p.toXContent(builder, params);
        }
        builder.endArray();
        builder.field(REWRITE_TIME, this.rewriteTime);
        builder.startArray(COLLECTOR);
        this.profileCollector.toXContent(builder, params);
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryProfileShardResult other = (QueryProfileShardResult)obj;
        return this.queryProfileResults.equals(other.queryProfileResults) && this.profileCollector.equals(other.profileCollector) && this.rewriteTime == other.rewriteTime;
    }

    public int hashCode() {
        return Objects.hash(this.queryProfileResults, this.profileCollector, this.rewriteTime);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

