/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchShardTask;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.lucene.grouping.TopFieldGroups;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.QueryPhase;
import org.elasticsearch.search.query.SearchTimeoutException;
import org.elasticsearch.search.rescore.RescoreContext;

public class RescorePhase {
    private RescorePhase() {
    }

    public static void execute(SearchContext context) {
        if (context.size() == 0 || context.rescore() == null || context.rescore().isEmpty()) {
            return;
        }
        Object topDocs = context.queryResult().topDocs().topDocs;
        if (topDocs.scoreDocs.length == 0) {
            return;
        }
        TopFieldGroups topGroups = null;
        if (topDocs instanceof TopFieldGroups) {
            TopFieldGroups topFieldGroups = (TopFieldGroups)((Object)topDocs);
            assert (context.collapse() != null);
            topGroups = topFieldGroups;
        }
        try {
            Runnable cancellationCheck = RescorePhase.getCancellationChecks(context);
            for (RescoreContext ctx : context.rescore()) {
                ctx.setCancellationChecker(cancellationCheck);
                topDocs = ctx.rescorer().rescore((TopDocs)topDocs, context.searcher(), ctx);
                assert (context.sort() == null && RescorePhase.topDocsSortedByScore(topDocs)) : "topdocs should be sorted after rescore";
                ctx.setCancellationChecker(null);
            }
            if (topGroups != null) {
                assert (context.collapse() != null);
                topDocs = RescorePhase.rewriteTopGroups(topGroups, topDocs);
            }
            context.queryResult().topDocs(new TopDocsAndMaxScore((TopDocs)topDocs, topDocs.scoreDocs[0].score), context.queryResult().sortValueFormats());
        }
        catch (IOException e) {
            throw new ElasticsearchException("Rescore Phase Failed", (Throwable)e, new Object[0]);
        }
        catch (ContextIndexSearcher.TimeExceededException e) {
            if (!context.request().allowPartialSearchResults()) {
                throw new SearchTimeoutException(context.shardTarget(), "Time exceeded");
            }
            context.queryResult().searchTimedOut(true);
        }
    }

    private static TopFieldGroups rewriteTopGroups(TopFieldGroups originalTopGroups, TopDocs rescoredTopDocs) {
        assert (originalTopGroups.fields.length == 1 && SortField.FIELD_SCORE.equals((Object)originalTopGroups.fields[0])) : "rescore must always sort by score descending";
        Map<Integer, Object> docIdToGroupValue = Maps.newMapWithExpectedSize(originalTopGroups.scoreDocs.length);
        for (int i = 0; i < originalTopGroups.scoreDocs.length; ++i) {
            docIdToGroupValue.put(originalTopGroups.scoreDocs[i].doc, originalTopGroups.groupValues[i]);
        }
        FieldDoc[] newScoreDocs = new FieldDoc[rescoredTopDocs.scoreDocs.length];
        Object[] newGroupValues = new Object[originalTopGroups.groupValues.length];
        int pos = 0;
        for (ScoreDoc doc : rescoredTopDocs.scoreDocs) {
            newScoreDocs[pos] = new FieldDoc(doc.doc, doc.score, new Object[]{Float.valueOf(doc.score)});
            newGroupValues[pos++] = docIdToGroupValue.get(doc.doc);
        }
        return new TopFieldGroups(originalTopGroups.field, originalTopGroups.totalHits, (ScoreDoc[])newScoreDocs, originalTopGroups.fields, newGroupValues);
    }

    private static boolean topDocsSortedByScore(TopDocs topDocs) {
        if (topDocs == null || topDocs.scoreDocs == null || topDocs.scoreDocs.length < 2) {
            return true;
        }
        float lastScore = topDocs.scoreDocs[0].score;
        for (int i = 1; i < topDocs.scoreDocs.length; ++i) {
            ScoreDoc doc = topDocs.scoreDocs[i];
            if (Float.compare(doc.score, lastScore) > 0) {
                return false;
            }
            lastScore = doc.score;
        }
        return true;
    }

    static Runnable getCancellationChecks(SearchContext context) {
        Runnable timeoutRunnable;
        ArrayList<Runnable> cancellationChecks = new ArrayList<Runnable>();
        if (context.lowLevelCancellation()) {
            cancellationChecks.add(() -> {
                SearchShardTask task = context.getTask();
                if (task != null) {
                    task.ensureNotCancelled();
                }
            });
        }
        if ((timeoutRunnable = QueryPhase.getTimeoutCheck(context)) != null) {
            cancellationChecks.add(timeoutRunnable);
        }
        return () -> {
            for (Runnable check : cancellationChecks) {
                check.run();
            }
        };
    }
}

