/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.security.AccessController;

public final class JaybirdSystemProperties {
    private static final String COMMON_PREFIX = "org.firebirdsql.";
    private static final String JDBC_PREFIX = "org.firebirdsql.jdbc.";
    private static final String WIRE_PREFIX = "org.firebirdsql.wire.";
    public static final String SYNC_WRAP_NATIVE_LIBRARY_PROP = "org.firebirdsql.jna.syncWrapNativeLibrary";
    public static final String PROCESS_ID_PROP = "org.firebirdsql.jdbc.pid";
    public static final String PROCESS_NAME_PROP = "org.firebirdsql.jdbc.processName";
    public static final String DEFAULT_CONNECTION_ENCODING_PROPERTY = "org.firebirdsql.jdbc.defaultConnectionEncoding";
    public static final String REQUIRE_CONNECTION_ENCODING_PROPERTY = "org.firebirdsql.jdbc.requireConnectionEncoding";
    public static final String DEFAULT_ENABLE_PROTOCOL = "org.firebirdsql.jdbc.defaultEnableProtocol";
    public static final String DEFAULT_REPORT_SQL_WARNINGS = "org.firebirdsql.jdbc.defaultReportSQLWarnings";
    public static final String DEFAULT_ASYNC_FETCH = "org.firebirdsql.jdbc.defaultAsyncFetch";
    public static final String DATATYPE_CODER_CACHE_SIZE = "org.firebirdsql.datatypeCoderCacheSize";
    public static final String NATIVE_LIBRARY_SHUTDOWN_DISABLED = "org.firebirdsql.nativeResourceShutdownDisabled";
    public static final String WIRE_DEFLATE_BUFFER_SIZE = "org.firebirdsql.wire.deflateBufferSize";
    public static final String WIRE_INFLATE_BUFFER_SIZE = "org.firebirdsql.wire.inflateBufferSize";
    public static final String WIRE_DECRYPT_BUFFER_SIZE = "org.firebirdsql.wire.decryptBufferSize";
    public static final String WIRE_INPUT_BUFFER_SIZE = "org.firebirdsql.wire.inputBufferSize";
    public static final String WIRE_OUTPUT_BUFFER_SIZE = "org.firebirdsql.wire.outputBufferSize";

    private JaybirdSystemProperties() {
    }

    public static boolean isSyncWrapNativeLibrary() {
        return JaybirdSystemProperties.getBooleanSystemPropertyPrivileged(SYNC_WRAP_NATIVE_LIBRARY_PROP);
    }

    public static Integer getProcessId() {
        return JaybirdSystemProperties.getIntegerSystemPropertyPrivileged(PROCESS_ID_PROP);
    }

    public static String getProcessName() {
        return JaybirdSystemProperties.getSystemPropertyPrivileged(PROCESS_NAME_PROP);
    }

    public static String getDefaultConnectionEncoding() {
        return JaybirdSystemProperties.getSystemPropertyPrivileged(DEFAULT_CONNECTION_ENCODING_PROPERTY);
    }

    public static boolean isRequireConnectionEncoding() {
        return JaybirdSystemProperties.getBooleanSystemPropertyPrivileged(REQUIRE_CONNECTION_ENCODING_PROPERTY);
    }

    public static boolean isNativeResourceShutdownDisabled() {
        return JaybirdSystemProperties.getBooleanSystemPropertyPrivileged(NATIVE_LIBRARY_SHUTDOWN_DISABLED);
    }

    public static int getDatatypeCoderCacheSize(int defaultValue) {
        return JaybirdSystemProperties.getWithDefault(DATATYPE_CODER_CACHE_SIZE, defaultValue);
    }

    public static int getWireDeflateBufferSize(int defaultValue) {
        return JaybirdSystemProperties.getWithDefault(WIRE_DEFLATE_BUFFER_SIZE, defaultValue);
    }

    public static int getWireInflateBufferSize(int defaultValue) {
        return JaybirdSystemProperties.getWithDefault(WIRE_INFLATE_BUFFER_SIZE, defaultValue);
    }

    public static int getWireDecryptBufferSize(int defaultValue) {
        return JaybirdSystemProperties.getWithDefault(WIRE_DECRYPT_BUFFER_SIZE, defaultValue);
    }

    public static int getWireInputBufferSize(int defaultValue) {
        return JaybirdSystemProperties.getWithDefault(WIRE_INPUT_BUFFER_SIZE, defaultValue);
    }

    public static int getWireOutputBufferSize(int defaultValue) {
        return JaybirdSystemProperties.getWithDefault(WIRE_OUTPUT_BUFFER_SIZE, defaultValue);
    }

    public static String getDefaultEnableProtocol() {
        return JaybirdSystemProperties.getSystemPropertyPrivileged(DEFAULT_ENABLE_PROTOCOL);
    }

    public static String getDefaultReportSQLWarnings() {
        return JaybirdSystemProperties.getSystemPropertyPrivileged(DEFAULT_REPORT_SQL_WARNINGS);
    }

    public static Boolean getDefaultAsyncFetch() {
        String asyncFetch = JaybirdSystemProperties.getSystemPropertyPrivileged(DEFAULT_ASYNC_FETCH);
        if (asyncFetch == null) {
            return null;
        }
        return asyncFetch.isBlank() || Boolean.parseBoolean(asyncFetch);
    }

    private static int getWithDefault(String propertyName, int defaultValue) {
        Integer value = JaybirdSystemProperties.getIntegerSystemPropertyPrivileged(propertyName);
        return value != null ? value : defaultValue;
    }

    private static String getSystemPropertyPrivileged(String propertyName) {
        return AccessController.doPrivileged(() -> System.getProperty(propertyName));
    }

    private static boolean getBooleanSystemPropertyPrivileged(String propertyName) {
        return AccessController.doPrivileged(() -> Boolean.getBoolean(propertyName));
    }

    private static Integer getIntegerSystemPropertyPrivileged(String propertyName) {
        return AccessController.doPrivileged(() -> Integer.getInteger(propertyName));
    }
}

