/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.argument;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.ParameterBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.argument.ArgumentType;
import org.firebirdsql.gds.impl.argument.TypedArgument;

public final class BigIntArgument
extends TypedArgument {
    private static final EnumSet<ArgumentType> SUPPORTED_ARGUMENT_TYPES = EnumSet.of(ArgumentType.TraditionalDpb, ArgumentType.Wide, ArgumentType.IntSpb, ArgumentType.BigIntSpb);
    private static final long serialVersionUID = -6152038317321572191L;
    private final long value;

    public BigIntArgument(int type, ArgumentType argumentType, long value) {
        super(type, argumentType);
        if (!SUPPORTED_ARGUMENT_TYPES.contains((Object)argumentType)) {
            throw new IllegalArgumentException("Invalid argument type: " + argumentType);
        }
        this.value = value;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.getType());
        this.writeValue(outputStream, this.value);
    }

    @Override
    public int getLength() {
        if (this.argumentType == ArgumentType.IntSpb) {
            return 5 + this.argumentType.getLengthSize();
        }
        return 9 + this.argumentType.getLengthSize();
    }

    private void writeValue(OutputStream outputStream, long value) throws IOException {
        if (this.argumentType == ArgumentType.IntSpb) {
            this.argumentType.writeLength(4, outputStream);
            VaxEncoding.encodeVaxIntegerWithoutLength(outputStream, (int)value);
        } else {
            this.argumentType.writeLength(8, outputStream);
            VaxEncoding.encodeVaxLongWithoutLength(outputStream, value);
        }
    }

    @Override
    public long getValueAsLong() {
        return this.value;
    }

    @Override
    public void copyTo(ParameterBuffer buffer, Encoding encoding) {
        buffer.addArgument(this.getType(), this.value);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BigIntArgument)) {
            return false;
        }
        BigIntArgument otherBigIntArgument = (BigIntArgument)other;
        return this.getType() == otherBigIntArgument.getType() && this.value == otherBigIntArgument.value;
    }

    public int hashCode() {
        int result = 943 + this.getType();
        result = 41 * result + Long.hashCode(this.value);
        return result;
    }
}

