/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.argument;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.ParameterBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.argument.ArgumentType;
import org.firebirdsql.gds.impl.argument.TypedArgument;

public final class NumericArgument
extends TypedArgument {
    private static final EnumSet<ArgumentType> SUPPORTED_ARGUMENT_TYPES = EnumSet.of(ArgumentType.TraditionalDpb, ArgumentType.Wide, ArgumentType.IntSpb, ArgumentType.ByteSpb);
    private static final long serialVersionUID = -1575745288263119101L;
    private final int value;

    public NumericArgument(int type, ArgumentType argumentType, int value) {
        super(type, argumentType);
        if (!SUPPORTED_ARGUMENT_TYPES.contains((Object)argumentType)) {
            throw new IllegalArgumentException("Invalid argument type: " + argumentType);
        }
        this.value = value;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.getType());
        this.writeValue(outputStream, this.value);
    }

    @Override
    public int getLength() {
        if (this.argumentType == ArgumentType.ByteSpb) {
            return 2;
        }
        return 5 + this.argumentType.getLengthSize();
    }

    private void writeValue(OutputStream outputStream, int value) throws IOException {
        if (this.argumentType == ArgumentType.ByteSpb) {
            outputStream.write(value);
        } else {
            this.argumentType.writeLength(4, outputStream);
            VaxEncoding.encodeVaxIntegerWithoutLength(outputStream, value);
        }
    }

    @Override
    public int getValueAsInt() {
        return this.value;
    }

    @Override
    public long getValueAsLong() {
        return this.value;
    }

    @Override
    public void copyTo(ParameterBuffer buffer, Encoding encoding) {
        buffer.addArgument(this.getType(), this.value);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NumericArgument)) {
            return false;
        }
        NumericArgument otherNumericArgument = (NumericArgument)other;
        return this.getType() == otherNumericArgument.getType() && this.value == otherNumericArgument.value;
    }

    public int hashCode() {
        int result = 23;
        result = 41 * result + this.getType();
        result = 41 * result + this.value;
        return result;
    }
}

