/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.EventHandle;
import org.firebirdsql.gds.EventHandler;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.ng.BlobConfig;
import org.firebirdsql.gds.ng.FbAttachment;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.OdsVersion;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;

public interface FbDatabase
extends FbAttachment {
    public void createDatabase() throws SQLException;

    public void dropDatabase() throws SQLException;

    public void cancelOperation(int var1) throws SQLException;

    public FbTransaction startTransaction(TransactionParameterBuffer var1) throws SQLException;

    public FbTransaction startTransaction(String var1) throws SQLException;

    public FbTransaction reconnectTransaction(long var1) throws SQLException;

    public FbStatement createStatement(FbTransaction var1) throws SQLException;

    public FbBlob createBlobForOutput(FbTransaction var1, BlobParameterBuffer var2);

    default public FbBlob createBlobForOutput(FbTransaction transaction) {
        return this.createBlobForOutput(transaction, (BlobParameterBuffer)null);
    }

    default public FbBlob createBlobForOutput(FbTransaction transaction, BlobConfig blobConfig) {
        BlobParameterBuffer blobParameterBuffer = this.createBlobParameterBuffer();
        blobConfig.writeOutputConfig(blobParameterBuffer);
        return this.createBlobForOutput(transaction, blobParameterBuffer);
    }

    public FbBlob createBlobForInput(FbTransaction var1, BlobParameterBuffer var2, long var3);

    default public FbBlob createBlobForInput(FbTransaction transaction, long blobId) {
        return this.createBlobForInput(transaction, (BlobParameterBuffer)null, blobId);
    }

    default public FbBlob createBlobForInput(FbTransaction transaction, BlobConfig blobConfig, long blobId) {
        BlobParameterBuffer blobParameterBuffer = this.createBlobParameterBuffer();
        blobConfig.writeInputConfig(blobParameterBuffer);
        return this.createBlobForInput(transaction, blobParameterBuffer, blobId);
    }

    public BlobParameterBuffer createBlobParameterBuffer();

    public TransactionParameterBuffer createTransactionParameterBuffer();

    public <T> T getDatabaseInfo(byte[] var1, int var2, InfoProcessor<T> var3) throws SQLException;

    public byte[] getDatabaseInfo(byte[] var1, int var2) throws SQLException;

    public void executeImmediate(String var1, FbTransaction var2) throws SQLException;

    public short getDatabaseDialect();

    public short getConnectionDialect();

    @Override
    public int getHandle();

    public int getOdsMajor();

    public int getOdsMinor();

    default public OdsVersion getOdsVersion() {
        return OdsVersion.of(this.getOdsMajor(), this.getOdsMinor());
    }

    public void addDatabaseListener(DatabaseListener var1);

    public void addWeakDatabaseListener(DatabaseListener var1);

    public void removeDatabaseListener(DatabaseListener var1);

    public EventHandle createEventHandle(String var1, EventHandler var2) throws SQLException;

    public void countEvents(EventHandle var1) throws SQLException;

    public void queueEvent(EventHandle var1) throws SQLException;

    public void cancelEvent(EventHandle var1) throws SQLException;

    public IConnectionProperties getConnectionProperties();

    public RowDescriptor emptyRowDescriptor();
}

