/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version16;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.BatchCompletion;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.wire.BatchCompletionResponse;
import org.firebirdsql.gds.ng.wire.WireConnection;
import org.firebirdsql.gds.ng.wire.version15.V15WireOperations;

public class V16WireOperations
extends V15WireOperations {
    protected static final int BATCH_LIMIT = 64;

    public V16WireOperations(WireConnection<?, ?> connection, WarningMessageCallback defaultWarningMessageCallback) {
        super(connection, defaultWarningMessageCallback);
    }

    @Override
    protected void afterEnqueueDeferredAction() throws SQLException {
        if (this.deferredActionCount() < 64) {
            return;
        }
        this.completeDeferredActions();
    }

    @Override
    public void completeDeferredActions() throws SQLException {
        block11: {
            try (LockCloseable ignored = this.withLock();){
                if (this.completeDeferredActionsRequiresSync()) {
                    try {
                        XdrOutputStream xdrOut = this.getXdrOut();
                        xdrOut.writeInt(this.getBatchSyncOperation());
                        xdrOut.flush();
                    }
                    catch (IOException e) {
                        throw FbExceptionBuilder.ioWriteError(e);
                    }
                    try {
                        this.readResponse(null);
                        break block11;
                    }
                    catch (IOException e) {
                        throw FbExceptionBuilder.ioReadError(e);
                    }
                }
                this.processDeferredActions();
            }
        }
    }

    protected int getBatchSyncOperation() {
        return 93;
    }

    @Override
    protected void afterProcessDeferredActions(int processedDeferredActions) {
        super.afterProcessDeferredActions(processedDeferredActions < 64 ? processedDeferredActions : -1);
    }

    @Override
    protected BatchCompletionResponse readBatchCompletionResponse(XdrInputStream xdrIn) throws SQLException, IOException {
        xdrIn.skipNBytes(4L);
        int elementCount = xdrIn.readInt();
        int updateCountsCount = xdrIn.readInt();
        int detailedErrorsCount = xdrIn.readInt();
        int simplifiedErrorsCount = xdrIn.readInt();
        int[] updateCounts = new int[updateCountsCount];
        for (int row = 0; row < updateCountsCount; ++row) {
            updateCounts[row] = xdrIn.readInt();
        }
        ArrayList<BatchCompletion.DetailedError> detailedErrors = new ArrayList<BatchCompletion.DetailedError>(detailedErrorsCount);
        for (int i = 0; i < detailedErrorsCount; ++i) {
            int element = xdrIn.readInt();
            SQLException error = this.readStatusVector(xdrIn);
            detailedErrors.add(new BatchCompletion.DetailedError(element, error));
        }
        int[] simplifiedErrors = new int[simplifiedErrorsCount];
        for (int i = 0; i < simplifiedErrorsCount; ++i) {
            simplifiedErrors[i] = xdrIn.readInt();
        }
        return new BatchCompletionResponse(new BatchCompletion(elementCount, updateCounts, detailedErrors, simplifiedErrors));
    }
}

