/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.parser;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.firebirdsql.jaybird.parser.CharSequenceComparison;
import org.firebirdsql.jaybird.parser.FirebirdReservedWords;
import org.firebirdsql.jaybird.parser.GenericToken;
import org.firebirdsql.jaybird.parser.LocalStatementType;
import org.firebirdsql.jaybird.parser.OperatorToken;
import org.firebirdsql.jaybird.parser.ReservedToken;
import org.firebirdsql.jaybird.parser.ReturningClauseDetector;
import org.firebirdsql.jaybird.parser.SqlParser;
import org.firebirdsql.jaybird.parser.StatementIdentification;
import org.firebirdsql.jaybird.parser.Token;
import org.firebirdsql.jaybird.parser.TokenVisitor;
import org.firebirdsql.jaybird.parser.VisitorRegistrar;

public final class StatementDetector
implements TokenVisitor {
    private static final StateAfterStart INITIAL_OTHER = new StateAfterStart(ParserState.OTHER, LocalStatementType.OTHER);
    private static final Map<CharSequence, StateAfterStart> NEXT_AFTER_START;
    private final boolean detectReturning;
    private LocalStatementType statementType = LocalStatementType.UNKNOWN;
    private ParserState parserState = ParserState.START;
    private Token tableNameToken;
    private ReturningClauseDetector returningClauseDetector;

    public StatementDetector() {
        this(true);
    }

    public StatementDetector(boolean detectReturning) {
        this.detectReturning = detectReturning;
    }

    public static LocalStatementType determineLocalStatementType(String sql) {
        StatementDetector detector = new StatementDetector(false);
        SqlParser.withReservedWords(FirebirdReservedWords.latest()).withVisitor(detector).of(sql).parse();
        return detector.getStatementType();
    }

    @Override
    public void visitToken(Token token, VisitorRegistrar visitorRegistrar) {
        if (token.isWhitespaceOrComment()) {
            return;
        }
        this.parserState = this.parserState.next(token, this);
        if (this.parserState.isFinalState()) {
            visitorRegistrar.removeVisitor(this);
        } else if (this.parserState == ParserState.FIND_RETURNING) {
            visitorRegistrar.removeVisitor(this);
            if (this.detectReturning) {
                this.returningClauseDetector = new ReturningClauseDetector();
                visitorRegistrar.addVisitor(this.returningClauseDetector);
                this.returningClauseDetector.visitToken(token, visitorRegistrar);
            }
        }
    }

    @Override
    public void complete(VisitorRegistrar visitorRegistrar) {
    }

    public StatementIdentification toStatementIdentification() {
        return new StatementIdentification(this.statementType, this.tableNameToken != null ? this.tableNameToken.text() : null, this.returningClauseDetected());
    }

    boolean returningClauseDetected() {
        return this.returningClauseDetector != null && this.returningClauseDetector.returningClauseDetected();
    }

    public LocalStatementType getStatementType() {
        return this.statementType;
    }

    Token getTableNameToken() {
        return this.tableNameToken;
    }

    private void updateStatementType(LocalStatementType statementType) {
        this.statementType = statementType;
        if (statementType == LocalStatementType.OTHER) {
            this.setTableNameToken(null);
        }
    }

    private void setTableNameToken(Token tableNameToken) {
        this.tableNameToken = tableNameToken;
    }

    static {
        TreeMap<CharSequence, StateAfterStart> nextAfterStart = new TreeMap<CharSequence, StateAfterStart>(CharSequenceComparison.caseInsensitiveComparator());
        StateAfterStart selectState = new StateAfterStart(ParserState.SELECT, LocalStatementType.SELECT);
        nextAfterStart.put("SELECT", selectState);
        nextAfterStart.put("WITH", selectState);
        nextAfterStart.put("EXECUTE", new StateAfterStart(ParserState.EXECUTE, LocalStatementType.OTHER));
        nextAfterStart.put("UPDATE", new StateAfterStart(ParserState.UPDATE, LocalStatementType.UPDATE));
        nextAfterStart.put("DELETE", new StateAfterStart(ParserState.DELETE, LocalStatementType.DELETE));
        nextAfterStart.put("INSERT", new StateAfterStart(ParserState.INSERT, LocalStatementType.INSERT));
        nextAfterStart.put("MERGE", new StateAfterStart(ParserState.MERGE, LocalStatementType.MERGE));
        nextAfterStart.put("COMMIT", new StateAfterStart(ParserState.COMMIT_ROLLBACK, LocalStatementType.HARD_COMMIT));
        nextAfterStart.put("ROLLBACK", new StateAfterStart(ParserState.COMMIT_ROLLBACK, LocalStatementType.HARD_ROLLBACK));
        nextAfterStart.put("SET", new StateAfterStart(ParserState.SET, LocalStatementType.OTHER));
        NEXT_AFTER_START = Collections.unmodifiableMap(nextAfterStart);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum ParserState {
        START{

            @Override
            ParserState next(Token token, StatementDetector detector) {
                if (!(token instanceof ReservedToken)) {
                    return ParserState.forceOther(detector);
                }
                StateAfterStart stateAfterStart = NEXT_AFTER_START.getOrDefault(token.textAsCharSequence(), INITIAL_OTHER);
                detector.updateStatementType(stateAfterStart.type);
                return stateAfterStart.state;
            }
        }
        ,
        SELECT(true),
        EXECUTE{

            @Override
            ParserState next(Token token, StatementDetector detector) {
                if (token instanceof ReservedToken && token.equalsIgnoreCase("PROCEDURE")) {
                    detector.updateStatementType(LocalStatementType.EXECUTE_PROCEDURE);
                    return EXECUTE_PROCEDURE;
                }
                return ParserState.forceOther(detector);
            }
        }
        ,
        EXECUTE_PROCEDURE(true),
        UPDATE{

            @Override
            ParserState next(Token token, StatementDetector detector) {
                if (token instanceof OperatorToken && token.equalsIgnoreCase("OR")) {
                    detector.updateStatementType(LocalStatementType.UNKNOWN);
                    return POSSIBLY_UPDATE_OR_INSERT;
                }
                return DML_TARGET.next(token, detector);
            }
        }
        ,
        POSSIBLY_UPDATE_OR_INSERT{

            @Override
            ParserState next(Token token, StatementDetector detector) {
                if (token instanceof ReservedToken && token.equalsIgnoreCase("INSERT")) {
                    detector.updateStatementType(LocalStatementType.UPDATE_OR_INSERT);
                    return INSERT;
                }
                return ParserState.forceOther(detector);
            }
        }
        ,
        DELETE{

            @Override
            ParserState next(Token token, StatementDetector detector) {
                if (!(token instanceof ReservedToken) || !token.equalsIgnoreCase("FROM")) {
                    return ParserState.forceOther(detector);
                }
                return DML_TARGET;
            }
        }
        ,
        DML_TARGET{

            @Override
            ParserState next(Token token, StatementDetector detector) {
                if (token.isValidIdentifier()) {
                    detector.setTableNameToken(token);
                    return DML_POSSIBLE_ALIAS;
                }
                return ParserState.forceOther(detector);
            }
        }
        ,
        DML_POSSIBLE_ALIAS{

            @Override
            ParserState next(Token token, StatementDetector detector) {
                if (token.isValidIdentifier()) {
                    return FIND_RETURNING;
                }
                if (token instanceof ReservedToken) {
                    if (token.equalsIgnoreCase("AS")) {
                        return DML_ALIAS;
                    }
                    return FIND_RETURNING;
                }
                return ParserState.forceOther(detector);
            }
        }
        ,
        DML_ALIAS{

            @Override
            ParserState next(Token token, StatementDetector detector) {
                if (token.isValidIdentifier()) {
                    return FIND_RETURNING;
                }
                return ParserState.forceOther(detector);
            }
        }
        ,
        INSERT{

            @Override
            ParserState next(Token token, StatementDetector detector) {
                if (token instanceof ReservedToken && token.equalsIgnoreCase("INTO")) {
                    return INSERT_INTO;
                }
                return ParserState.forceOther(detector);
            }
        }
        ,
        INSERT_INTO{

            @Override
            ParserState next(Token token, StatementDetector detector) {
                if (token.isValidIdentifier()) {
                    detector.setTableNameToken(token);
                    return FIND_RETURNING;
                }
                return ParserState.forceOther(detector);
            }
        }
        ,
        MERGE{

            @Override
            ParserState next(Token token, StatementDetector detector) {
                if (token instanceof ReservedToken && token.equalsIgnoreCase("INTO")) {
                    return DML_TARGET;
                }
                return ParserState.forceOther(detector);
            }
        }
        ,
        FIND_RETURNING,
        COMMIT_ROLLBACK{

            @Override
            ParserState next(Token token, StatementDetector detector) {
                if (token instanceof GenericToken && token.equalsIgnoreCase("WORK")) {
                    return COMMIT_ROLLBACK_WORK;
                }
                return ParserState.forceOther(detector);
            }
        }
        ,
        COMMIT_ROLLBACK_WORK{

            @Override
            ParserState next(Token token, StatementDetector detector) {
                return ParserState.forceOther(detector);
            }
        }
        ,
        SET{

            @Override
            ParserState next(Token token, StatementDetector detector) {
                if (token instanceof GenericToken && token.equalsIgnoreCase("TRANSACTION")) {
                    detector.updateStatementType(LocalStatementType.SET_TRANSACTION);
                    return SET_TRANSACTION;
                }
                return ParserState.forceOther(detector);
            }
        }
        ,
        SET_TRANSACTION(true),
        OTHER(true);

        private final boolean finalState;

        private ParserState() {
            this(false);
        }

        private ParserState(boolean finalState) {
            this.finalState = finalState;
        }

        final boolean isFinalState() {
            return this.finalState;
        }

        ParserState next(Token token, StatementDetector detector) {
            throw new IllegalStateException("State " + this + " is a terminal state and next(..) should not be invoked");
        }

        private static ParserState forceOther(StatementDetector detector) {
            detector.updateStatementType(LocalStatementType.OTHER);
            return OTHER;
        }
    }

    private record StateAfterStart(ParserState state, LocalStatementType type) {
    }
}

