/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.util;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.JulianFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import org.jspecify.annotations.Nullable;

public final class FbDatetimeConversion {
    public static final TemporalUnit FB_TIME_UNIT = new FbTimeUnit();
    public static final TemporalField FB_TIME_FIELD = new FbTimeField();
    public static final long MICROS_PER_UNIT = 100L;
    public static final long NANOS_PER_UNIT = 100000L;
    private static final DateTimeFormatter SQL_DATE_PARSE = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).toFormatter().withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    private static final DateTimeFormatter SQL_TIMESTAMP_PARSE = new DateTimeFormatterBuilder().append(SQL_DATE_PARSE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter().withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    private static final DateTimeFormatter SQL_TIMESTAMP_FORMAT = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter().withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);

    private FbDatetimeConversion() {
    }

    public static int toModifiedJulianDate(LocalDate localDate) {
        long mjd = localDate.getLong(JulianFields.MODIFIED_JULIAN_DAY);
        return Math.toIntExact(mjd);
    }

    public static LocalDate fromModifiedJulianDate(int mjd) {
        return FbDatetimeConversion.updateModifiedJulianDate(LocalDate.EPOCH, mjd);
    }

    public static <R extends Temporal> R updateModifiedJulianDate(R datetime, int mjd) {
        return JulianFields.MODIFIED_JULIAN_DAY.adjustInto(datetime, mjd);
    }

    public static int toFbTimeUnits(LocalTime localTime) {
        return localTime.get(FB_TIME_FIELD);
    }

    public static LocalTime fromFbTimeUnits(int timeUnits) {
        return FbDatetimeConversion.updateFbTimeUnits(LocalTime.MIN, timeUnits);
    }

    public static <R extends Temporal> R updateFbTimeUnits(R datetime, int timeUnits) {
        return FB_TIME_FIELD.adjustInto(datetime, timeUnits);
    }

    public static @Nullable LocalDateTime parseIsoOrSqlTimestamp(@Nullable String datetimeString) {
        if (datetimeString == null) {
            return null;
        }
        if (datetimeString.length() >= 16 && (datetimeString.charAt(10) == 'T' || datetimeString.charAt(10) == 't')) {
            return LocalDateTime.parse(datetimeString);
        }
        return FbDatetimeConversion.parseSqlTimestamp(datetimeString);
    }

    public static @Nullable LocalDateTime parseSqlTimestamp(@Nullable String datetimeString) {
        return datetimeString != null ? LocalDateTime.parse(datetimeString, SQL_TIMESTAMP_PARSE) : null;
    }

    public static @Nullable String formatSqlTimestamp(@Nullable LocalDateTime localDateTime) {
        return localDateTime != null ? localDateTime.format(SQL_TIMESTAMP_FORMAT) : null;
    }

    public static @Nullable LocalTime parseSqlTime(@Nullable String timeString) {
        return timeString != null ? LocalTime.parse(timeString) : null;
    }

    public static @Nullable String formatSqlTime(@Nullable LocalTime localTime) {
        return localTime != null ? localTime.format(DateTimeFormatter.ISO_LOCAL_TIME) : null;
    }

    public static @Nullable LocalDate parseSqlDate(@Nullable String dateString) {
        return dateString != null ? LocalDate.parse(dateString, SQL_DATE_PARSE) : null;
    }

    public static @Nullable String formatSqlDate(@Nullable LocalDate localDate) {
        return localDate != null ? localDate.toString() : null;
    }

    private static final class FbTimeUnit
    implements TemporalUnit {
        private static final Duration UNIT_DURATION = Duration.ofNanos(100000L);

        private FbTimeUnit() {
        }

        @Override
        public Duration getDuration() {
            return UNIT_DURATION;
        }

        @Override
        public boolean isDurationEstimated() {
            return false;
        }

        @Override
        public boolean isDateBased() {
            return false;
        }

        @Override
        public boolean isTimeBased() {
            return true;
        }

        @Override
        public <R extends Temporal> R addTo(R temporal, long amount) {
            return (R)temporal.plus(Math.multiplyExact(amount, 100L), ChronoUnit.MICROS);
        }

        @Override
        public long between(Temporal temporal1Inclusive, Temporal temporal2Exclusive) {
            return temporal1Inclusive.until(temporal2Exclusive, ChronoUnit.MICROS) / 100L;
        }

        @Override
        public String toString() {
            return "FbTimeUnit";
        }

        public boolean equals(Object obj) {
            return obj instanceof FbTimeUnit;
        }

        public int hashCode() {
            return FbTimeUnit.class.hashCode();
        }
    }

    private static final class FbTimeField
    implements TemporalField {
        private static final ValueRange RANGE = ValueRange.of(0L, 863999999L);

        private FbTimeField() {
        }

        @Override
        public TemporalUnit getBaseUnit() {
            return FB_TIME_UNIT;
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return ChronoUnit.DAYS;
        }

        @Override
        public ValueRange range() {
            return RANGE;
        }

        @Override
        public boolean isDateBased() {
            return false;
        }

        @Override
        public boolean isTimeBased() {
            return true;
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.NANO_OF_DAY);
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            if (!this.isSupportedBy(temporal)) {
                throw new DateTimeException("Unsupported field: " + this);
            }
            return this.range();
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            return temporal.getLong(ChronoField.NANO_OF_DAY) / 100000L;
        }

        @Override
        public <R extends Temporal> R adjustInto(R temporal, long newValue) {
            return (R)temporal.with(ChronoField.NANO_OF_DAY, RANGE.checkValidValue(newValue, this) * 100000L);
        }

        @Override
        public String toString() {
            return "FbTimeField";
        }

        public boolean equals(Object obj) {
            return obj instanceof FbTimeField;
        }

        public int hashCode() {
            return FbTimeField.class.hashCode();
        }
    }
}

