/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;

public final class IOUtils {
    private IOUtils() {
    }

    public static byte[] toBytes(InputStream in, int length) throws IOException {
        int counter;
        if (length == -1) {
            return IOUtils.toBytes(in);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buff = new byte[Math.min(4096, length)];
        for (int toRead = length; toRead > 0 && (counter = in.read(buff, 0, Math.min(toRead, buff.length))) != -1; toRead -= counter) {
            out.write(buff, 0, counter);
        }
        return out.toByteArray();
    }

    public static byte[] toBytes(InputStream in) throws IOException {
        int counter;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        while ((counter = in.read(buff, 0, buff.length)) != -1) {
            out.write(buff, 0, counter);
        }
        return out.toByteArray();
    }

    public static String toString(Reader in, int length) throws IOException {
        int counter;
        if (length == -1) {
            return IOUtils.toString(in);
        }
        StringWriter out = new StringWriter();
        char[] buff = new char[Math.min(4096, length)];
        for (int toRead = length; toRead > 0 && (counter = in.read(buff, 0, Math.min(toRead, buff.length))) != -1; toRead -= counter) {
            out.write(buff, 0, counter);
        }
        return out.toString();
    }

    public static String toString(Reader in) throws IOException {
        int counter;
        StringWriter out = new StringWriter();
        char[] buff = new char[4096];
        while ((counter = in.read(buff, 0, buff.length)) != -1) {
            out.write(buff, 0, counter);
        }
        return out.toString();
    }
}

