/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;

public final class LegacyDatetimeConversions {
    private LegacyDatetimeConversions() {
    }

    public static LocalDateTime toLocalDateTime(Timestamp val, @Nullable Calendar c) {
        if (c == null || Objects.equals(c.getTimeZone(), TimeZone.getDefault())) {
            return val.toLocalDateTime();
        }
        c.setTime(val);
        return LegacyDatetimeConversions.toLocalDateTime(c, val.getNanos());
    }

    public static Timestamp toTimestamp(LocalDateTime val, @Nullable Calendar c) {
        if (c == null || Objects.equals(c.getTimeZone(), TimeZone.getDefault())) {
            return Timestamp.valueOf(val);
        }
        LegacyDatetimeConversions.updateCalendar(c, val);
        Timestamp timestamp = new Timestamp(c.getTimeInMillis());
        timestamp.setNanos(val.getNano());
        return timestamp;
    }

    public static LocalTime toLocalTime(Time val, @Nullable Calendar c) {
        if (c == null || Objects.equals(c.getTimeZone(), TimeZone.getDefault())) {
            return val.toLocalTime();
        }
        c.setTime(val);
        return LegacyDatetimeConversions.toLocalTime(c, 0);
    }

    public static Time toTime(LocalTime val, @Nullable Calendar c) {
        if (c == null || Objects.equals(c.getTimeZone(), TimeZone.getDefault())) {
            return Time.valueOf(val);
        }
        LegacyDatetimeConversions.updateCalendar(c, LocalDate.EPOCH, val);
        return new Time(c.getTimeInMillis());
    }

    public static LocalDate toLocalDate(Date val, @Nullable Calendar c) {
        if (c == null || Objects.equals(c.getTimeZone(), TimeZone.getDefault())) {
            return val.toLocalDate();
        }
        c.setTime(val);
        return LegacyDatetimeConversions.toLocalDate(c);
    }

    public static Date toDate(LocalDate val, @Nullable Calendar c) {
        if (c == null || Objects.equals(c.getTimeZone(), TimeZone.getDefault())) {
            return Date.valueOf(val);
        }
        LegacyDatetimeConversions.updateCalendar(c, val, LocalTime.MIDNIGHT);
        return new Date(c.getTimeInMillis());
    }

    private static LocalDateTime toLocalDateTime(Calendar c, int nanoOfSecond) {
        return LocalDateTime.of(LegacyDatetimeConversions.toLocalDate(c), LegacyDatetimeConversions.toLocalTime(c, nanoOfSecond));
    }

    private static LocalDate toLocalDate(Calendar c) {
        return LocalDate.of(c.get(1), c.get(2) + 1, c.get(5));
    }

    private static LocalTime toLocalTime(Calendar c, int nanoOfSecond) {
        if (nanoOfSecond == -1) {
            nanoOfSecond = (int)TimeUnit.MILLISECONDS.toNanos(c.get(14));
        }
        return LocalTime.of(c.get(11), c.get(12), c.get(13), nanoOfSecond);
    }

    private static void updateCalendar(Calendar c, LocalDateTime localDateTime) {
        LegacyDatetimeConversions.updateCalendar(c, localDateTime.toLocalDate(), localDateTime.toLocalTime());
    }

    private static void updateCalendar(Calendar c, LocalDate localDate, LocalTime localTime) {
        LegacyDatetimeConversions.updateCalendar(c, localDate);
        LegacyDatetimeConversions.updateCalendar(c, localTime);
    }

    private static void updateCalendar(Calendar c, LocalDate localDate) {
        c.set(localDate.getYear(), localDate.getMonthValue() - 1, localDate.getDayOfMonth());
    }

    private static void updateCalendar(Calendar c, LocalTime localTime) {
        c.set(11, localTime.getHour());
        c.set(12, localTime.getMinute());
        c.set(13, localTime.getSecond());
        c.set(14, (int)TimeUnit.NANOSECONDS.toMillis(localTime.getNano()));
    }
}

