/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.xca;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.firebirdsql.jaybird.xca.FBIncorrectXidException;

final class FBXid
implements Xid {
    private static final int TDR_VERSION = 1;
    private static final int TDR_XID_FORMAT_ID = 5;
    private static final int TDR_XID_GLOBAL_ID = 6;
    private static final int TDR_XID_BRANCH_ID = 4;
    private final int formatId;
    private final byte[] globalId;
    private final byte[] branchId;
    private final long firebirdTransactionId;

    static String toString(Xid id) {
        if (id == null) {
            return "[NULL Xid]";
        }
        Object s = id.getClass().getName();
        s = ((String)s).substring(((String)s).lastIndexOf(46) + 1);
        s = (String)s + " [FormatId=" + id.getFormatId() + ", GlobalId=" + new String(id.getGlobalTransactionId()).trim() + ", BranchQual=" + new String(id.getBranchQualifier()).trim() + "]";
        return s;
    }

    FBXid(long firebirdTransactionId, int formatId, byte[] globalId, byte[] branchId) {
        this.firebirdTransactionId = firebirdTransactionId;
        this.formatId = formatId;
        this.globalId = globalId;
        this.branchId = branchId;
    }

    FBXid(Xid xid) {
        this(0L, xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    FBXid(byte[] rawIn, long firebirdTransactionId) throws FBIncorrectXidException {
        this.firebirdTransactionId = firebirdTransactionId;
        ByteBuffer buffer = ByteBuffer.wrap(rawIn);
        try {
            if (buffer.get() != 1) {
                throw new FBIncorrectXidException("Wrong TDR_VERSION for xid");
            }
            if (buffer.get() != 5) {
                throw new FBIncorrectXidException("Wrong TDR_XID_FORMAT_ID for xid");
            }
            this.formatId = buffer.getInt();
            if (buffer.get() != 6) {
                throw new FBIncorrectXidException("Wrong TDR_XID_GLOBAL_ID for xid");
            }
            this.globalId = this.readBuffer(buffer);
            if (buffer.get() != 4) {
                throw new FBIncorrectXidException("Wrong TDR_XID_BRANCH_ID for xid");
            }
            this.branchId = this.readBuffer(buffer);
        }
        catch (BufferUnderflowException e) {
            throw new FBIncorrectXidException("Unexpected format or incomplete serialized xid", e);
        }
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return (byte[])this.globalId.clone();
    }

    @Override
    public byte[] getBranchQualifier() {
        return (byte[])this.branchId.clone();
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    public long getFirebirdTransactionId() {
        return this.firebirdTransactionId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Xid)) {
            return false;
        }
        Xid other = (Xid)obj;
        boolean result = this.formatId == other.getFormatId();
        byte[] otherGlobalID = other.getGlobalTransactionId();
        byte[] otherBranchID = other.getBranchQualifier();
        result &= Arrays.equals(this.globalId, otherGlobalID);
        return result &= Arrays.equals(this.branchId, otherBranchID);
    }

    public int hashCode() {
        int hashCode = 1109;
        hashCode = 43 * hashCode + this.formatId;
        hashCode = 43 * hashCode + Arrays.hashCode(this.globalId);
        hashCode = 43 * hashCode + Arrays.hashCode(this.branchId);
        return hashCode;
    }

    public String toString() {
        return FBXid.toString(this);
    }

    byte[] toBytes() {
        byte[] b = new byte[11 + this.globalId.length + 1 + 4 + this.branchId.length];
        ByteBuffer.wrap(b).put((byte)1).put((byte)5).putInt(this.formatId).put((byte)6).putInt(this.globalId.length).put(this.globalId).put((byte)4).putInt(this.branchId.length).put(this.branchId);
        return b;
    }

    private byte[] readBuffer(ByteBuffer buffer) {
        byte[] content = new byte[buffer.getInt()];
        buffer.get(content);
        return content;
    }
}

