/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.ClientInfoStatus;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.jdbc.InternalTransactionCoordinator;
import org.firebirdsql.jdbc.QuoteStrategy;
import org.firebirdsql.jdbc.ResultSetBehavior;
import org.firebirdsql.util.FirebirdSupportInfo;

final class ClientInfoProvider {
    private static final String USER_SESSION = "USER_SESSION";
    private static final String USER_TRANSACTION = "USER_TRANSACTION";
    private static final String SYSTEM = "SYSTEM";
    private static final Set<String> SUPPORTED_CONTEXTS = Set.of("USER_SESSION", "USER_TRANSACTION", "SYSTEM");
    private static final String APPLICATION_NAME = "ApplicationName";
    private static final ClientInfoProperty APPLICATION_NAME_PROP = new ClientInfoProperty("ApplicationName", "USER_SESSION");
    private static final ClientInfoProperty APPLICATION_NAME_FALLBACK_PROP = new ClientInfoProperty("CLIENT_PROCESS", "SYSTEM");
    private static final Set<ClientInfoProperty> DEFAULT_CLIENT_INFO_PROPERTIES = Set.of(APPLICATION_NAME_PROP, new ClientInfoProperty("ClientUser", "USER_SESSION"), new ClientInfoProperty("ClientHostname", "USER_SESSION"));
    private static final Set<String> DEFAULT_CLIENT_INFO_PROPERTY_NAMES = DEFAULT_CLIENT_INFO_PROPERTIES.stream().map(Object::toString).collect(Collectors.toUnmodifiableSet());
    private final FBConnection connection;
    private Set<ClientInfoProperty> knownProperties;
    private Statement statement;

    ClientInfoProvider(FBConnection connection) throws SQLException {
        connection.checkValidity();
        if (!FirebirdSupportInfo.supportInfoFor(connection).supportsGetSetContext()) {
            throw new FBDriverNotCapableException("Required functionality (RDB$SET_CONTEXT()) only available in Firebird 2.0 or higher");
        }
        this.connection = connection;
    }

    private Statement getStatement() throws SQLException {
        Statement statement = this.statement;
        if (statement != null && !statement.isClosed()) {
            return statement;
        }
        InternalTransactionCoordinator.MetaDataTransactionCoordinator metaDataTransactionCoordinator = new InternalTransactionCoordinator.MetaDataTransactionCoordinator(this.connection.txCoordinator);
        ResultSetBehavior rsBehavior = ResultSetBehavior.of(1004, 1007, 2);
        this.statement = new FBStatement(this.connection, rsBehavior, metaDataTransactionCoordinator);
        return this.statement;
    }

    void resetKnownProperties() {
        this.knownProperties = null;
    }

    Set<ClientInfoProperty> getKnownProperties() {
        return this.knownProperties != null ? this.knownProperties : DEFAULT_CLIENT_INFO_PROPERTIES;
    }

    private Set<ClientInfoProperty> getOrCreateKnownProperties() {
        Set<ClientInfoProperty> knownProperties = this.knownProperties;
        if (knownProperties != null) {
            return knownProperties;
        }
        this.knownProperties = new HashSet<ClientInfoProperty>(DEFAULT_CLIENT_INFO_PROPERTIES);
        return this.knownProperties;
    }

    void registerKnownProperty(ClientInfoProperty property) {
        if (DEFAULT_CLIENT_INFO_PROPERTIES.contains(property)) {
            return;
        }
        this.getOrCreateKnownProperties().add(property);
    }

    void registerKnownProperties(Collection<ClientInfoProperty> properties) {
        if (DEFAULT_CLIENT_INFO_PROPERTIES.containsAll(properties)) {
            return;
        }
        this.getOrCreateKnownProperties().addAll(properties);
    }

    Collection<String> getDefaultClientInfoPropertyNames() {
        return DEFAULT_CLIENT_INFO_PROPERTY_NAMES;
    }

    Collection<ClientInfoProperty> getDefaultClientInfoProperties() {
        return DEFAULT_CLIENT_INFO_PROPERTIES;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getClientInfo(String name) throws SQLException {
        ClientInfoProperty property;
        try {
            property = ClientInfoProperty.parse(name);
        }
        catch (RuntimeException e) {
            throw FbExceptionBuilder.forNonTransientException(337248342).messageParameter((Object)name).cause(e).toSQLException();
        }
        if (USER_TRANSACTION.equals(property.context) && this.connection.getAutoCommit()) {
            return null;
        }
        QuoteStrategy quoteStrategy = this.connection.getQuoteStrategy();
        StringBuilder sb = new StringBuilder("select ");
        this.renderGetValue(sb, property, quoteStrategy);
        sb.append(" from RDB$DATABASE");
        try (ResultSet rs = this.getStatement().executeQuery(sb.toString());){
            if (rs.next()) {
                this.registerKnownProperty(property);
                String string2 = rs.getString(1);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (SQLException e) {
            if (e.getErrorCode() != 335544843) throw e;
            return null;
        }
    }

    private void renderGetValue(StringBuilder sb, ClientInfoProperty property, QuoteStrategy quoteStrategy) {
        if (APPLICATION_NAME_PROP.equals(property) && FirebirdSupportInfo.supportInfoFor(this.connection).isVersionEqualOrAbove(2, 5, 3)) {
            sb.append("coalesce(");
            property.appendAsGetContext(sb, quoteStrategy).append(',');
            APPLICATION_NAME_FALLBACK_PROP.appendAsGetContext(sb, quoteStrategy).append(')');
        } else {
            property.appendAsGetContext(sb, quoteStrategy);
        }
    }

    public Properties getClientInfo() throws SQLException {
        boolean autoCommit = this.connection.getAutoCommit();
        QuoteStrategy quoteStrategy = this.connection.getQuoteStrategy();
        StringBuilder sb = new StringBuilder("execute block returns (\n  CONTEXT_NAME varchar(20) character set ASCII,\n  CONTEXT_VAR_NAME varchar(80) character set NONE,\n  CONTEXT_VAR_VALUE varchar(32765) character set NONE)\nas\nbegin\n");
        for (ClientInfoProperty property : this.getKnownProperties()) {
            if (autoCommit && USER_TRANSACTION.equals(property.context)) continue;
            sb.append("CONTEXT_NAME=");
            quoteStrategy.appendLiteral(property.context, sb).append(";\n");
            sb.append("CONTEXT_VAR_NAME=");
            quoteStrategy.appendLiteral(property.name, sb).append(";\n");
            boolean systemContext = SYSTEM.equals(property.context);
            if (systemContext) {
                sb.append("begin\n");
            }
            sb.append("CONTEXT_VAR_VALUE=");
            this.renderGetValue(sb, property, quoteStrategy);
            sb.append(";\n");
            if (systemContext) {
                sb.append("when gdscode ctx_var_not_found do CONTEXT_VAR_VALUE = null;\nend\n");
            }
            sb.append("suspend;\n");
        }
        sb.append("end");
        try (ResultSet rs = this.getStatement().executeQuery(sb.toString());){
            Properties properties = new Properties();
            while (rs.next()) {
                ClientInfoProperty property = new ClientInfoProperty(rs.getString("CONTEXT_VAR_NAME"), rs.getString("CONTEXT_NAME"));
                String value = rs.getString("CONTEXT_VAR_VALUE");
                if (value == null) continue;
                properties.setProperty(property.toString(), value);
            }
            Properties properties2 = properties;
            return properties2;
        }
    }

    public void setClientInfo(String name, String value) throws SQLException {
        ClientInfoProperty property;
        try {
            property = ClientInfoProperty.parse(name);
        }
        catch (RuntimeException e) {
            SQLException forMessage = FbExceptionBuilder.forException(337248342).messageParameter((Object)name).toSQLException();
            throw new SQLClientInfoException(forMessage.getMessage(), forMessage.getSQLState(), forMessage.getErrorCode(), Map.of(Objects.requireNonNullElse(name, "<null>"), ClientInfoStatus.REASON_UNKNOWN), e);
        }
        if (SYSTEM.equals(property.context)) {
            SQLException forMessage = FbExceptionBuilder.forException(337248343).messageParameter((Object)name).toSQLException();
            throw new SQLClientInfoException(forMessage.getMessage(), forMessage.getSQLState(), forMessage.getErrorCode(), Map.of(name, ClientInfoStatus.REASON_UNKNOWN));
        }
        if (USER_TRANSACTION.equals(property.context) && this.connection.getAutoCommit()) {
            return;
        }
        this.executeSetClientInfo(Map.of(property, value));
    }

    public void setClientInfo(Properties properties) throws SQLException {
        boolean autoCommit = this.connection.getAutoCommit();
        Predicate<ClientInfoProperty> includePropertyPredicate = property -> USER_SESSION.equals(property.context) || !autoCommit && USER_TRANSACTION.equals(property.context);
        HashMap<ClientInfoProperty, String> propertyValues = new HashMap<ClientInfoProperty, String>();
        this.getKnownProperties().stream().filter(includePropertyPredicate).forEach(property -> propertyValues.put((ClientInfoProperty)property, (String)null));
        Predicate<ClientInfoProperty> excludePropertyPredicate = includePropertyPredicate.negate();
        for (String propertyName : properties.stringPropertyNames()) {
            ClientInfoProperty property2 = ClientInfoProperty.parse(propertyName);
            if (excludePropertyPredicate.test(property2)) continue;
            propertyValues.put(property2, properties.getProperty(propertyName));
        }
        this.executeSetClientInfo(propertyValues);
    }

    private void executeSetClientInfo(Map<ClientInfoProperty, String> propertyValues) throws SQLException {
        QuoteStrategy quoteStrategy = this.connection.getQuoteStrategy();
        StringBuilder sb = new StringBuilder("execute block\nas\nbegin\n");
        propertyValues.forEach((property, value) -> property.appendAsSetContext(sb, quoteStrategy, (String)value).append(";\n"));
        sb.append("end");
        this.getStatement().execute(sb.toString());
        this.registerKnownProperties(propertyValues.keySet());
    }

    record ClientInfoProperty(String name, String context) {
        static final Pattern PROPERTY_PATTERN = Pattern.compile("^(.*?)@(USER_(?:SESSION|TRANSACTION)|SYSTEM)$", 32);

        ClientInfoProperty {
            if (PROPERTY_PATTERN.matcher(Objects.requireNonNull(name, "name")).matches()) {
                throw new IllegalArgumentException("Name '%s' should not end in @ followed by %s".formatted(name, SUPPORTED_CONTEXTS));
            }
            if (!SUPPORTED_CONTEXTS.contains(Objects.requireNonNull(context, "context"))) {
                throw new IllegalArgumentException("Unknown context '%s', expected one of %s".formatted(context, SUPPORTED_CONTEXTS));
            }
        }

        static ClientInfoProperty parse(String name) {
            Matcher matcher = PROPERTY_PATTERN.matcher(name);
            if (matcher.matches()) {
                String propertyName = matcher.group(1);
                String context = matcher.group(2);
                if (matcher.reset(propertyName).matches()) {
                    throw new IllegalArgumentException("Name '%s' should not end in multiple occurrences of @ followed by %s".formatted(name, SUPPORTED_CONTEXTS));
                }
                return new ClientInfoProperty(propertyName, context);
            }
            return new ClientInfoProperty(name, ClientInfoProvider.USER_SESSION);
        }

        @Override
        public String toString() {
            if (ClientInfoProvider.USER_SESSION.equals(this.context)) {
                return this.name;
            }
            return this.name + "@" + this.context;
        }

        StringBuilder appendAsGetContext(StringBuilder sb, QuoteStrategy quoteStrategy) {
            sb.ensureCapacity(sb.length() + 25 + this.context.length() + this.name.length());
            sb.append("RDB$GET_CONTEXT(");
            quoteStrategy.appendLiteral(this.context, sb);
            sb.append(',');
            quoteStrategy.appendLiteral(this.name, sb);
            return sb.append(')');
        }

        StringBuilder appendAsSetContext(StringBuilder sb, QuoteStrategy quoteStrategy, String value) {
            sb.ensureCapacity(sb.length() + 30 + this.context.length() + this.name.length() + (value != null ? value.length() : 4));
            sb.append("RDB$SET_CONTEXT(");
            quoteStrategy.appendLiteral(this.context, sb);
            sb.append(',');
            quoteStrategy.appendLiteral(this.name, sb);
            sb.append(',');
            if (value == null) {
                sb.append("NULL");
            } else {
                quoteStrategy.appendLiteral(value, sb);
            }
            return sb.append(')');
        }
    }
}

