/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.jaybird.parser.LocalStatementClass;
import org.firebirdsql.jaybird.parser.LocalStatementType;
import org.firebirdsql.jdbc.AbstractStatement;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBParameterMetaData;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FirebirdPreparedStatement;
import org.firebirdsql.jdbc.ResultSetBehavior;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class FBTxPreparedStatement
extends AbstractStatement
implements FirebirdPreparedStatement {
    private final LocalStatementType statementType;
    private final String sql;

    FBTxPreparedStatement(FBConnection connection, LocalStatementType statementType, String sql, ResultSetBehavior rsBehavior) throws SQLException {
        super(connection, rsBehavior);
        if (statementType.statementClass() != LocalStatementClass.TRANSACTION_BOUNDARY) {
            throw new IllegalArgumentException("Unsupported value for statementType (implementation bug): " + statementType);
        }
        this.statementType = statementType;
        this.sql = sql;
        this.setPoolable(true);
    }

    @Override
    protected FbStatement getStatementHandle() throws SQLException {
        throw new SQLFeatureNotSupportedException("This statement implementation does not use a statement handle");
    }

    @Override
    public @Nullable String getExecutionPlan() throws SQLException {
        this.checkValidity();
        throw new FBDriverNotCapableException("Cannot provide an execution plan for a transaction management statement");
    }

    @Override
    public @Nullable String getExplainedExecutionPlan() throws SQLException {
        this.checkValidity();
        throw new FBDriverNotCapableException("Cannot provide an explained execution plan for a transaction management statement");
    }

    @Override
    public int getStatementType() {
        return switch (this.statementType) {
            case LocalStatementType.HARD_COMMIT -> 10;
            case LocalStatementType.HARD_ROLLBACK -> 11;
            case LocalStatementType.SET_TRANSACTION -> 9;
            default -> throw new AssertionError((Object)("Unsupported value for statementType (implementation bug): " + this.statementType));
        };
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        try (LockCloseable ignored = this.withLock();){
            super.close();
            this.connection.notifyStatementClosed(this);
        }
    }

    @Override
    public void completeStatement(CompletionReason reason) throws SQLException {
        if (reason == CompletionReason.CONNECTION_ABORT) {
            super.close();
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkValidity();
        throw FbExceptionBuilder.toNonTransientException(337248312);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute0();
        return 0;
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.execute0();
        return 0L;
    }

    @Override
    public boolean execute() throws SQLException {
        this.execute0();
        return false;
    }

    private void execute0() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            switch (this.statementType) {
                case HARD_COMMIT: {
                    this.connection.handleHardCommitStatement();
                    break;
                }
                case HARD_ROLLBACK: {
                    this.connection.handleHardRollbackStatement();
                    break;
                }
                case SET_TRANSACTION: {
                    this.connection.handleSetTransactionStatement(this.sql);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported value for statementType (implementation bug): " + this.statementType));
                }
            }
            this.performCloseOnCompletion();
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkValidity();
        throw FbExceptionBuilder.toException(337248319);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        FBTxPreparedStatement.methodNotSupported();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkValidity();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkValidity();
        return new int[0];
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkValidity();
        return new long[0];
    }

    @Override
    public @Nullable ResultSetMetaData getMetaData() throws SQLException {
        this.checkValidity();
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkValidity();
        return new FBParameterMetaData(this.connection.getFbDatabase().emptyRowDescriptor(), this.connection);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return (ResultSet)FBTxPreparedStatement.methodNotSupported();
    }

    private static <T> T methodNotSupported() throws SQLException {
        throw new SQLNonTransientException("This method is only supported on Statement and not supported on PreparedStatement and CallableStatement", "HY000");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return (Integer)FBTxPreparedStatement.methodNotSupported();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return (Long)FBTxPreparedStatement.methodNotSupported();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return (Boolean)FBTxPreparedStatement.methodNotSupported();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return (Integer)FBTxPreparedStatement.methodNotSupported();
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return (Long)FBTxPreparedStatement.methodNotSupported();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return (Integer)FBTxPreparedStatement.methodNotSupported();
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return (Long)FBTxPreparedStatement.methodNotSupported();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return (Integer)FBTxPreparedStatement.methodNotSupported();
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return (Long)FBTxPreparedStatement.methodNotSupported();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return (Boolean)FBTxPreparedStatement.methodNotSupported();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return (Boolean)FBTxPreparedStatement.methodNotSupported();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return (Boolean)FBTxPreparedStatement.methodNotSupported();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.noParameters(parameterIndex);
    }

    private void noParameters(int parameterIndex) throws SQLException {
        this.checkValidity();
        throw new SQLException("Invalid column index: " + parameterIndex, "HY091");
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setBigDecimal(int parameterIndex, @Nullable BigDecimal x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setString(int parameterIndex, @Nullable String x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setBytes(int parameterIndex, byte @Nullable [] x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setDate(int parameterIndex, @Nullable Date x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setTime(int parameterIndex, @Nullable Time x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setTimestamp(int parameterIndex, @Nullable Timestamp x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setAsciiStream(int parameterIndex, @Nullable InputStream x, int length) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, @Nullable InputStream x, int length) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setBinaryStream(int parameterIndex, @Nullable InputStream x, int length) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkValidity();
    }

    @Override
    public void setObject(int parameterIndex, @Nullable Object x, int targetSqlType) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setObject(int parameterIndex, @Nullable Object x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setCharacterStream(int parameterIndex, @Nullable Reader reader, int length) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setRef(int parameterIndex, @Nullable Ref x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setBlob(int parameterIndex, @Nullable Blob x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setClob(int parameterIndex, @Nullable Clob x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setArray(int parameterIndex, @Nullable Array x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setDate(int parameterIndex, @Nullable Date x, @Nullable Calendar cal) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setTime(int parameterIndex, @Nullable Time x, @Nullable Calendar cal) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setTimestamp(int parameterIndex, @Nullable Timestamp x, @Nullable Calendar cal) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setURL(int parameterIndex, @Nullable URL x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setRowId(int parameterIndex, @Nullable RowId x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setNString(int parameterIndex, @Nullable String value) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, @Nullable Reader value, long length) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setNClob(int parameterIndex, @Nullable NClob value) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setClob(int parameterIndex, @Nullable Reader reader, long length) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setBlob(int parameterIndex, @Nullable InputStream inputStream, long length) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setNClob(int parameterIndex, @Nullable Reader reader, long length) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setSQLXML(int parameterIndex, @Nullable SQLXML xmlObject) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setObject(int parameterIndex, @Nullable Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setAsciiStream(int parameterIndex, @Nullable InputStream x, long length) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setBinaryStream(int parameterIndex, @Nullable InputStream x, long length) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setCharacterStream(int parameterIndex, @Nullable Reader reader, long length) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setAsciiStream(int parameterIndex, @Nullable InputStream x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setBinaryStream(int parameterIndex, @Nullable InputStream x) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setCharacterStream(int parameterIndex, @Nullable Reader reader) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, @Nullable Reader value) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setClob(int parameterIndex, @Nullable Reader reader) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setBlob(int parameterIndex, @Nullable InputStream inputStream) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public void setNClob(int parameterIndex, @Nullable Reader reader) throws SQLException {
        this.noParameters(parameterIndex);
    }

    @Override
    public int getInsertedRowsCount() {
        return -1;
    }

    @Override
    public int getUpdatedRowsCount() {
        return -1;
    }

    @Override
    public int getDeletedRowsCount() {
        return -1;
    }

    @Override
    public boolean hasOpenResultSet() {
        return false;
    }

    @Override
    @Deprecated(since="6", forRemoval=true)
    public @Nullable ResultSet getCurrentResultSet() throws SQLException {
        return this.getResultSet();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkValidity();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkValidity();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkValidity();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkValidity();
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkValidity();
    }

    @Override
    public void cancel() throws SQLException {
        this.checkValidity();
        throw new FBDriverNotCapableException("Cannot cancel transaction management statement execution");
    }

    @Override
    public @Nullable ResultSet getResultSet() throws SQLException {
        this.checkValidity();
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkValidity();
        return -1;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkValidity();
        return -1L;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkValidity();
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkValidity();
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkValidity();
        return new FBResultSet(this.connection.getFbDatabase().emptyRowDescriptor(), List.of());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw FbExceptionBuilder.forException(337248338).messageParameter((Object)(iface != null ? iface.getName() : "(null)")).toSQLException();
        }
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }
}

