/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;

abstract class AbstractWithoutTimeZoneField
extends FBField {
    private Calendar calendar;

    @NullMarked
    AbstractWithoutTimeZoneField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public final Time getTime() throws SQLException {
        return this.getTime(this.getCalendar());
    }

    @Override
    public final Timestamp getTimestamp() throws SQLException {
        return this.getTimestamp(this.getCalendar());
    }

    @Override
    public final Date getDate() throws SQLException {
        return this.getDate(this.getCalendar());
    }

    @Override
    public final void setTime(Time value) throws SQLException {
        this.setTime(value, this.getCalendar());
    }

    @Override
    public final void setTimestamp(Timestamp value) throws SQLException {
        this.setTimestamp(value, this.getCalendar());
    }

    @Override
    public final void setDate(Date value) throws SQLException {
        this.setDate(value, this.getCalendar());
    }

    final @NonNull Calendar getCalendar() {
        return this.calendar != null ? this.calendar : this.initCalendar();
    }

    private @NonNull Calendar initCalendar() {
        TimeZone sessionTimeZone = this.gdsHelper != null ? this.gdsHelper.getSessionTimeZone() : null;
        this.calendar = sessionTimeZone != null ? Calendar.getInstance(sessionTimeZone) : Calendar.getInstance();
        return this.calendar;
    }
}

