/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import org.firebirdsql.gds.impl.GDSServerVersion;
import org.firebirdsql.gds.ng.FbAttachment;
import org.firebirdsql.gds.ng.OdsVersion;
import org.firebirdsql.jdbc.FirebirdConnection;

public final class FirebirdSupportInfo {
    private final GDSServerVersion serverVersion;

    private FirebirdSupportInfo(GDSServerVersion serverVersion) {
        if (Objects.requireNonNull(serverVersion, "serverVersion").equals(GDSServerVersion.INVALID_VERSION)) {
            throw new IllegalArgumentException("serverVersion is an invalid version (GDSServerVersion.INVALID_VERSION)");
        }
        this.serverVersion = serverVersion;
    }

    public boolean isVersionEqualOrAbove(int majorVersion) {
        return this.serverVersion.isEqualOrAbove(majorVersion);
    }

    public boolean isVersionEqualOrAbove(int majorVersion, int minorVersion) {
        return this.serverVersion.isEqualOrAbove(majorVersion, minorVersion);
    }

    public boolean isVersionEqualOrAbove(int requiredMajorVersion, int requiredMinorVersion, int requiredVariant) {
        return this.serverVersion.isEqualOrAbove(requiredMajorVersion, requiredMinorVersion, requiredVariant);
    }

    public boolean isVersionBelow(int majorVersion, int minorVersion) {
        return !this.isVersionEqualOrAbove(majorVersion, minorVersion);
    }

    public boolean isVersionBelow(int majorVersion) {
        return !this.isVersionEqualOrAbove(majorVersion);
    }

    public boolean supportsBigint() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean supportsBoolean() {
        return this.isVersionEqualOrAbove(3);
    }

    public boolean supportsDecfloat() {
        return this.isVersionEqualOrAbove(4);
    }

    public boolean supportsDecimalPrecision(int precision) {
        if (precision < 1) {
            return false;
        }
        if (precision <= 18) {
            return true;
        }
        if (precision <= 38) {
            return this.isVersionEqualOrAbove(4);
        }
        return false;
    }

    public int maxDecimalPrecision() {
        if (this.isVersionEqualOrAbove(4)) {
            return 38;
        }
        return 18;
    }

    public boolean supportsInt128() {
        return this.isVersionEqualOrAbove(4);
    }

    public boolean supportsComment() {
        return this.isVersionEqualOrAbove(2);
    }

    public boolean supportsGetSetContext() {
        return this.isVersionEqualOrAbove(2);
    }

    public boolean supportsCase() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean reportsBlobCharSetInDescriptor() {
        return this.isVersionEqualOrAbove(2, 1);
    }

    public boolean reportsByteLengthInDescriptor() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean supportsInsertReturning() {
        return this.isVersionEqualOrAbove(2);
    }

    public boolean supportsUpdateReturning() {
        return this.isVersionEqualOrAbove(2, 1);
    }

    public boolean supportsReturningAll() {
        return this.isVersionEqualOrAbove(4);
    }

    public boolean supportsMultiRowReturning() {
        return this.isVersionEqualOrAbove(5);
    }

    public boolean supportsUtf8() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean supportsSavepoint() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean supportsExecuteBlock() {
        return this.isVersionEqualOrAbove(2);
    }

    public boolean supportsSqlUserManagement() {
        return this.isVersionEqualOrAbove(2, 5);
    }

    public boolean supportsCancelOperation() {
        return this.isVersionEqualOrAbove(2, 5);
    }

    public boolean supportsTableAlias() {
        return this.isVersionEqualOrAbove(2);
    }

    public boolean supportsNullDataType() {
        return this.isVersionEqualOrAbove(2, 5);
    }

    public boolean supportsUserAndGroupIdInUser() {
        return this.isVersionBelow(3);
    }

    public boolean supportsProtocol(int protocolVersion) {
        return switch (protocolVersion) {
            case 10 -> true;
            case 11 -> this.isVersionEqualOrAbove(2, 1);
            case 12 -> this.isVersionEqualOrAbove(2, 5);
            case 13 -> this.isVersionEqualOrAbove(3);
            case 14, 15 -> this.isVersionEqualOrAbove(3, 0, 2);
            case 16 -> this.isVersionEqualOrAbove(4, 0, 0);
            case 18 -> this.isVersionEqualOrAbove(5, 0, 0);
            default -> false;
        };
    }

    public boolean supportsCustomExceptionMessages() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean supportsParametrizedExceptions() {
        return this.isVersionEqualOrAbove(3);
    }

    public boolean supportsMonitoringTables() {
        return this.isVersionEqualOrAbove(2, 1);
    }

    public boolean supportsGlobalTemporaryTables() {
        return this.isVersionEqualOrAbove(2, 5);
    }

    public boolean supportsFullSearchableBlobs() {
        return this.isVersionEqualOrAbove(2, 1);
    }

    public boolean supportsIdentityColumns() {
        return this.isVersionEqualOrAbove(3);
    }

    public int maxIdentifierLengthCharacters() {
        if (this.isVersionEqualOrAbove(4)) {
            return 63;
        }
        return 31;
    }

    public int maxIdentifierLengthBytes() {
        if (this.isVersionEqualOrAbove(4)) {
            return 252;
        }
        return 31;
    }

    public int maxReportedIdentifierLengthBytes() {
        if (this.isVersionEqualOrAbove(4)) {
            return 252;
        }
        if (this.reportsByteLengthInDescriptor()) {
            return 93;
        }
        return 31;
    }

    public int reportedMetadataCharacterSetId() {
        if (this.isVersionEqualOrAbove(4)) {
            return 4;
        }
        return 3;
    }

    public boolean supportsPageSize(int pageSize) {
        return switch (pageSize) {
            case 1024, 2048 -> {
                if (!this.isVersionEqualOrAbove(2, 1)) {
                    yield true;
                }
                yield false;
            }
            case 4096, 8192, 16384 -> true;
            case 32768 -> this.isVersionEqualOrAbove(4);
            default -> false;
        };
    }

    public boolean supportsWireEncryption() {
        return this.isVersionEqualOrAbove(3);
    }

    public boolean supportsWireCryptArc4() {
        return this.isVersionEqualOrAbove(3);
    }

    public boolean supportsWireCryptChaCha() {
        return this.isVersionEqualOrAbove(4);
    }

    public boolean supportsWireCryptChaCha64() {
        return this.isVersionEqualOrAbove(4, 0, 1);
    }

    public boolean supportsWireCompression() {
        return this.isVersionEqualOrAbove(3);
    }

    public boolean supportsNativeUserDefinedFunctions() {
        return this.isVersionBelow(4);
    }

    public boolean supportsPsqlFunctions() {
        return this.isVersionEqualOrAbove(3);
    }

    public boolean supportsAuthenticationPlugin(String pluginName) {
        return switch (pluginName) {
            case "Legacy_Auth" -> true;
            case "Srp" -> this.isVersionEqualOrAbove(3);
            case "Srp224", "Srp256", "Srp384", "Srp512" -> this.isVersionEqualOrAbove(3, 0, 4);
            default -> false;
        };
    }

    public boolean supportsRecordVersionPseudoColumn() {
        return this.isVersionEqualOrAbove(3);
    }

    public int getSystemTableCount() {
        return switch (this.serverVersion.getMajorVersion()) {
            case 0, 1 -> 32;
            case 2 -> {
                switch (this.serverVersion.getMinorVersion()) {
                    case 0: {
                        yield 33;
                    }
                    case 1: {
                        yield 40;
                    }
                    case 5: {
                        yield 42;
                    }
                }
                yield -1;
            }
            case 3 -> 50;
            case 4 -> 54;
            case 5 -> 56;
            case 6 -> 56;
            default -> -1;
        };
    }

    public boolean supportsCaseSensitiveUserNames() {
        return this.isVersionEqualOrAbove(3);
    }

    public boolean supportsExplainedExecutionPlan() {
        return this.isVersionEqualOrAbove(3);
    }

    public boolean supportsTimeZones() {
        return this.isVersionEqualOrAbove(4);
    }

    public boolean supportsPackages() {
        return this.isVersionEqualOrAbove(3);
    }

    public boolean supportsFloatBinaryPrecision() {
        return this.isVersionEqualOrAbove(4);
    }

    public boolean supportsStatementTimeouts() {
        return this.isVersionEqualOrAbove(4);
    }

    public boolean supportsStatementUnprepare() {
        return this.isVersionEqualOrAbove(2, 5);
    }

    public boolean supportsNBackupWithGuid() {
        return this.isVersionEqualOrAbove(4);
    }

    public boolean supportsNBackupInPlaceRestore() {
        return this.isVersionEqualOrAbove(4);
    }

    public boolean supportsNBackupFixup() {
        return this.isVersionEqualOrAbove(4);
    }

    public boolean supportsNBackupPreserveSequence() {
        return this.isVersionEqualOrAbove(4);
    }

    public boolean supportsNBackupCleanHistory() {
        return this.isVersionEqualOrAbove(4, 0, 3);
    }

    public boolean supportsScrollableCursors() {
        return this.isVersionEqualOrAbove(5);
    }

    public boolean supportsServerBatch() {
        return this.isVersionEqualOrAbove(4);
    }

    public boolean supportsCustomSecurityDb() {
        return this.isVersionEqualOrAbove(3);
    }

    public boolean supportsWnet() {
        return this.isVersionBelow(5);
    }

    public boolean supportsStatementTextLongerThan64K() {
        return this.isVersionEqualOrAbove(3);
    }

    public boolean supportsParallelWorkers() {
        return this.isVersionEqualOrAbove(5);
    }

    public boolean supportsRDB$CONFIG() {
        return this.isVersionEqualOrAbove(4);
    }

    public boolean supportsUpgradeOds() {
        return this.isVersionEqualOrAbove(5);
    }

    public boolean supportsFixIcu() {
        return this.isVersionEqualOrAbove(3);
    }

    public boolean supportsParameterizedExceptions() {
        return this.isVersionEqualOrAbove(3);
    }

    public boolean supportsDatabaseTriggers() {
        return this.isVersionEqualOrAbove(2, 5);
    }

    public boolean supportsPartialIndices() {
        return this.isVersionEqualOrAbove(5);
    }

    public boolean supportsMetadataPrivileges() {
        return this.isVersionEqualOrAbove(3);
    }

    public OdsVersion getDefaultOdsVersion() {
        return switch (this.serverVersion.getMajorVersion()) {
            case 0, 1 -> OdsVersion.of(10, 0);
            case 2 -> {
                switch (this.serverVersion.getMinorVersion()) {
                    case 0: {
                        yield OdsVersion.of(11, 0);
                    }
                    case 1: {
                        yield OdsVersion.of(11, 1);
                    }
                    case 5: {
                        yield OdsVersion.of(11, 2);
                    }
                }
                throw new IllegalArgumentException("Unsupported version: " + this.serverVersion);
            }
            case 3 -> OdsVersion.of(12, 0);
            case 4 -> OdsVersion.of(13, 0);
            case 5 -> OdsVersion.of(13, 1);
            case 6 -> OdsVersion.of(14, 0);
            default -> throw new IllegalArgumentException("Unsupported version: " + this.serverVersion);
        };
    }

    public boolean supportsOds(int major, int minor) {
        return switch (major) {
            case 10 -> this.isVersionBelow(3);
            case 11 -> {
                switch (minor) {
                    case 0: {
                        if (this.isVersionEqualOrAbove(2) && this.isVersionBelow(3)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1: {
                        if (this.isVersionEqualOrAbove(2, 1) && this.isVersionBelow(3)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 2: {
                        if (this.isVersionEqualOrAbove(2, 5) && this.isVersionBelow(3)) {
                            yield true;
                        }
                        yield false;
                    }
                }
                yield false;
            }
            case 12 -> {
                if (this.isVersionEqualOrAbove(3) && this.isVersionBelow(4)) {
                    yield true;
                }
                yield false;
            }
            case 13 -> {
                switch (minor) {
                    case 0: {
                        if (this.isVersionEqualOrAbove(4) && this.isVersionBelow(6)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1: {
                        if (this.isVersionEqualOrAbove(5) && this.isVersionBelow(6)) {
                            yield true;
                        }
                        yield false;
                    }
                }
                yield false;
            }
            case 14 -> {
                if (this.isVersionEqualOrAbove(6) && this.isVersionBelow(7)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public boolean supportsOds(OdsVersion odsVersion) {
        return this.supportsOds(odsVersion.major(), odsVersion.minor());
    }

    public boolean isSupportedVersion() {
        return this.isVersionEqualOrAbove(3);
    }

    public boolean hasProcedureTypeColumn() {
        return this.isVersionEqualOrAbove(2, 1);
    }

    public boolean isWindows() {
        return this.serverVersion.getPlatform().equals("WI");
    }

    public static FirebirdSupportInfo supportInfoFor(GDSServerVersion serverVersion) {
        return new FirebirdSupportInfo(serverVersion);
    }

    public static FirebirdSupportInfo supportInfoFor(FbAttachment attachment) {
        return FirebirdSupportInfo.supportInfoFor(attachment.getServerVersion());
    }

    public static FirebirdSupportInfo supportInfoFor(Connection connection) {
        try {
            if (connection.isWrapperFor(FirebirdConnection.class)) {
                return FirebirdSupportInfo.supportInfoFor(connection.unwrap(FirebirdConnection.class).getFbDatabase());
            }
            throw new IllegalArgumentException("connection needs to be (or unwrap to) an org.firebirdsql.jdbc.FBConnection");
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

