/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.ee.idl;

import com.sun.tools.corba.ee.idl.InvalidArgument;
import com.sun.tools.corba.ee.idl.som.cff.FileLocator;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Arguments {
    public String file = null;
    public boolean verbose = false;
    public boolean keepOldFiles = false;
    public boolean emitAll = false;
    public Vector includePaths = new Vector();
    public Hashtable definedSymbols = new Hashtable();
    public boolean cppModule = false;
    public boolean versionRequest = false;
    public float corbaLevel = 2.2f;
    public boolean noWarn = false;
    public boolean scannerDebugFlag = false;
    public boolean tokenDebugFlag = false;

    protected void parseOtherArgs(String[] args, Properties properties) throws InvalidArgument {
        if (args.length > 0) {
            throw new InvalidArgument(args[0]);
        }
    }

    protected void setDebugFlags(String args) {
        StringTokenizer st = new StringTokenizer(args, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            try {
                Field fld = this.getClass().getField(token + "DebugFlag");
                int mod = fld.getModifiers();
                if (!Modifier.isPublic(mod) || Modifier.isStatic(mod) || fld.getType() != Boolean.TYPE) continue;
                fld.setBoolean(this, true);
            }
            catch (Exception exc) {}
        }
    }

    void parseArgs(String[] args) throws InvalidArgument {
        Object[] otherArgs;
        Vector<String> unknownArgs = new Vector<String>();
        int i = 0;
        try {
            for (i = 0; i < args.length - 1; ++i) {
                if (args[i].charAt(0) != '-' && args[i].charAt(0) != '/') {
                    throw new InvalidArgument(args[i]);
                }
                String lcArg = args[i].substring(1).toLowerCase();
                if (lcArg.equals("i")) {
                    this.includePaths.addElement(args[++i]);
                    continue;
                }
                if (lcArg.startsWith("i")) {
                    this.includePaths.addElement(args[i].substring(2));
                    continue;
                }
                if (lcArg.equals("v") || lcArg.equals("verbose")) {
                    this.verbose = true;
                    continue;
                }
                if (lcArg.equals("d")) {
                    this.definedSymbols.put(args[++i], "");
                    continue;
                }
                if (lcArg.equals("debug")) {
                    this.setDebugFlags(args[++i]);
                    continue;
                }
                if (lcArg.startsWith("d")) {
                    this.definedSymbols.put(args[i].substring(2), "");
                    continue;
                }
                if (lcArg.equals("emitall")) {
                    this.emitAll = true;
                    continue;
                }
                if (lcArg.equals("keep")) {
                    this.keepOldFiles = true;
                    continue;
                }
                if (lcArg.equals("nowarn")) {
                    this.noWarn = true;
                    continue;
                }
                if (lcArg.equals("trace")) {
                    Runtime.getRuntime().traceMethodCalls(true);
                    continue;
                }
                if (lcArg.equals("cppmodule")) {
                    this.cppModule = true;
                    continue;
                }
                if (lcArg.equals("version")) {
                    this.versionRequest = true;
                    continue;
                }
                if (lcArg.equals("corba")) {
                    String level;
                    if (i + 1 >= args.length) {
                        throw new InvalidArgument(args[i]);
                    }
                    if ((level = args[++i]).charAt(0) == '-') {
                        throw new InvalidArgument(args[i - 1]);
                    }
                    try {
                        this.corbaLevel = new Float(level).floatValue();
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidArgument(args[i]);
                    }
                }
                unknownArgs.addElement(args[i]);
                ++i;
                while (i < args.length - 1 && args[i].charAt(0) != '-' && args[i].charAt(0) != '/') {
                    unknownArgs.addElement(args[i++]);
                }
                --i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new InvalidArgument(args[args.length - 1]);
        }
        if (i == args.length - 1) {
            if (args[i].toLowerCase().equals("-version")) {
                this.versionRequest = true;
            } else {
                this.file = args[i];
            }
        } else {
            throw new InvalidArgument();
        }
        Properties props = new Properties();
        try {
            DataInputStream stream = FileLocator.locateFileInClassPath("idl.config");
            props.load(stream);
            this.addIncludePaths(props);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (unknownArgs.size() > 0) {
            otherArgs = new String[unknownArgs.size()];
            unknownArgs.copyInto(otherArgs);
        } else {
            otherArgs = new String[]{};
        }
        this.parseOtherArgs((String[])otherArgs, props);
    }

    private void addIncludePaths(Properties props) {
        String paths = props.getProperty("includes");
        if (paths != null) {
            String separator = System.getProperty("path.separator");
            int end = -separator.length();
            do {
                if ((end = (paths = paths.substring(end + separator.length())).indexOf(separator)) < 0) {
                    end = paths.length();
                }
                this.includePaths.addElement(paths.substring(0, end));
            } while (end != paths.length());
        }
    }
}

