/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.ee.idl;

import com.sun.tools.corba.ee.idl.ForwardEntry;
import com.sun.tools.corba.ee.idl.Generator;
import com.sun.tools.corba.ee.idl.IDLID;
import com.sun.tools.corba.ee.idl.InterfaceGen;
import com.sun.tools.corba.ee.idl.InterfaceState;
import com.sun.tools.corba.ee.idl.InterfaceType;
import com.sun.tools.corba.ee.idl.MethodEntry;
import com.sun.tools.corba.ee.idl.ParseException;
import com.sun.tools.corba.ee.idl.Scanner;
import com.sun.tools.corba.ee.idl.SymtabEntry;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class InterfaceEntry
extends SymtabEntry
implements InterfaceType {
    private Vector _derivedFromNames = new Vector();
    private Vector _derivedFrom = new Vector();
    private Vector _methods = new Vector();
    Vector _allMethods = new Vector();
    Vector forwardedDerivers = new Vector();
    private Vector _contained = new Vector();
    private Vector _state = null;
    private int _interfaceType = 0;
    static InterfaceGen interfaceGen;

    protected InterfaceEntry() {
    }

    protected InterfaceEntry(InterfaceEntry that) {
        super(that);
        this._derivedFromNames = (Vector)that._derivedFromNames.clone();
        this._derivedFrom = (Vector)that._derivedFrom.clone();
        this._methods = (Vector)that._methods.clone();
        this._allMethods = (Vector)that._allMethods.clone();
        this.forwardedDerivers = (Vector)that.forwardedDerivers.clone();
        this._contained = (Vector)that._contained.clone();
        this._interfaceType = that._interfaceType;
    }

    protected InterfaceEntry(SymtabEntry that, IDLID clone) {
        super(that, clone);
        if (this.module().equals("")) {
            this.module(this.name());
        } else if (!this.name().equals("")) {
            this.module(this.module() + "/" + this.name());
        }
    }

    public boolean isAbstract() {
        return this._interfaceType == 1;
    }

    public boolean isLocal() {
        return this._interfaceType == 2;
    }

    public boolean isLocalServant() {
        return this._interfaceType == 3;
    }

    public boolean isLocalSignature() {
        return this._interfaceType == 4;
    }

    @Override
    public Object clone() {
        return new InterfaceEntry(this);
    }

    @Override
    public void generate(Hashtable symbolTable, PrintWriter stream) {
        interfaceGen.generate(symbolTable, this, stream);
    }

    @Override
    public Generator generator() {
        return interfaceGen;
    }

    public void addDerivedFrom(SymtabEntry derivedFrom) {
        this._derivedFrom.addElement(derivedFrom);
    }

    public Vector derivedFrom() {
        return this._derivedFrom;
    }

    public void addDerivedFromName(String name) {
        this._derivedFromNames.addElement(name);
    }

    public Vector derivedFromNames() {
        return this._derivedFromNames;
    }

    public void addMethod(MethodEntry method) {
        this._methods.addElement(method);
    }

    public Vector methods() {
        return this._methods;
    }

    public void addContained(SymtabEntry entry) {
        this._contained.addElement(entry);
    }

    public Vector contained() {
        return this._contained;
    }

    void methodsAddElement(MethodEntry method, Scanner scanner) {
        if (this.verifyMethod(method, scanner, false)) {
            this.addMethod(method);
            this._allMethods.addElement(method);
            this.addToForwardedAllMethods(method, scanner);
        }
    }

    void addToForwardedAllMethods(MethodEntry method, Scanner scanner) {
        Enumeration e = this.forwardedDerivers.elements();
        while (e.hasMoreElements()) {
            InterfaceEntry derived = (InterfaceEntry)e.nextElement();
            if (!derived.verifyMethod(method, scanner, true)) continue;
            derived._allMethods.addElement(method);
        }
    }

    private boolean verifyMethod(MethodEntry method, Scanner scanner, boolean clash) {
        boolean unique = true;
        String lcName = method.name().toLowerCase();
        Enumeration e = this._allMethods.elements();
        while (e.hasMoreElements()) {
            MethodEntry emethod = (MethodEntry)e.nextElement();
            String lceName = emethod.name().toLowerCase();
            if (method == emethod || !lcName.equals(lceName)) continue;
            if (clash) {
                ParseException.methodClash(scanner, this.fullName(), method.name());
            } else {
                ParseException.alreadyDeclared(scanner, method.name());
            }
            unique = false;
            break;
        }
        return unique;
    }

    void derivedFromAddElement(SymtabEntry e, Scanner scanner) {
        this.addDerivedFrom(e);
        this.addDerivedFromName(e.fullName());
        this.addParentType(e, scanner);
    }

    void addParentType(SymtabEntry e, Scanner scanner) {
        if (e instanceof ForwardEntry) {
            this.addToDerivers((ForwardEntry)e);
        } else {
            InterfaceEntry derivedFrom = (InterfaceEntry)e;
            Enumeration enumeration = derivedFrom._allMethods.elements();
            while (enumeration.hasMoreElements()) {
                MethodEntry method = (MethodEntry)enumeration.nextElement();
                if (this.verifyMethod(method, scanner, true)) {
                    this._allMethods.addElement(method);
                }
                this.addToForwardedAllMethods(method, scanner);
            }
            this.lookForForwardEntrys(scanner, derivedFrom);
        }
    }

    private void lookForForwardEntrys(Scanner scanner, InterfaceEntry entry) {
        Enumeration parents = entry.derivedFrom().elements();
        while (parents.hasMoreElements()) {
            SymtabEntry parent = (SymtabEntry)parents.nextElement();
            if (parent instanceof ForwardEntry) {
                this.addToDerivers((ForwardEntry)parent);
                continue;
            }
            if (parent == entry) {
                ParseException.selfInherit(scanner, entry.fullName());
                continue;
            }
            this.lookForForwardEntrys(scanner, (InterfaceEntry)parent);
        }
    }

    public boolean replaceForwardDecl(ForwardEntry oldEntry, InterfaceEntry newEntry) {
        int index = this._derivedFrom.indexOf(oldEntry);
        if (index >= 0) {
            this._derivedFrom.setElementAt(newEntry, index);
        }
        return index >= 0;
    }

    private void addToDerivers(ForwardEntry forward) {
        forward.derivers.addElement(this);
        Enumeration e = this.forwardedDerivers.elements();
        while (e.hasMoreElements()) {
            forward.derivers.addElement((InterfaceEntry)e.nextElement());
        }
    }

    public Vector state() {
        return this._state;
    }

    public void initState() {
        this._state = new Vector();
    }

    public void addStateElement(InterfaceState state, Scanner scanner) {
        if (this._state == null) {
            this._state = new Vector();
        }
        String name = state.entry.name();
        Enumeration e = this._state.elements();
        while (e.hasMoreElements()) {
            if (!name.equals(((InterfaceState)e.nextElement()).entry.name())) continue;
            ParseException.duplicateState(scanner, name);
        }
        this._state.addElement(state);
    }

    @Override
    public int getInterfaceType() {
        return this._interfaceType;
    }

    @Override
    public void setInterfaceType(int type) {
        this._interfaceType = type;
    }

    public Vector allMethods() {
        return this._allMethods;
    }
}

