/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.ee.idl;

import com.sun.tools.corba.ee.idl.AttributeEntry;
import com.sun.tools.corba.ee.idl.ConstEntry;
import com.sun.tools.corba.ee.idl.EnumEntry;
import com.sun.tools.corba.ee.idl.ExceptionEntry;
import com.sun.tools.corba.ee.idl.InterfaceEntry;
import com.sun.tools.corba.ee.idl.MethodEntry;
import com.sun.tools.corba.ee.idl.ModuleEntry;
import com.sun.tools.corba.ee.idl.ParameterEntry;
import com.sun.tools.corba.ee.idl.PrimitiveEntry;
import com.sun.tools.corba.ee.idl.RepositoryID;
import com.sun.tools.corba.ee.idl.SequenceEntry;
import com.sun.tools.corba.ee.idl.StringEntry;
import com.sun.tools.corba.ee.idl.StructEntry;
import com.sun.tools.corba.ee.idl.SymtabEntry;
import com.sun.tools.corba.ee.idl.TypedefEntry;
import com.sun.tools.corba.ee.idl.UnionEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class Util {
    private static final String DEFAULT_MESSAGE_RESOURCE = "com/sun/tools/corba/ee/idl/idl";
    private static Properties messages = null;
    private static String defaultKey = "default";
    private static Vector<String> msgResources = new Vector();
    static RepositoryID emptyID;

    public static String getVersion() {
        return Util.getVersion(DEFAULT_MESSAGE_RESOURCE);
    }

    protected static String getVersion(String filename) {
        String version = "";
        if (messages == null) {
            Vector<String> oldMsgFiles = msgResources;
            if (filename == null || filename.equals("")) {
                filename = DEFAULT_MESSAGE_RESOURCE;
            }
            filename = filename.replace('/', File.separatorChar);
            Util.registerMessageResource(filename);
            version = Util.getMessage("Version.product", Util.getMessage("Version.number"));
            msgResources = oldMsgFiles;
            messages = null;
        } else {
            version = Util.getMessage("Version.product", Util.getMessage("Version.number"));
        }
        return version;
    }

    public static boolean isAttribute(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof AttributeEntry;
    }

    public static boolean isConst(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof ConstEntry;
    }

    public static boolean isEnum(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof EnumEntry;
    }

    public static boolean isException(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof ExceptionEntry;
    }

    public static boolean isInterface(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof InterfaceEntry;
    }

    public static boolean isMethod(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof MethodEntry;
    }

    public static boolean isModule(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof ModuleEntry;
    }

    public static boolean isParameter(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof ParameterEntry;
    }

    public static boolean isPrimitive(String name, Hashtable symbolTable) {
        int parenIndex;
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        if (entry == null && (parenIndex = name.indexOf(40)) >= 0) {
            entry = (SymtabEntry)symbolTable.get(name.substring(0, parenIndex));
        }
        return entry == null ? false : entry instanceof PrimitiveEntry;
    }

    public static boolean isSequence(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof SequenceEntry;
    }

    public static boolean isStruct(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof StructEntry;
    }

    public static boolean isString(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof StringEntry;
    }

    public static boolean isTypedef(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof TypedefEntry;
    }

    public static boolean isUnion(String name, Hashtable symbolTable) {
        SymtabEntry entry = (SymtabEntry)symbolTable.get(name);
        return entry == null ? false : entry instanceof UnionEntry;
    }

    public static String getMessage(String key) {
        String message;
        if (messages == null) {
            Util.readMessages();
        }
        if ((message = messages.getProperty(key)) == null) {
            message = Util.getDefaultMessage(key);
        }
        return message;
    }

    public static String getMessage(String key, String fill) {
        String message;
        if (messages == null) {
            Util.readMessages();
        }
        if ((message = messages.getProperty(key)) == null) {
            message = Util.getDefaultMessage(key);
        } else {
            int index = message.indexOf("%0");
            if (index >= 0) {
                message = message.substring(0, index) + fill + message.substring(index + 2);
            }
        }
        return message;
    }

    public static String getMessage(String key, String[] fill) {
        String message;
        if (messages == null) {
            Util.readMessages();
        }
        if ((message = messages.getProperty(key)) == null) {
            message = Util.getDefaultMessage(key);
        } else {
            for (int i = 0; i < fill.length; ++i) {
                int index = message.indexOf("%" + i);
                if (index < 0) continue;
                message = message.substring(0, index) + fill[i] + message.substring(index + 2);
            }
        }
        return message;
    }

    private static String getDefaultMessage(String keyNotFound) {
        String message = messages.getProperty(defaultKey);
        int index = message.indexOf("%0");
        if (index > 0) {
            message = message.substring(0, index) + keyNotFound;
        }
        return message;
    }

    private static void readMessages() {
        messages = new Properties();
        for (String msgResource : msgResources) {
            Util.loadMessages(msgResource);
        }
        if (messages.size() == 0) {
            messages.put(defaultKey, "Error reading Messages File.");
        }
    }

    private static void loadMessages(String msgResource) {
        try {
            ResourceBundle newMessages = ResourceBundle.getBundle(msgResource);
            for (String key : newMessages.keySet()) {
                messages.setProperty(key, newMessages.getString(key));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public static void registerMessageResource(String resourceName) {
        if (resourceName != null) {
            if (messages == null) {
                msgResources.addElement(resourceName);
            } else {
                Util.loadMessages(resourceName);
            }
        }
    }

    public static String capitalize(String lc) {
        String first = lc.substring(0, 1);
        first = first.toUpperCase();
        return first + lc.substring(1);
    }

    public static String getAbsolutePath(String filename, Vector includePaths) throws FileNotFoundException {
        String filepath = null;
        File file = new File(filename);
        if (file.canRead()) {
            filepath = file.getAbsolutePath();
        } else {
            String fullname = null;
            Enumeration pathList = includePaths.elements();
            while (!file.canRead() && pathList.hasMoreElements()) {
                fullname = (String)pathList.nextElement() + File.separatorChar + filename;
                file = new File(fullname);
            }
            if (file.canRead()) {
                filepath = file.getPath();
            } else {
                throw new FileNotFoundException(filename);
            }
        }
        return filepath;
    }

    public static float absDelta(float f1, float f2) {
        double delta = f1 - f2;
        return (float)(delta < 0.0 ? delta * -1.0 : delta);
    }

    static {
        msgResources.addElement(DEFAULT_MESSAGE_RESOURCE);
        emptyID = new RepositoryID();
    }
}

