/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.ee.idl.constExpr;

import com.sun.tools.corba.ee.idl.Util;
import com.sun.tools.corba.ee.idl.constExpr.BinaryExpr;
import com.sun.tools.corba.ee.idl.constExpr.EvaluationException;
import com.sun.tools.corba.ee.idl.constExpr.Expression;
import java.math.BigInteger;

public class GreaterEqual
extends BinaryExpr {
    protected GreaterEqual(Expression leftOperand, Expression rightOperand) {
        super(">=", leftOperand, rightOperand);
    }

    @Override
    public Object evaluate() throws EvaluationException {
        try {
            Object left = this.left().evaluate();
            if (left instanceof Boolean) {
                String[] parameters = new String[]{Util.getMessage("EvaluationException.greaterEqual"), this.left().value().getClass().getName(), this.right().value().getClass().getName()};
                throw new EvaluationException(Util.getMessage("EvaluationException.1", parameters));
            }
            Number l = (Number)left;
            Number r = (Number)this.right().evaluate();
            if (l instanceof Float || l instanceof Double || r instanceof Float || r instanceof Double) {
                this.value(l.doubleValue() >= r.doubleValue());
            } else {
                this.value(((BigInteger)l).compareTo((BigInteger)r) >= 0);
            }
        }
        catch (ClassCastException e) {
            String[] parameters = new String[]{Util.getMessage("EvaluationException.greaterEqual"), this.left().value().getClass().getName(), this.right().value().getClass().getName()};
            throw new EvaluationException(Util.getMessage("EvaluationException.1", parameters));
        }
        return this.value();
    }
}

