/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.ee.idl.constExpr;

import com.sun.tools.corba.ee.idl.Util;
import com.sun.tools.corba.ee.idl.constExpr.EvaluationException;
import com.sun.tools.corba.ee.idl.constExpr.Expression;
import com.sun.tools.corba.ee.idl.constExpr.UnaryExpr;
import java.math.BigInteger;

public class Not
extends UnaryExpr {
    protected Not(Expression operand) {
        super("~", operand);
    }

    @Override
    public Object evaluate() throws EvaluationException {
        try {
            Number op = (Number)this.operand().evaluate();
            if (op instanceof Float || op instanceof Double) {
                String[] parameters = new String[]{Util.getMessage("EvaluationException.not"), this.operand().value().getClass().getName()};
                throw new EvaluationException(Util.getMessage("EvaluationException.2", parameters));
            }
            BigInteger b = (BigInteger)this.coerceToTarget((BigInteger)op);
            if (this.type().equals("short") || this.type().equals("long") || this.type().equals("long long")) {
                this.value(b.add(one).multiply(negOne));
            } else if (this.type().equals("unsigned short")) {
                this.value(twoPow16.subtract(one).subtract(b));
            } else if (this.type().equals("unsigned long")) {
                this.value(twoPow32.subtract(one).subtract(b));
            } else if (this.type().equals("unsigned long long")) {
                this.value(twoPow64.subtract(one).subtract(b));
            } else {
                this.value(b.not());
            }
        }
        catch (ClassCastException e) {
            String[] parameters = new String[]{Util.getMessage("EvaluationException.not"), this.operand().value().getClass().getName()};
            throw new EvaluationException(Util.getMessage("EvaluationException.2", parameters));
        }
        return this.value();
    }
}

