/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.ee.idl.constExpr;

import com.sun.tools.corba.ee.idl.Util;
import com.sun.tools.corba.ee.idl.constExpr.BinaryExpr;
import com.sun.tools.corba.ee.idl.constExpr.EvaluationException;
import com.sun.tools.corba.ee.idl.constExpr.Expression;
import java.math.BigInteger;

public class Plus
extends BinaryExpr {
    protected Plus(Expression leftOperand, Expression rightOperand) {
        super("+", leftOperand, rightOperand);
    }

    @Override
    public Object evaluate() throws EvaluationException {
        try {
            boolean rIsNonInteger;
            Number l = (Number)this.left().evaluate();
            Number r = (Number)this.right().evaluate();
            boolean lIsNonInteger = l instanceof Float || l instanceof Double;
            boolean bl = rIsNonInteger = r instanceof Float || r instanceof Double;
            if (lIsNonInteger && rIsNonInteger) {
                this.value(new Double(l.doubleValue() + r.doubleValue()));
            } else {
                if (lIsNonInteger || rIsNonInteger) {
                    String[] parameters = new String[]{Util.getMessage("EvaluationException.plus"), this.left().value().getClass().getName(), this.right().value().getClass().getName()};
                    throw new EvaluationException(Util.getMessage("EvaluationException.1", parameters));
                }
                BigInteger tmpL = (BigInteger)l;
                BigInteger tmpR = (BigInteger)r;
                this.value(tmpL.add(tmpR));
            }
        }
        catch (ClassCastException e) {
            String[] parameters = new String[]{Util.getMessage("EvaluationException.plus"), this.left().value().getClass().getName(), this.right().value().getClass().getName()};
            throw new EvaluationException(Util.getMessage("EvaluationException.1", parameters));
        }
        return this.value();
    }
}

