/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.constraintvalidation;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintViolation;
import org.hibernate.validator.constraints.CompositionType;
import org.hibernate.validator.internal.engine.ValidationContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorContextImpl;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintViolationCreationContext;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ConstraintTree<A extends Annotation> {
    private static final Log log = LoggerFactory.make();
    private final ConstraintTree<?> parent;
    private final List<ConstraintTree<?>> children;
    private final ConstraintDescriptorImpl<A> descriptor;

    public ConstraintTree(ConstraintDescriptorImpl<A> descriptor) {
        this(descriptor, null);
    }

    private ConstraintTree(ConstraintDescriptorImpl<A> descriptor, ConstraintTree<?> parent) {
        this.parent = parent;
        this.descriptor = descriptor;
        Set<ConstraintDescriptorImpl<?>> composingConstraints = descriptor.getComposingConstraintImpls();
        this.children = CollectionHelper.newArrayList(composingConstraints.size());
        for (ConstraintDescriptorImpl<?> composingDescriptor : composingConstraints) {
            ConstraintTree<?> treeNode = this.createConstraintTree(composingDescriptor);
            this.children.add(treeNode);
        }
    }

    private <U extends Annotation> ConstraintTree<U> createConstraintTree(ConstraintDescriptorImpl<U> composingDescriptor) {
        return new ConstraintTree<U>(composingDescriptor, this);
    }

    public final List<ConstraintTree<?>> getChildren() {
        return this.children;
    }

    public final ConstraintDescriptorImpl<A> getDescriptor() {
        return this.descriptor;
    }

    public final <T> boolean validateConstraints(ValidationContext<T> executionContext, ValueContext<?, ?> valueContext) {
        HashSet<ConstraintViolation<T>> constraintViolations = CollectionHelper.newHashSet();
        this.validateConstraints(executionContext, valueContext, constraintViolations);
        if (!constraintViolations.isEmpty()) {
            executionContext.addConstraintFailures(constraintViolations);
            return false;
        }
        return true;
    }

    private <T, V> void validateConstraints(ValidationContext<T> executionContext, ValueContext<?, V> valueContext, Set<ConstraintViolation<T>> constraintViolations) {
        Set<ConstraintViolation<T>> localViolations;
        CompositionResult compositionResult = this.validateComposingConstraints(executionContext, valueContext, constraintViolations);
        if (this.mainConstraintNeedsEvaluation(executionContext, constraintViolations)) {
            ConstraintValidator validator;
            ConstraintValidatorContextImpl constraintValidatorContext;
            if (log.isTraceEnabled()) {
                log.tracef("Validating value %s against constraint defined by %s.", valueContext.getCurrentValidatedValue(), (Object)this.descriptor);
            }
            if ((localViolations = this.validateSingleConstraint(executionContext, valueContext, constraintValidatorContext = new ConstraintValidatorContextImpl(executionContext.getParameterNames(), valueContext.getPropertyPath(), this.descriptor), validator = executionContext.getConstraintValidatorManager().getInitializedValidator(valueContext.getTypeOfAnnotatedElement(), this.descriptor, executionContext.getConstraintValidatorFactory()))).isEmpty()) {
                compositionResult.setAtLeastOneTrue(true);
            } else {
                compositionResult.setAllTrue(false);
            }
        } else {
            localViolations = Collections.emptySet();
        }
        if (!this.passesCompositionTypeRequirement(constraintViolations, compositionResult)) {
            this.prepareFinalConstraintViolations(executionContext, valueContext, constraintViolations, localViolations);
        }
    }

    private <T> boolean mainConstraintNeedsEvaluation(ValidationContext<T> executionContext, Set<ConstraintViolation<T>> constraintViolations) {
        if (this.descriptor.getMatchingConstraintValidatorClasses().isEmpty()) {
            return false;
        }
        if (this.descriptor.isReportAsSingleViolation() && this.descriptor.getCompositionType() == CompositionType.AND && !constraintViolations.isEmpty()) {
            return false;
        }
        return !executionContext.isFailFastModeEnabled() || constraintViolations.isEmpty();
    }

    private <T> void prepareFinalConstraintViolations(ValidationContext<T> executionContext, ValueContext<?, ?> valueContext, Set<ConstraintViolation<T>> constraintViolations, Set<ConstraintViolation<T>> localViolations) {
        if (this.reportAsSingleViolation()) {
            constraintViolations.clear();
            if (localViolations.isEmpty()) {
                String message = (String)this.getDescriptor().getAttributes().get("message");
                ConstraintViolationCreationContext constraintViolationCreationContext = new ConstraintViolationCreationContext(message, valueContext.getPropertyPath());
                ConstraintViolation<T> violation = executionContext.createConstraintViolation(valueContext, constraintViolationCreationContext, this.descriptor);
                constraintViolations.add(violation);
            }
        }
        constraintViolations.addAll(localViolations);
    }

    private <T> CompositionResult validateComposingConstraints(ValidationContext<T> executionContext, ValueContext<?, ?> valueContext, Set<ConstraintViolation<T>> constraintViolations) {
        CompositionResult compositionResult = new CompositionResult(true, false);
        for (ConstraintTree<?> tree : this.getChildren()) {
            HashSet<ConstraintViolation<T>> tmpViolations = CollectionHelper.newHashSet();
            super.validateConstraints(executionContext, valueContext, tmpViolations);
            constraintViolations.addAll(tmpViolations);
            if (tmpViolations.isEmpty()) {
                compositionResult.setAtLeastOneTrue(true);
                if (this.descriptor.getCompositionType() != CompositionType.OR) continue;
                break;
            }
            compositionResult.setAllTrue(false);
            if (this.descriptor.getCompositionType() != CompositionType.AND || !executionContext.isFailFastModeEnabled() && !this.descriptor.isReportAsSingleViolation()) continue;
            break;
        }
        return compositionResult;
    }

    private boolean passesCompositionTypeRequirement(Set<?> constraintViolations, CompositionResult compositionResult) {
        CompositionType compositionType = this.getDescriptor().getCompositionType();
        boolean passedValidation = false;
        switch (compositionType) {
            case OR: {
                passedValidation = compositionResult.isAtLeastOneTrue();
                break;
            }
            case AND: {
                passedValidation = compositionResult.isAllTrue();
                break;
            }
            case ALL_FALSE: {
                boolean bl = passedValidation = !compositionResult.isAtLeastOneTrue();
            }
        }
        assert (!passedValidation || compositionType != CompositionType.AND || constraintViolations.isEmpty());
        if (passedValidation) {
            constraintViolations.clear();
        }
        return passedValidation;
    }

    private <T, V> Set<ConstraintViolation<T>> validateSingleConstraint(ValidationContext<T> executionContext, ValueContext<?, ?> valueContext, ConstraintValidatorContextImpl constraintValidatorContext, ConstraintValidator<A, V> validator) {
        boolean isValid;
        try {
            Object validatedValue = valueContext.getCurrentValidatedValue();
            isValid = validator.isValid(validatedValue, constraintValidatorContext);
        }
        catch (RuntimeException e) {
            throw log.getExceptionDuringIsValidCallException(e);
        }
        if (!isValid) {
            return executionContext.createConstraintViolations(valueContext, constraintValidatorContext);
        }
        return Collections.emptySet();
    }

    private boolean reportAsSingleViolation() {
        return this.getDescriptor().isReportAsSingleViolation() || this.getDescriptor().getCompositionType() == CompositionType.ALL_FALSE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConstraintTree");
        sb.append("{ descriptor=").append(this.descriptor);
        sb.append(", isRoot=").append(this.parent == null);
        sb.append('}');
        return sb.toString();
    }

    private static final class CompositionResult {
        private boolean allTrue;
        private boolean atLeastOneTrue;

        CompositionResult(boolean allTrue, boolean atLeastOneTrue) {
            this.allTrue = allTrue;
            this.atLeastOneTrue = atLeastOneTrue;
        }

        public boolean isAllTrue() {
            return this.allTrue;
        }

        public boolean isAtLeastOneTrue() {
            return this.atLeastOneTrue;
        }

        public void setAllTrue(boolean allTrue) {
            this.allTrue = allTrue;
        }

        public void setAtLeastOneTrue(boolean atLeastOneTrue) {
            this.atLeastOneTrue = atLeastOneTrue;
        }
    }
}

