/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.spi;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.mvc.ErrorTemplate;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.internal.TemplateInflector;
import org.glassfish.jersey.spi.ExtendedExceptionMapper;

public abstract class AbstractErrorTemplateMapper<T extends Throwable>
implements ExtendedExceptionMapper<T> {
    @Inject
    private Provider<ExtendedUriInfo> uriInfoProvider;

    public final boolean isMappable(T throwable) {
        return this.getErrorTemplate() != null;
    }

    private ErrorTemplate getErrorTemplate() {
        ExtendedUriInfo uriInfo = (ExtendedUriInfo)this.uriInfoProvider.get();
        ResourceMethod matchedResourceMethod = uriInfo.getMatchedResourceMethod();
        if (matchedResourceMethod != null) {
            Invocable invocable = matchedResourceMethod.getInvocable();
            ErrorTemplate errorTemplate = invocable.getHandlingMethod().getAnnotation(ErrorTemplate.class);
            if (errorTemplate == null) {
                Class<?> handlerClass = invocable.getHandler().getHandlerClass();
                if (invocable.isInflector() && TemplateInflector.class.isAssignableFrom(invocable.getHandler().getHandlerClass())) {
                    handlerClass = ((TemplateInflector)invocable.getHandler().getInstance(null)).getModelClass();
                }
                errorTemplate = handlerClass.getAnnotation(ErrorTemplate.class);
            }
            return errorTemplate;
        }
        return null;
    }

    public final Response toResponse(T throwable) {
        ErrorTemplate error = this.getErrorTemplate();
        Class<?> resolvingClass = error.resolvingClass() == Object.class ? null : error.resolvingClass();
        String templateName = "".equals(error.name()) ? "index" : error.name();
        return Response.status((Response.Status)this.getErrorStatus(throwable)).entity((Object)new Viewable(templateName, this.getErrorModel(throwable), resolvingClass)).build();
    }

    protected Object getErrorModel(T throwable) {
        return throwable;
    }

    protected Response.Status getErrorStatus(T throwable) {
        return Response.Status.OK;
    }
}

