/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote;

import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.admin.util.AuthenticationInfo;
import com.sun.enterprise.admin.util.HttpConnectorAddress;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.SecureAdminInternalUser;
import com.sun.enterprise.security.ssl.SSLUtils;
import java.net.URLConnection;
import java.util.logging.Logger;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.security.common.MasterPassword;
import org.jvnet.hk2.component.Habitat;

public class ServerRemoteAdminCommand
extends RemoteAdminCommand {
    private static final String SSL_SOCKET_PROTOCOL = "TLS";
    private Habitat habitat;
    private SecureAdmin secureAdmin;
    private ServerEnvironment serverEnv;
    private SSLUtils _sslUtils = null;
    private MasterPassword masterPasswordHelper = null;

    public ServerRemoteAdminCommand(Habitat habitat, String name, String host, int port, boolean secure, String user, String password, Logger logger) throws CommandException {
        super(name, host, port, secure, "admin", "", logger);
        this.completeInit(habitat);
    }

    private void completeInit(Habitat habitat) {
        this.habitat = habitat;
        Domain domain = (Domain)habitat.getComponent(Domain.class);
        this.secureAdmin = domain.getSecureAdmin();
        this.serverEnv = (ServerEnvironment)habitat.getComponent(ServerEnvironment.class);
        this.secure = SecureAdmin.Util.isEnabled((SecureAdmin)this.secureAdmin);
        this.setInteractive(false);
    }

    protected synchronized HttpConnectorAddress getHttpConnectorAddress(String host, int port, boolean shouldUseSecure) {
        try {
            String certAlias = SecureAdmin.Util.isUsingUsernamePasswordAuth((SecureAdmin)this.secureAdmin) ? null : this.getCertAlias();
            return new HttpConnectorAddress(host, port, this.sslUtils().getAdminSocketFactory(certAlias, SSL_SOCKET_PROTOCOL));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected AuthenticationInfo authenticationInfo() {
        SecureAdminInternalUser secureAdminInternalUser;
        AuthenticationInfo result = null;
        if (SecureAdmin.Util.isUsingUsernamePasswordAuth((SecureAdmin)this.secureAdmin) && (secureAdminInternalUser = SecureAdmin.Util.secureAdminInternalUser((SecureAdmin)this.secureAdmin)) != null) {
            try {
                String pw = this.masterPassword().getMasterPasswordAdapter().getPasswordForAlias(secureAdminInternalUser.getPasswordAlias());
                result = new AuthenticationInfo(secureAdminInternalUser.getUsername(), pw);
                pw = null;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    protected void addAdditionalHeaders(URLConnection urlConnection) {
        String indicatorValue = SecureAdmin.Util.configuredAdminIndicator((SecureAdmin)this.secureAdmin);
        if (indicatorValue != null) {
            urlConnection.setRequestProperty("X-GlassFish-admin", indicatorValue);
        }
    }

    private String getCertAlias() {
        return this.serverEnv.isDas() ? SecureAdmin.Util.DASAlias((SecureAdmin)this.secureAdmin) : SecureAdmin.Util.instanceAlias((SecureAdmin)this.secureAdmin);
    }

    private synchronized SSLUtils sslUtils() {
        if (this._sslUtils == null) {
            this._sslUtils = (SSLUtils)this.habitat.getComponent(SSLUtils.class);
        }
        return this._sslUtils;
    }

    private synchronized MasterPassword masterPassword() {
        if (this.masterPasswordHelper == null) {
            this.masterPasswordHelper = (MasterPassword)this.habitat.getComponent(MasterPassword.class);
        }
        return this.masterPasswordHelper;
    }
}

