/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.reader;

import com.sun.enterprise.admin.remote.AdminCommandStateImpl;
import com.sun.enterprise.admin.remote.reader.ActionReportJsonReader;
import com.sun.enterprise.admin.remote.reader.CliActionReport;
import com.sun.enterprise.admin.util.AdminLoggerInfo;
import com.sun.enterprise.util.io.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.api.admin.AdminCommandState;

@Provider
@Consumes(value={"application/json"})
public class AdminCommandStateJsonReader
implements MessageBodyReader<AdminCommandState> {
    private static final JsonFactory factory = new JsonFactory();
    private static final Logger logger = AdminLoggerInfo.getLogger();

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isAssignableFrom(AdminCommandState.class);
    }

    public AdminCommandState readFrom(Class<AdminCommandState> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtils.copy((InputStream)entityStream, (OutputStream)baos, (long)0L);
        String str = baos.toString("UTF-8");
        try {
            JSONObject json = new JSONObject(str);
            return AdminCommandStateJsonReader.readAdminCommandState(json);
        }
        catch (JSONException ex) {
            logger.log(Level.SEVERE, "NCLS-ADMIN-0011", ex);
            throw new IOException(ex);
        }
    }

    public static AdminCommandStateImpl readAdminCommandState(JSONObject json) throws JSONException {
        String strState = json.optString("state");
        AdminCommandState.State state = strState == null ? null : AdminCommandState.State.valueOf((String)strState);
        boolean emptyPayload = json.optBoolean("empty-payload", true);
        CliActionReport ar = null;
        JSONObject jsonReport = json.optJSONObject("action-report");
        if (jsonReport != null) {
            ar = new CliActionReport();
            ActionReportJsonReader.fillActionReport(ar, jsonReport);
        }
        String id = json.optString("id");
        return new AdminCommandStateImpl(state, ar, emptyPayload, id);
    }
}

