/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.reader;

import com.sun.enterprise.admin.remote.reader.ProprietaryReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.glassfish.api.admin.progress.ProgressStatusEvent;
import org.glassfish.api.admin.progress.ProgressStatusEventComplete;
import org.glassfish.api.admin.progress.ProgressStatusEventCreateChild;
import org.glassfish.api.admin.progress.ProgressStatusEventProgress;
import org.glassfish.api.admin.progress.ProgressStatusEventSet;

public class ProgressStatusEventJsonProprietaryReader
implements ProprietaryReader<ProgressStatusEvent> {
    private static final JsonFactory factory = new JsonFactory();

    @Override
    public boolean isReadable(Class<?> type, String mimetype) {
        return type.isAssignableFrom(ProgressStatusEvent.class);
    }

    public ProgressStatusEvent readFrom(HttpURLConnection urlConnection) throws IOException {
        return this.readFrom(urlConnection.getInputStream(), urlConnection.getContentType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgressStatusEvent readFrom(InputStream is, String contentType) throws IOException {
        JsonParser jp = factory.createJsonParser(is);
        try {
            JsonToken token = jp.nextToken();
            jp.nextToken();
            JsonToken token2 = jp.nextToken();
            if (token != JsonToken.START_OBJECT || token2 != JsonToken.START_OBJECT || !"progress-status-event".equals(jp.getCurrentName())) {
                throw new IOException("Not expected type (progress-status-event) but (" + jp.getCurrentName() + ")");
            }
            ProgressStatusEvent progressStatusEvent = ProgressStatusEventJsonProprietaryReader.readProgressStatusEvent(jp);
            return progressStatusEvent;
        }
        finally {
            jp.close();
        }
    }

    public static ProgressStatusEvent readProgressStatusEvent(JsonParser jp) throws IOException {
        String id = null;
        JsonToken token = null;
        ProgressStatusEventSet result = null;
        while ((token = jp.nextToken()) != JsonToken.END_OBJECT) {
            if (token == JsonToken.START_OBJECT) {
                String nm = jp.getCurrentName();
                if ("set".equals(nm)) {
                    result = new ProgressStatusEventSet(id);
                    ProgressStatusEventJsonProprietaryReader.readToPSEventSet(result, jp);
                    continue;
                }
                if ("progres".equals(nm)) {
                    result = new ProgressStatusEventProgress(id);
                    ProgressStatusEventJsonProprietaryReader.readToPSEventProgress((ProgressStatusEventProgress)result, jp);
                    continue;
                }
                if ("complete".equals(nm)) {
                    result = new ProgressStatusEventComplete(id);
                    ProgressStatusEventJsonProprietaryReader.readToPSEventComplete((ProgressStatusEventComplete)result, jp);
                    continue;
                }
                if (!"create-child".equals(nm)) continue;
                result = new ProgressStatusEventCreateChild(id);
                ProgressStatusEventJsonProprietaryReader.readToPSEventCreateChild((ProgressStatusEventCreateChild)result, jp);
                continue;
            }
            String fieldname = jp.getCurrentName();
            if (!"id".equals(fieldname)) continue;
            jp.nextToken();
            id = jp.getText();
        }
        return result;
    }

    public static void readToPSEventSet(ProgressStatusEventSet event, JsonParser jp) throws IOException {
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = jp.getCurrentName();
            jp.nextToken();
            if ("total-step-count".equals(fieldname)) {
                event.setTotalStepCount(Integer.valueOf(jp.getIntValue()));
                continue;
            }
            if (!"current-step-count".equals(fieldname)) continue;
            event.setCurrentStepCount(Integer.valueOf(jp.getIntValue()));
        }
    }

    public static void readToPSEventProgress(ProgressStatusEventProgress event, JsonParser jp) throws IOException {
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = jp.getCurrentName();
            jp.nextToken();
            if ("steps".equals(fieldname)) {
                event.setSteps(jp.getIntValue());
                continue;
            }
            if ("message".equals(fieldname)) {
                event.setMessage(jp.getText());
                continue;
            }
            if (!"spinner".equals(fieldname)) continue;
            event.setSpinner(jp.getBooleanValue());
        }
    }

    public static void readToPSEventComplete(ProgressStatusEventComplete event, JsonParser jp) throws IOException {
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = jp.getCurrentName();
            jp.nextToken();
            if (!"message".equals(fieldname)) continue;
            event.setMessage(jp.getText());
        }
    }

    public static void readToPSEventCreateChild(ProgressStatusEventCreateChild event, JsonParser jp) throws IOException {
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = jp.getCurrentName();
            jp.nextToken();
            if ("id".equals(fieldname)) {
                event.setChildId(jp.getText());
                continue;
            }
            if ("allocated-steps".equals(fieldname)) {
                event.setAllocatedSteps(jp.getIntValue());
                continue;
            }
            if ("total-step-count".equals(fieldname)) {
                event.setTotalSteps(jp.getIntValue());
                continue;
            }
            if (!"name".equals(fieldname)) continue;
            event.setName(jp.getText());
        }
    }
}

