/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity;

import com.sun.enterprise.config.modularity.ConfigModularityUtils;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.DomainExtension;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.admin.config.ConfigExtension;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
public class GetSetModularityHelper {
    private static final Logger LOG = Logger.getLogger(GetSetModularityHelper.class.getName());
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private ConfigModularityUtils configModularityUtils;

    public boolean checkAttributePresence(Class classToQuery, String attributeName) {
        Method[] methods;
        String fieldName = this.convertAttributeToPropertyName(attributeName);
        String methodName = "set" + fieldName.replaceFirst(fieldName.substring(0, 1), String.valueOf(Character.toUpperCase(fieldName.charAt(0))));
        for (Method m : methods = classToQuery.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    private String convertAttributeToPropertyName(String attributeName) {
        StringTokenizer tokenizer = new StringTokenizer(attributeName, "-", false);
        StringBuilder propertyName = new StringBuilder();
        boolean isFirst = true;
        while (tokenizer.hasMoreTokens()) {
            String part = tokenizer.nextToken();
            if (!isFirst) {
                Locale loc = Locale.getDefault();
                part = part.replaceFirst(part.substring(0, 1), part.substring(0, 1).toUpperCase(loc));
            }
            isFirst = false;
            propertyName.append(part);
        }
        return propertyName.toString();
    }

    public boolean isConfigElementPresent(String serviceName, String target) {
        Config c;
        Class configBeanType = this.configModularityUtils.getClassFor(serviceName);
        Domain domain = (Domain)this.serviceLocator.getService(Domain.class, new Annotation[0]);
        return ConfigExtension.class.isAssignableFrom(configBeanType) ? (c = domain.getConfigNamed(target)).checkIfExtensionExists(configBeanType) : configBeanType.isAssignableFrom(DomainExtension.class) && domain.checkIfExtensionExists(configBeanType);
    }

    public void addBeanToDomainXml(String serviceName, String target) {
        Class configBeanType = this.configModularityUtils.getClassFor(serviceName);
        Domain domain = (Domain)this.serviceLocator.getService(Domain.class, new Annotation[0]);
        if (ConfigExtension.class.isAssignableFrom(configBeanType)) {
            Config c = domain.getConfigNamed(target);
            c.getExtensionByType(configBeanType);
        } else if (configBeanType.isAssignableFrom(DomainExtension.class)) {
            domain.getExtensionByType(configBeanType);
        }
    }
}

