/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity.parser;

import com.sun.enterprise.config.modularity.ConfigModularityUtils;
import com.sun.enterprise.config.modularity.annotation.HasNoDefaultConfiguration;
import com.sun.enterprise.config.modularity.customization.ConfigBeanDefaultValue;
import com.sun.enterprise.config.modularity.parser.ConfigurationParser;
import com.sun.enterprise.module.bootstrap.StartupContext;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.admin.config.ConfigExtension;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class ModuleConfigurationLoader<C extends ConfigBeanProxy, U extends ConfigBeanProxy> {
    private static final Logger LOG = Logger.getLogger(ModuleConfigurationLoader.class.getName());
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private ConfigurationParser configurationParser;
    @Inject
    private ConfigModularityUtils configModularityUtils;

    public <U extends ConfigBeanProxy> U createConfigBeanForType(Class<U> configExtensionType, C extensionOwner) throws TransactionFailure {
        if (this.configModularityUtils.hasCustomConfig(configExtensionType)) {
            this.addConfigBeanFor(configExtensionType);
        } else {
            if (configExtensionType.getAnnotation(HasNoDefaultConfiguration.class) != null) {
                return null;
            }
            final Class<U> childElement = configExtensionType;
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ConfigBeanProxy>(){

                public Object run(ConfigBeanProxy parent) throws PropertyVetoException, TransactionFailure {
                    ConfigBeanProxy child = parent.createChild(childElement);
                    Dom unwrappedChild = Dom.unwrap((ConfigBeanProxy)child);
                    boolean writeDefaultElementsToXml = Boolean.parseBoolean(System.getProperty("writeDefaultElementsToXml", "true"));
                    if (!writeDefaultElementsToXml) {
                        unwrappedChild.skipFromXml();
                    }
                    unwrappedChild.addDefaultChildren();
                    ModuleConfigurationLoader.this.configModularityUtils.getExtensions(parent).add(child);
                    return child;
                }
            }, extensionOwner);
        }
        List extensions = this.configModularityUtils.getExtensions((ConfigBeanProxy)extensionOwner);
        for (ConfigBeanProxy extension : extensions) {
            try {
                ConfigBeanProxy configBeanInstance = (ConfigBeanProxy)configExtensionType.cast(extension);
                if (configBeanInstance instanceof ConfigExtension) {
                    ServiceLocatorUtilities.addOneDescriptor((ServiceLocator)this.serviceLocator, (Descriptor)BuilderHelper.createConstantDescriptor((Object)configBeanInstance, (String)"default-instance-name", (Type[])new Type[]{ConfigSupport.getImpl((ConfigBeanProxy)configBeanInstance).getProxyType()}));
                }
                return (U)configBeanInstance;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    protected <U extends ConfigBeanProxy> void addConfigBeanFor(Class<U> extensionType) {
        StartupContext context = (StartupContext)this.serviceLocator.getService(StartupContext.class, new Annotation[0]);
        List<ConfigBeanDefaultValue> configBeanDefaultValueList = this.configModularityUtils.getDefaultConfigurations(extensionType, this.configModularityUtils.getRuntimeTypePrefix(context));
        this.configurationParser.parseAndSetConfigBean(configBeanDefaultValueList);
    }
}

