/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity;

import com.sun.enterprise.config.modularity.ConfigModularityUtils;
import com.sun.enterprise.config.modularity.RankedConfigBeanProxy;
import com.sun.enterprise.config.modularity.annotation.CustomConfiguration;
import com.sun.enterprise.config.modularity.customization.ConfigBeanDefaultValue;
import com.sun.enterprise.config.modularity.parser.ConfigurationParser;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.DomainExtension;
import com.sun.enterprise.module.bootstrap.StartupContext;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.admin.config.ConfigExtension;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
public class ConfigBeanInstaller
implements PostConstruct {
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    StartupContext startupContext;
    @Inject
    private ConfigurationParser configurationParser;
    @Inject
    private ConfigModularityUtils configModularityUtils;
    @Inject
    private Domain domain;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    private static final Logger LOG = Logger.getLogger(ConfigBeanInstaller.class.getName());

    public void postConstruct() {
        CustomConfiguration ann;
        Class<?> cbc = this.getClass().getDeclaringClass();
        if (cbc != null && (ann = cbc.getAnnotation(CustomConfiguration.class)) != null) {
            this.applyConfigIfNeeded(cbc);
        }
    }

    private void applyConfigIfNeeded(Class clz) {
        if (!RankedConfigBeanProxy.class.isAssignableFrom(clz)) {
            if (DomainExtension.class.isAssignableFrom(clz) && this.domain.getExtensionByType(clz) != null) {
                return;
            }
            if (ConfigExtension.class.isAssignableFrom(clz) && this.config.getExtensionByType(clz) != null) {
                return;
            }
        }
        List<ConfigBeanDefaultValue> configBeanDefaultValueList = this.configModularityUtils.getDefaultConfigurations(clz, this.configModularityUtils.getRuntimeTypePrefix(this.startupContext));
        this.configurationParser.parseAndSetConfigBean(configBeanDefaultValueList);
    }
}

