/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.util;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.util.PortUtils;
import com.sun.enterprise.config.util.ServerHelper;
import com.sun.enterprise.config.util.ServerPorts;
import com.sun.enterprise.config.util.Strings;
import com.sun.enterprise.util.net.NetUtils;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jvnet.hk2.config.TransactionFailure;

public final class PortManager {
    private final String serverName;
    private final Server newServer;
    private final boolean isLocal;
    private final Domain domain;
    private final String host;
    private final Set<Integer> allPorts;
    private final List<Server> allServers;
    private final List<ServerPorts> serversOnHost;
    private final ServerPorts newServerPorts;
    private static final int MAX_PORT_TRIES = 1100;

    public PortManager(Cluster cluster, Config config, Domain theDomain, Server theNewServer) throws TransactionFailure {
        try {
            if (theNewServer == null || theDomain == null) {
                throw new TransactionFailure(Strings.get("internal.error", "null argument in PortManager constructor"));
            }
            this.newServer = theNewServer;
            this.domain = theDomain;
            this.serverName = this.newServer.getName();
            this.host = new ServerHelper(theNewServer, config).getAdminHost();
            this.allPorts = new TreeSet<Integer>();
            this.newServerPorts = new ServerPorts(cluster, config, this.domain, this.newServer);
            this.isLocal = NetUtils.isThisHostLocal((String)this.host);
            this.allServers = this.domain.getServers().getServer();
            Iterator<Server> it = this.allServers.iterator();
            while (it.hasNext()) {
                Server curr = it.next();
                if (!this.serverName.equals(curr.getName())) continue;
                it.remove();
            }
            this.serversOnHost = new ArrayList<ServerPorts>();
        }
        catch (TransactionFailure tf) {
            throw tf;
        }
        catch (Exception e) {
            throw new TransactionFailure(e.toString(), (Throwable)e);
        }
    }

    public String process() throws TransactionFailure {
        try {
            if (this.newServerPorts.getMap().isEmpty()) {
                return null;
            }
            PortUtils.checkInternalConsistency(this.newServer);
            this.createServerList();
            this.populateAllPorts();
            Map<String, Integer> reassigned = this.reassignPorts();
            Set<Map.Entry<String, Integer>> entries = reassigned.entrySet();
            List<SystemProperty> sps = this.newServer.getSystemProperty();
            Map<String, Integer> finalPorts = this.newServerPorts.getMap();
            if (entries.size() > 0) {
                for (Map.Entry<String, Integer> entry : entries) {
                    String name = entry.getKey();
                    int port = entry.getValue();
                    this.changeSystemProperty(sps, name, "" + port);
                    finalPorts.put(name, port);
                }
            }
            return this.generateAssignedPortMessage(finalPorts);
        }
        catch (Exception e) {
            throw new TransactionFailure(e.toString(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PortManager Dump:");
        for (ServerPorts sp : this.serversOnHost) {
            sb.append(sp).append('\n');
        }
        sb.append("All Ports in all other servers on same host: " + this.allPorts);
        return sb.toString();
    }

    private String generateAssignedPortMessage(Map<String, Integer> ports) {
        try {
            Set<Map.Entry<String, Integer>> entries = ports.entrySet();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Integer> entry : entries) {
                String name = entry.getKey();
                int port = entry.getValue();
                sb.append("\n").append(name).append("=").append("" + port);
            }
            return Strings.get("PortManager.port.summary", this.serverName, sb.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void createServerList() {
        if (this.isLocal) {
            this.createLocalServerList();
        } else {
            this.createRemoteServerList();
        }
    }

    private void createLocalServerList() {
        for (Server server : this.allServers) {
            if (server.isDas()) {
                this.serversOnHost.add(new ServerPorts(this.domain, server));
                continue;
            }
            if (!NetUtils.isThisHostLocal((String)server.getAdminHost())) continue;
            this.serversOnHost.add(new ServerPorts(this.domain, server));
        }
    }

    private void createRemoteServerList() {
        for (Server server : this.allServers) {
            if (!server.isInstance() || !this.sameHost(server)) continue;
            this.serversOnHost.add(new ServerPorts(this.domain, server));
        }
    }

    private boolean sameHost(Server server) {
        return NetUtils.isEqual((String)server.getAdminHost(), (String)this.host);
    }

    private Map<String, Integer> reassignPorts() throws TransactionFailure {
        Map<String, Integer> portProps = this.newServerPorts.getMap();
        HashMap<String, Integer> changedPortProps = new HashMap<String, Integer>();
        Set<Map.Entry<String, Integer>> entries = portProps.entrySet();
        for (Map.Entry<String, Integer> entry : entries) {
            String name = entry.getKey();
            Integer num = entry.getValue();
            Integer newNum = this.reassignPort(num);
            if (newNum.equals(num)) continue;
            changedPortProps.put(name, newNum);
        }
        return changedPortProps;
    }

    private Integer reassignPort(Integer num) throws TransactionFailure {
        int max = num + 100;
        while (num < max) {
            if (this.isPortFree(num = this.getNextUnassignedPort(num))) {
                this.allPorts.add(num);
                return num;
            }
            num = num + 1;
        }
        throw new TransactionFailure(Strings.get("PortManager.noFreePort"));
    }

    private Integer getNextUnassignedPort(Integer num) throws TransactionFailure {
        int max = num + 1100;
        for (int inum = num.intValue(); inum < max; ++inum) {
            if (this.allPorts.contains(inum)) continue;
            return inum;
        }
        throw new TransactionFailure(Strings.get("PortManager.noFreePort", num, max));
    }

    private void changeSystemProperty(List<SystemProperty> sps, String name, String port) throws PropertyVetoException, TransactionFailure {
        for (SystemProperty sp : sps) {
            if (!name.equals(sp.getName())) continue;
            sp.setValue(port);
            return;
        }
        SystemProperty sp = (SystemProperty)this.newServer.createChild(SystemProperty.class);
        sp.setName(name);
        sp.setValue(port);
        sps.add(sp);
    }

    private boolean isPortFree(int num) {
        if (this.isLocal) {
            return NetUtils.isPortFree((int)num);
        }
        return NetUtils.isPortFree((String)this.host, (int)num);
    }

    private void populateAllPorts() {
        for (ServerPorts sp : this.serversOnHost) {
            this.allPorts.addAll(sp.getMap().values());
        }
    }
}

