/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CompletionHandler;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.CurrentTransaction;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.LogicErrorException;
import com.sun.jts.CosTransactions.TopCoordinator;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Unavailable;
import org.omg.CosTransactions.Vote;

class CoordinatorTerm
implements CompletionHandler {
    private CoordinatorImpl coordinator = null;
    private boolean subtransaction = false;
    private boolean aborted = false;
    private boolean heuristicDamage = false;
    private boolean completed = false;
    private boolean completing = false;
    static Logger _logger = LogDomains.getLogger(CoordinatorTerm.class, (String)"javax.enterprise.system.core.transaction");

    CoordinatorTerm() {
    }

    CoordinatorTerm(CoordinatorImpl coord, boolean subtran) {
        this.coordinator = coord;
        this.subtransaction = subtran;
        if (this.coordinator != null) {
            this.coordinator.setTerminator(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(boolean promptReturn) throws HeuristicMixed, HeuristicHazard, TRANSACTION_ROLLEDBACK, SystemException, LogicErrorException {
        Throwable otherExc;
        Throwable heuristicExc;
        Status status;
        RuntimeException rte;
        boolean sameCoordinator;
        ControlImpl current;
        block61: {
            boolean commit_one_phase_worked_ok;
            block60: {
                commit_one_phase_worked_ok = false;
                if (this.aborted) {
                    throw new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
                }
                if (this.coordinator == null) {
                    String msg = LogFormatter.getLocalizedMessage(_logger, "jts.no_coordinator_available");
                    LogicErrorException exc = new LogicErrorException(msg);
                    throw exc;
                }
                this.completing = true;
                current = CurrentTransaction.getCurrent();
                ControlImpl establishedControl = null;
                Coordinator currentCoord = null;
                sameCoordinator = false;
                if (current != null) {
                    try {
                        currentCoord = Configuration.isLocalFactory() ? current.get_localCoordinator() : current.get_coordinator();
                        sameCoordinator = this.coordinator.is_same_transaction(currentCoord);
                    }
                    catch (Unavailable exc) {
                        // empty catch block
                    }
                }
                rte = null;
                if (!this.subtransaction) {
                    try {
                        if (current == null || !sameCoordinator) {
                            establishedControl = new ControlImpl(null, this.coordinator, new GlobalTID(this.coordinator.getGlobalTID()), this.coordinator.getLocalTID());
                            CurrentTransaction.setCurrent(establishedControl, true);
                        }
                    }
                    catch (Throwable exc) {
                        // empty catch block
                    }
                    try {
                        ((TopCoordinator)this.coordinator).beforeCompletion();
                    }
                    catch (SystemException exc) {
                        this.completing = false;
                        throw exc;
                    }
                    catch (RuntimeException exc) {
                        rte = exc;
                    }
                    finally {
                        if (establishedControl != null) {
                            CurrentTransaction.endCurrent(true);
                            establishedControl.doFinalize();
                        }
                    }
                }
                status = Status.StatusCommitted;
                if (sameCoordinator) {
                    CurrentTransaction.endCurrent(true);
                }
                heuristicExc = null;
                otherExc = null;
                if (rte == null) {
                    try {
                        commit_one_phase_worked_ok = this.coordinator.commitOnePhase();
                    }
                    catch (Throwable exc) {
                        if (exc instanceof HeuristicHazard || exc instanceof HeuristicMixed) {
                            heuristicExc = exc;
                        } else if (exc instanceof TRANSACTION_ROLLEDBACK) {
                            status = Status.StatusRolledBack;
                        } else if (exc instanceof INVALID_TRANSACTION) {
                            throw (INVALID_TRANSACTION)exc;
                        }
                        if (!(exc instanceof INTERNAL)) break block60;
                        otherExc = exc;
                    }
                }
            }
            if (commit_one_phase_worked_ok) {
                status = Status.StatusCommitted;
            } else if (status != Status.StatusRolledBack) {
                Vote prepareResult = Vote.VoteRollback;
                if (rte == null) {
                    try {
                        prepareResult = this.coordinator.prepare();
                    }
                    catch (HeuristicHazard exc) {
                        heuristicExc = exc;
                    }
                    catch (HeuristicMixed exc) {
                        heuristicExc = exc;
                    }
                    catch (INVALID_TRANSACTION exc) {
                        otherExc = exc;
                    }
                    catch (INTERNAL exc) {
                        otherExc = exc;
                    }
                    catch (Throwable exc) {
                        // empty catch block
                    }
                }
                if (this.subtransaction) {
                    if (prepareResult == Vote.VoteCommit) {
                        try {
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.logp(Level.FINE, "CoordinatorTerm", "commit()", "Before invoking coordinator.commit() :GTID is: " + ((TopCoordinator)this.coordinator).superInfo.globalTID.toString());
                            }
                            this.coordinator.commit();
                        }
                        catch (NotPrepared exc) {
                            prepareResult = Vote.VoteRollback;
                        }
                    }
                    if (prepareResult == Vote.VoteRollback) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.logp(Level.FINE, "CoordinatorTerm", "commit()", "Before invoking coordinator.rollback :GTID is : " + ((TopCoordinator)this.coordinator).superInfo.globalTID.toString());
                        }
                        this.coordinator.rollback(true);
                        status = Status.StatusRolledBack;
                    }
                } else {
                    try {
                        if (prepareResult == Vote.VoteCommit) {
                            try {
                                this.coordinator.commit();
                            }
                            catch (NotPrepared exc) {
                                prepareResult = Vote.VoteRollback;
                            }
                        }
                        if (prepareResult == Vote.VoteRollback && heuristicExc == null) {
                            status = Status.StatusRolledBack;
                            this.coordinator.rollback(true);
                        }
                    }
                    catch (Throwable exc) {
                        if (exc instanceof HeuristicHazard || exc instanceof HeuristicMixed) {
                            heuristicExc = exc;
                        }
                        if (!(exc instanceof INTERNAL)) break block61;
                        otherExc = exc;
                    }
                }
            }
        }
        if (!this.subtransaction) {
            ((TopCoordinator)this.coordinator).afterCompletion(status);
        }
        this.completed = true;
        if (current != null && sameCoordinator) {
            current.setTranState(status);
        }
        if (heuristicExc != null) {
            if (heuristicExc instanceof HeuristicMixed) {
                throw (HeuristicMixed)heuristicExc;
            }
            throw (HeuristicHazard)heuristicExc;
        }
        if (otherExc != null) {
            if (otherExc instanceof INVALID_TRANSACTION) {
                throw (INVALID_TRANSACTION)otherExc;
            }
            if (otherExc instanceof INTERNAL) {
                throw (INTERNAL)otherExc;
            }
        }
        if (status == Status.StatusRolledBack) {
            TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_YES);
            if (rte != null) {
                exc.initCause((Throwable)rte);
            }
            throw exc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback() throws HeuristicMixed, HeuristicHazard, SystemException, LogicErrorException {
        if (this.aborted) {
            TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (this.coordinator == null) {
            String msg = LogFormatter.getLocalizedMessage(_logger, "jts.no_coordinator_available");
            LogicErrorException exc = new LogicErrorException(msg);
            throw exc;
        }
        Coordinator currentCoord = null;
        ControlImpl current = null;
        this.completing = true;
        try {
            current = CurrentTransaction.getCurrent();
        }
        catch (Throwable exc) {
            // empty catch block
        }
        if (current != null) {
            try {
                currentCoord = Configuration.isLocalFactory() ? current.get_localCoordinator() : current.get_coordinator();
                if (this.coordinator.is_same_transaction(currentCoord)) {
                    CurrentTransaction.endCurrent(true);
                }
            }
            catch (Throwable exc) {
                CurrentTransaction.endCurrent(true);
            }
        }
        Throwable heuristicExc = null;
        try {
            this.coordinator.rollback(true);
        }
        catch (Throwable exc) {
            if (exc instanceof HeuristicHazard || exc instanceof HeuristicMixed) {
                heuristicExc = exc;
            }
            if (exc instanceof INTERNAL) {
                throw (INTERNAL)exc;
            }
        }
        finally {
            if (!this.subtransaction) {
                ((TopCoordinator)this.coordinator).afterCompletion(Status.StatusRolledBack);
            }
        }
        this.completed = true;
        if (current != null) {
            current.setTranState(Status.StatusRolledBack);
        }
        if (heuristicExc != null) {
            if (heuristicExc instanceof HeuristicMixed) {
                throw (HeuristicMixed)heuristicExc;
            }
            throw (HeuristicHazard)heuristicExc;
        }
    }

    public void setCompleted(boolean aborted, boolean heuristicDamage) {
        if (!this.completing) {
            this.completed = true;
            this.aborted = aborted;
            this.heuristicDamage = heuristicDamage;
            if (this.coordinator != null && !this.subtransaction) {
                ((TopCoordinator)this.coordinator).afterCompletion(Status.StatusRolledBack);
            }
        }
    }

    void dump() {
    }
}

