/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.web;

import com.sun.enterprise.deploy.shared.AbstractArchiveHandler;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.directory.DirContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.naming.resources.FileDirContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.web.loader.WebappClassLoader;
import org.jvnet.hk2.annotations.Service;

@Service(name="war")
public class WarHandler
extends AbstractArchiveHandler {
    @Inject
    @Named(value="war")
    ArchiveDetector detector;
    private static final String GLASSFISH_WEB_XML = "WEB-INF/glassfish-web.xml";
    private static final String SUN_WEB_XML = "WEB-INF/sun-web.xml";
    private static final String WEBLOGIC_XML = "WEB-INF/weblogic.xml";
    private static final Logger logger = LogDomains.getLogger(WarHandler.class, (String)"javax.enterprise.system.container.web");
    private static final ResourceBundle rb = logger.getResourceBundle();

    public String getArchiveType() {
        return "war";
    }

    public String getVersionIdentifier(ReadableArchive archive) {
        String versionIdentifierValue = null;
        try {
            GlassFishWebXmlParser gfWebXMLParser = new GlassFishWebXmlParser(null);
            versionIdentifierValue = gfWebXMLParser.extractVersionIdentifierValue(archive);
        }
        catch (XMLStreamException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        return versionIdentifierValue;
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        return this.detector.handles(archive);
    }

    public ClassLoader getClassLoader(final ClassLoader parent, DeploymentContext context) {
        WebappClassLoader cloader;
        block9: {
            cloader = AccessController.doPrivileged(new PrivilegedAction<WebappClassLoader>(){

                @Override
                public WebappClassLoader run() {
                    return new WebappClassLoader(parent);
                }
            });
            try {
                FileDirContext r = new FileDirContext();
                File base = new File(context.getSource().getURI());
                r.setDocBase(base.getAbsolutePath());
                cloader.setResources((DirContext)r);
                cloader.addRepository("WEB-INF/classes/", new File(base, "WEB-INF/classes/"));
                if (context.getScratchDir("ejb") != null) {
                    cloader.addRepository(context.getScratchDir("ejb").toURI().toURL().toString().concat("/"));
                }
                if (context.getScratchDir("jsp") != null) {
                    cloader.setWorkDir(context.getScratchDir("jsp"));
                }
                for (URL url : this.getManifestLibraries(context)) {
                    cloader.addRepository(url.toString());
                }
                WebXmlParser webXmlParser = null;
                webXmlParser = new File(base, GLASSFISH_WEB_XML).exists() ? new GlassFishWebXmlParser(base.getAbsolutePath()) : (new File(base, SUN_WEB_XML).exists() ? new SunWebXmlParser(base.getAbsolutePath()) : (new File(base, WEBLOGIC_XML).exists() ? new WeblogicXmlParser(base.getAbsolutePath()) : new GlassFishWebXmlParser(base.getAbsolutePath())));
                this.configureLoaderAttributes(cloader, webXmlParser, base);
                this.configureLoaderProperties(cloader, webXmlParser, base);
            }
            catch (MalformedURLException malex) {
                logger.log(Level.SEVERE, malex.getMessage());
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, malex.getMessage(), malex);
                }
            }
            catch (XMLStreamException xse) {
                logger.log(Level.SEVERE, xse.getMessage());
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, xse.getMessage(), xse);
                }
            }
            catch (FileNotFoundException fnfe) {
                logger.log(Level.SEVERE, fnfe.getMessage());
                if (!logger.isLoggable(Level.FINE)) break block9;
                logger.log(Level.FINE, fnfe.getMessage(), fnfe);
            }
        }
        cloader.start();
        return cloader;
    }

    protected void configureLoaderAttributes(WebappClassLoader cloader, WebXmlParser webXmlParser, File base) {
        String[] pathElements;
        String extraClassPath;
        boolean delegate = webXmlParser.isDelegate();
        cloader.setDelegate(delegate);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("WebModule[" + webXmlParser.getBase() + "]: Setting delegate to " + delegate);
        }
        if ((extraClassPath = webXmlParser.getExtraClassPath()) != null && (pathElements = extraClassPath.split(";|((?<!\\\\):)")) != null) {
            for (String path : pathElements) {
                path = path.replace("\\:", ":");
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("WarHandler[" + webXmlParser.getBase() + "]: Adding " + path + " to the classpath");
                }
                try {
                    URL url = new URL(path);
                    cloader.addRepository(path);
                }
                catch (MalformedURLException mue1) {
                    File file = new File(path);
                    if (!file.isAbsolute()) {
                        file = new File(base.getPath(), path);
                    }
                    try {
                        URL url = file.toURI().toURL();
                        cloader.addRepository(url.toString());
                    }
                    catch (MalformedURLException mue2) {
                        String msg = rb.getString("webcontainer.classpathError");
                        Object[] params = new Object[]{path};
                        msg = MessageFormat.format(msg, params);
                        logger.log(Level.SEVERE, msg, mue2);
                    }
                }
            }
        }
    }

    protected void configureLoaderProperties(WebappClassLoader cloader, WebXmlParser webXmlParser, File base) {
        cloader.setUseMyFaces(webXmlParser.isUseBundledJSF());
        File libDir = new File(base, "WEB-INF/lib");
        if (libDir.exists()) {
            int baseFileLen = base.getPath().length();
            final boolean ignoreHiddenJarFiles = webXmlParser.isIgnoreHiddenJarFiles();
            for (File file : libDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    String fileName = pathname.getName();
                    return !(!fileName.endsWith(".jar") && !fileName.endsWith(".zip") || ignoreHiddenJarFiles && fileName.startsWith("."));
                }
            })) {
                try {
                    if (file.isDirectory()) {
                        cloader.addRepository("WEB-INF/lib/" + file.getName() + "/", file);
                        continue;
                    }
                    cloader.addJar(file.getPath().substring(baseFileLen), new JarFile(file), file);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    protected class WeblogicXmlParser
    extends WebXmlParser {
        WeblogicXmlParser(String baseStr) throws XMLStreamException, FileNotFoundException {
            super(baseStr);
        }

        protected String getXmlFileName() {
            return WarHandler.WEBLOGIC_XML;
        }

        protected void read(InputStream input) throws XMLStreamException {
            this.parser = WarHandler.getXMLInputFactory().createXMLStreamReader(input);
            this.skipRoot("weblogic-web-app");
            int event = 0;
            while (this.parser.hasNext() && (event = this.parser.next()) != 8) {
                if (event != 1) continue;
                String name = this.parser.getLocalName();
                if ("prefer-web-inf-classes".equals(name)) {
                    this.delegate = !Boolean.parseBoolean(this.parser.getElementText());
                    break;
                }
                if ("container-descriptor".equals(name)) continue;
                this.skipSubTree(name);
            }
        }
    }

    protected class GlassFishWebXmlParser
    extends SunWebXmlParser {
        GlassFishWebXmlParser(String baseStr) throws XMLStreamException, FileNotFoundException {
            super(baseStr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String extractVersionIdentifierValue(ReadableArchive archive) throws XMLStreamException, IOException {
            InputStream input = null;
            String versionIdentifierValue = null;
            try {
                input = archive.getEntry(this.getXmlFileName());
                if (input != null) {
                    this.parser = WarHandler.getXMLInputFactory().createXMLStreamReader(input);
                    int event = 0;
                    this.skipRoot(this.getRootElementName());
                    while (this.parser.hasNext() && (event = this.parser.next()) != 8) {
                        if (event != 1) continue;
                        String name = this.parser.getLocalName();
                        if ("version-identifier".equals(name)) {
                            versionIdentifierValue = this.parser.getElementText();
                            continue;
                        }
                        this.skipSubTree(name);
                    }
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception e) {}
                }
            }
            return versionIdentifierValue;
        }

        protected String getXmlFileName() {
            return WarHandler.GLASSFISH_WEB_XML;
        }

        protected String getRootElementName() {
            return "glassfish-web-app";
        }
    }

    protected class SunWebXmlParser
    extends WebXmlParser {
        SunWebXmlParser(String baseStr) throws XMLStreamException, FileNotFoundException {
            super(baseStr);
        }

        protected String getXmlFileName() {
            return WarHandler.SUN_WEB_XML;
        }

        protected String getRootElementName() {
            return "sun-web-app";
        }

        protected void read(InputStream input) throws XMLStreamException {
            this.parser = WarHandler.getXMLInputFactory().createXMLStreamReader(input);
            int event = 0;
            boolean inClassLoader = false;
            this.skipRoot(this.getRootElementName());
            while (this.parser.hasNext() && (event = this.parser.next()) != 8) {
                if (event == 1) {
                    String attrName;
                    int i;
                    String value;
                    int count;
                    String name = this.parser.getLocalName();
                    if ("class-loader".equals(name)) {
                        count = this.parser.getAttributeCount();
                        for (int i2 = 0; i2 < count; ++i2) {
                            String attrName2 = this.parser.getAttributeName(i2).getLocalPart();
                            if ("delegate".equals(attrName2)) {
                                this.delegate = Boolean.valueOf(this.parser.getAttributeValue(i2));
                                continue;
                            }
                            if ("extra-class-path".equals(attrName2)) {
                                this.extraClassPath = this.parser.getAttributeValue(i2);
                                continue;
                            }
                            if (!"dynamic-reload-interval".equals(attrName2) || this.parser.getAttributeValue(i2) == null || !logger.isLoggable(Level.WARNING)) continue;
                            logger.log(Level.WARNING, "webcontainer.dynamicReloadInterval");
                        }
                        inClassLoader = true;
                        continue;
                    }
                    if (inClassLoader && "property".equals(name)) {
                        count = this.parser.getAttributeCount();
                        String propName = null;
                        value = null;
                        for (i = 0; i < count; ++i) {
                            attrName = this.parser.getAttributeName(i).getLocalPart();
                            if ("name".equals(attrName)) {
                                propName = this.parser.getAttributeValue(i);
                                continue;
                            }
                            if (!"value".equals(attrName)) continue;
                            value = this.parser.getAttributeValue(i);
                        }
                        if (propName == null || value == null) {
                            throw new IllegalArgumentException(rb.getString("webcontainer.nullWebProperty"));
                        }
                        if ("ignoreHiddenJarFiles".equals(propName)) {
                            this.ignoreHiddenJarFiles = Boolean.valueOf(value);
                            continue;
                        }
                        Object[] params = new Object[]{propName, value};
                        if (!logger.isLoggable(Level.WARNING)) continue;
                        logger.log(Level.WARNING, "webcontainer.invalidProperty", params);
                        continue;
                    }
                    if ("property".equals(name)) {
                        count = this.parser.getAttributeCount();
                        String propName = null;
                        value = null;
                        for (i = 0; i < count; ++i) {
                            attrName = this.parser.getAttributeName(i).getLocalPart();
                            if ("name".equals(attrName)) {
                                propName = this.parser.getAttributeValue(i);
                                continue;
                            }
                            if (!"value".equals(attrName)) continue;
                            value = this.parser.getAttributeValue(i);
                        }
                        if (propName == null || value == null) {
                            throw new IllegalArgumentException(rb.getString("webcontainer.nullWebProperty"));
                        }
                        if ("useMyFaces".equalsIgnoreCase(propName)) {
                            this.useBundledJSF = Boolean.valueOf(value);
                            continue;
                        }
                        if (!"useBundledJsf".equalsIgnoreCase(propName)) continue;
                        this.useBundledJSF = Boolean.valueOf(value);
                        continue;
                    }
                    this.skipSubTree(name);
                    continue;
                }
                if (!inClassLoader || event != 2 || !"class-loader".equals(this.parser.getLocalName())) continue;
                inClassLoader = false;
            }
        }
    }

    protected abstract class WebXmlParser {
        protected String baseStr = null;
        protected XMLStreamReader parser = null;
        protected boolean delegate = true;
        protected boolean ignoreHiddenJarFiles = false;
        protected boolean useBundledJSF = false;
        protected String extraClassPath = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WebXmlParser(String baseStr) throws XMLStreamException, FileNotFoundException {
            this.baseStr = baseStr;
            FileInputStream input = null;
            File f = new File(baseStr, this.getXmlFileName());
            if (f.exists()) {
                input = new FileInputStream(f);
                try {
                    this.read(input);
                }
                finally {
                    if (this.parser != null) {
                        try {
                            this.parser.close();
                        }
                        catch (Exception ex) {}
                    }
                    if (input != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (Exception ex) {}
                    }
                }
            }
        }

        protected abstract String getXmlFileName();

        protected abstract void read(InputStream var1) throws XMLStreamException;

        protected void skipRoot(String name) throws XMLStreamException {
            int event;
            while ((event = this.parser.next()) != 1) {
            }
            String localName = this.parser.getLocalName();
            if (!name.equals(localName)) {
                String msg = rb.getString("webcontainer.unexpectedXmlElement");
                msg = MessageFormat.format(msg, name, localName);
                throw new XMLStreamException(msg);
            }
        }

        protected void skipSubTree(String name) throws XMLStreamException {
            int event;
            do {
                if ((event = this.parser.next()) != 8) continue;
                throw new XMLStreamException(rb.getString("webcontainer.unexpectedEndDocument"));
            } while (event != 2 || !name.equals(this.parser.getLocalName()));
        }

        String getBase() {
            return this.baseStr;
        }

        boolean isDelegate() {
            return this.delegate;
        }

        boolean isIgnoreHiddenJarFiles() {
            return this.ignoreHiddenJarFiles;
        }

        String getExtraClassPath() {
            return this.extraClassPath;
        }

        boolean isUseBundledJSF() {
            return this.useBundledJSF;
        }
    }
}

