/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.naming.NameParserImpl;
import org.apache.naming.StringManager;

public abstract class BaseDirContext
implements DirContext {
    protected int debug = 0;
    protected String docBase = null;
    protected Hashtable<String, Object> env;
    protected static final StringManager sm = StringManager.getManager("org.apache.naming.resources");
    protected boolean cached = true;
    protected int cacheTTL = 5000;
    protected int cacheMaxSize = 10240;

    public BaseDirContext() {
        this.env = new Hashtable();
    }

    public BaseDirContext(Hashtable<String, Object> env) {
        this.env = env;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getDocBase() {
        return this.docBase;
    }

    public void setDocBase(String docBase) {
        if (docBase == null) {
            throw new IllegalArgumentException(sm.getString("resources.null"));
        }
        this.docBase = docBase;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCacheTTL(int cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public int getCacheTTL() {
        return this.cacheTTL;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public void allocate() {
    }

    public void release() {
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public abstract Object lookup(String var1) throws NamingException;

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(name, obj, null);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(name, obj, null);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public abstract void unbind(String var1) throws NamingException;

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    @Override
    public abstract void rename(String var1, String var2) throws NamingException;

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public abstract NamingEnumeration<NameClassPair> list(String var1) throws NamingException;

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public abstract NamingEnumeration<Binding> listBindings(String var1) throws NamingException;

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public abstract void destroySubcontext(String var1) throws NamingException;

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(name, null);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public abstract Object lookupLink(String var1) throws NamingException;

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return new NameParserImpl();
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return new NameParserImpl();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        prefix = (Name)prefix.clone();
        return prefix.addAll(name);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return prefix + "/" + name;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    public Hashtable<String, Object> getEnvironment() throws NamingException {
        return this.env;
    }

    @Override
    public void close() throws NamingException {
        this.env.clear();
    }

    @Override
    public abstract String getNameInNamespace() throws NamingException;

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes(name, null);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.getAttributes(name.toString(), attrIds);
    }

    @Override
    public abstract Attributes getAttributes(String var1, String[] var2) throws NamingException;

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        this.modifyAttributes(name.toString(), mod_op, attrs);
    }

    @Override
    public abstract void modifyAttributes(String var1, int var2, Attributes var3) throws NamingException;

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes(name.toString(), mods);
    }

    @Override
    public abstract void modifyAttributes(String var1, ModificationItem[] var2) throws NamingException;

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.bind(name.toString(), obj, attrs);
    }

    @Override
    public abstract void bind(String var1, Object var2, Attributes var3) throws NamingException;

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.rebind(name.toString(), obj, attrs);
    }

    @Override
    public abstract void rebind(String var1, Object var2, Attributes var3) throws NamingException;

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return this.createSubcontext(name.toString(), attrs);
    }

    @Override
    public abstract DirContext createSubcontext(String var1, Attributes var2) throws NamingException;

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        return this.getSchema(name.toString());
    }

    @Override
    public abstract DirContext getSchema(String var1) throws NamingException;

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return this.getSchemaClassDefinition(name.toString());
    }

    @Override
    public abstract DirContext getSchemaClassDefinition(String var1) throws NamingException;

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.search(name.toString(), matchingAttributes, attributesToReturn);
    }

    @Override
    public abstract NamingEnumeration<SearchResult> search(String var1, Attributes var2, String[] var3) throws NamingException;

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.search(name.toString(), matchingAttributes);
    }

    @Override
    public abstract NamingEnumeration<SearchResult> search(String var1, Attributes var2) throws NamingException;

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        return this.search(name.toString(), filter, cons);
    }

    @Override
    public abstract NamingEnumeration<SearchResult> search(String var1, String var2, SearchControls var3) throws NamingException;

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search(name.toString(), filterExpr, filterArgs, cons);
    }

    @Override
    public abstract NamingEnumeration<SearchResult> search(String var1, String var2, Object[] var3, SearchControls var4) throws NamingException;
}

