/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.AnalysisPolicy;
import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ClassInclusionPolicy;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.reports.StatisticsPrinter;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.common.meta.MultiMethod;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.DeoptBciSupplier;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.printer.GraalDebugHandlersFactory;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public abstract class AbstractAnalysisEngine
implements BigBang {
    protected final AnalysisUniverse universe;
    protected final AnalysisMetaAccess metaAccess;
    protected final AnalysisPolicy analysisPolicy;
    protected final int maxConstantObjectsPerType;
    protected final boolean profileConstantObjects;
    protected final boolean optimizeReturnedParameter;
    protected final OptionValues options;
    protected final DebugContext debug;
    private final List<DebugHandlersFactory> debugHandlerFactories;
    protected final HostVM hostVM;
    protected final UnsupportedFeatures unsupportedFeatures;
    private final SnippetReflectionProvider snippetReflectionProvider;
    private final ConstantReflectionProvider constantReflectionProvider;
    private final WordTypes wordTypes;
    protected final CompletionExecutor executor;
    protected final Timer processFeaturesTimer;
    protected final Timer analysisTimer;
    protected final Timer verifyHeapTimer;
    protected final ClassInclusionPolicy classInclusionPolicy;

    public AbstractAnalysisEngine(OptionValues options, AnalysisUniverse universe, HostVM hostVM, AnalysisMetaAccess metaAccess, SnippetReflectionProvider snippetReflectionProvider, ConstantReflectionProvider constantReflectionProvider, WordTypes wordTypes, UnsupportedFeatures unsupportedFeatures, DebugContext debugContext, TimerCollection timerCollection, ClassInclusionPolicy classInclusionPolicy) {
        this.options = options;
        this.universe = universe;
        this.debugHandlerFactories = Collections.singletonList(new GraalDebugHandlersFactory(snippetReflectionProvider));
        this.debug = new DebugContext.Builder(options, this.debugHandlerFactories).build();
        this.metaAccess = metaAccess;
        this.analysisPolicy = universe.analysisPolicy();
        this.hostVM = hostVM;
        this.executor = new CompletionExecutor(debugContext, this);
        this.unsupportedFeatures = unsupportedFeatures;
        this.processFeaturesTimer = timerCollection.get(TimerCollection.Registry.FEATURES);
        this.verifyHeapTimer = timerCollection.get(TimerCollection.Registry.VERIFY_HEAP);
        this.analysisTimer = timerCollection.get(TimerCollection.Registry.ANALYSIS);
        this.maxConstantObjectsPerType = (Integer)PointstoOptions.MaxConstantObjectsPerType.getValue(options);
        this.profileConstantObjects = (Boolean)PointstoOptions.ProfileConstantObjects.getValue(options);
        this.optimizeReturnedParameter = (Boolean)PointstoOptions.OptimizeReturnedParameter.getValue(options);
        this.snippetReflectionProvider = snippetReflectionProvider;
        this.constantReflectionProvider = constantReflectionProvider;
        this.wordTypes = wordTypes;
        classInclusionPolicy.setBigBang(this);
        this.classInclusionPolicy = classInclusionPolicy;
    }

    @Override
    public void runAnalysis(DebugContext debugContext, Function<AnalysisUniverse, Boolean> analysisEndCondition) throws InterruptedException {
        int numIterations = 0;
        while (true) {
            Indent indent2 = debugContext.logAndIndent("new analysis iteration");
            try {
                boolean analysisChanged = this.finish();
                if (++numIterations > 1000) {
                    throw AnalysisError.shouldNotReachHere(String.format("Static analysis did not reach a fix point after %d iterations because a Feature keeps requesting new analysis iterations. The analysis itself %s find a change in type states in the last iteration.", numIterations, analysisChanged ? "DID" : "DID NOT"));
                }
                int numTypes = this.universe.getTypes().size();
                int numMethods = this.universe.getMethods().size();
                int numFields = this.universe.getFields().size();
                if (!analysisEndCondition.apply(this.universe).booleanValue()) continue;
                if (numTypes != this.universe.getTypes().size() || numMethods != this.universe.getMethods().size() || numFields != this.universe.getFields().size()) {
                    throw AnalysisError.shouldNotReachHere("When a feature makes more types, methods, or fields reachable, it must require another analysis iteration via DuringAnalysisAccess.requireAnalysisIteration()");
                }
                boolean pendingOperations = this.executor.getPostedOperations() > 0L;
                if (pendingOperations || this.analysisModified()) continue;
                return;
            }
            finally {
                if (indent2 == null) continue;
                indent2.close();
                continue;
            }
            break;
        }
    }

    protected abstract CompletionExecutor.Timing getTiming();

    private boolean analysisModified() {
        boolean analysisModified;
        try (Timer.StopTimer ignored = this.verifyHeapTimer.start();){
            assert (this.executor.isBeforeStart()) : this.executor.getState();
            analysisModified = this.universe.getHeapVerifier().checkHeapSnapshot(this.metaAccess, this.executor, "during analysis", true, this.universe.getEmbeddedRoots());
        }
        this.executor.init(this.getTiming());
        return analysisModified;
    }

    @Override
    public void cleanupAfterAnalysis() {
        this.universe.getTypes().forEach(AnalysisType::cleanupAfterAnalysis);
        this.universe.getFields().forEach(AnalysisField::cleanupAfterAnalysis);
        this.universe.getMethods().forEach(AnalysisMethod::cleanupAfterAnalysis);
        this.universe.getHeapScanner().cleanupAfterAnalysis();
        this.universe.getHeapVerifier().cleanupAfterAnalysis();
    }

    @Override
    public void printTimerStatistics(PrintWriter out) {
        StatisticsPrinter.print(out, "features_time_ms", this.processFeaturesTimer.getTotalTime());
        StatisticsPrinter.print(out, "total_analysis_time_ms", this.analysisTimer.getTotalTime());
        StatisticsPrinter.printLast(out, "total_memory_bytes", this.analysisTimer.getTotalMemory());
    }

    public int maxConstantObjectsPerType() {
        return this.maxConstantObjectsPerType;
    }

    public boolean optimizeReturnedParameter() {
        return this.optimizeReturnedParameter;
    }

    public void profileConstantObject(AnalysisType type) {
        if (this.profileConstantObjects) {
            PointsToAnalysis.ConstantObjectsProfiler.registerConstant(type);
            PointsToAnalysis.ConstantObjectsProfiler.maybeDumpConstantHistogram();
        }
    }

    public boolean isBaseLayerAnalysisEnabled() {
        return this.classInclusionPolicy instanceof ClassInclusionPolicy.LayeredBaseImageInclusionPolicy;
    }

    @Override
    public OptionValues getOptions() {
        return this.options;
    }

    @Override
    public DebugContext getDebug() {
        return this.debug;
    }

    @Override
    public List<DebugHandlersFactory> getDebugHandlerFactories() {
        return this.debugHandlerFactories;
    }

    @Override
    public AnalysisPolicy analysisPolicy() {
        return this.universe.analysisPolicy();
    }

    @Override
    public AnalysisUniverse getUniverse() {
        return this.universe;
    }

    @Override
    public final HostedProviders getProviders(MultiMethod.MultiMethodKey key) {
        return this.getHostVM().getProviders(key);
    }

    @Override
    public AnalysisMetaAccess getMetaAccess() {
        return this.metaAccess;
    }

    @Override
    public UnsupportedFeatures getUnsupportedFeatures() {
        return this.unsupportedFeatures;
    }

    @Override
    public final SnippetReflectionProvider getSnippetReflectionProvider() {
        return this.snippetReflectionProvider;
    }

    @Override
    public final ConstantReflectionProvider getConstantReflectionProvider() {
        return this.constantReflectionProvider;
    }

    @Override
    public WordTypes getWordTypes() {
        return this.wordTypes;
    }

    @Override
    public HostVM getHostVM() {
        return this.hostVM;
    }

    protected void schedule(Runnable task) {
        this.executor.execute(d -> task.run());
    }

    @Override
    public final void postTask(CompletionExecutor.DebugContextRunnable task) {
        this.executor.execute(task);
    }

    public void postTask(final Runnable task) {
        this.executor.execute(new CompletionExecutor.DebugContextRunnable(){
            final /* synthetic */ AbstractAnalysisEngine this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(DebugContext ignore) {
                task.run();
            }

            @Override
            public DebugContext getDebug(OptionValues opts, List<DebugHandlersFactory> factories) {
                assert (opts == this.this$0.getOptions()) : String.valueOf(opts) + " != " + String.valueOf(this.this$0.getOptions());
                return DebugContext.disabled((OptionValues)opts);
            }
        });
    }

    @Override
    public final boolean executorIsStarted() {
        return this.executor.isStarted();
    }

    @Override
    public void registerTypeForBaseImage(Class<?> cls) {
        if (this.classInclusionPolicy.isClassIncluded(cls)) {
            this.classInclusionPolicy.includeClass(cls);
            Stream.concat(Arrays.stream(cls.getDeclaredConstructors()), Arrays.stream(cls.getDeclaredMethods())).filter(this.classInclusionPolicy::isMethodIncluded).forEach(this.classInclusionPolicy::includeMethod);
            Arrays.stream(cls.getDeclaredFields()).filter(this.classInclusionPolicy::isFieldIncluded).forEach(this.classInclusionPolicy::includeField);
        }
    }

    public static BytecodePosition sourcePosition(ValueNode node) {
        NodeSourcePosition position = node.getNodeSourcePosition();
        if (position == null) {
            position = AbstractAnalysisEngine.syntheticSourcePosition((Node)node, node.graph().method());
        }
        return position;
    }

    public static BytecodePosition syntheticSourcePosition(ResolvedJavaMethod method) {
        return AbstractAnalysisEngine.syntheticSourcePosition(null, method);
    }

    public static BytecodePosition syntheticSourcePosition(Node node, ResolvedJavaMethod method) {
        StateSplit stateSplit;
        FrameState frameState;
        int bci = -5;
        if (node instanceof DeoptBciSupplier) {
            bci = ((DeoptBciSupplier)node).bci();
        }
        if (node instanceof StateSplit && (frameState = (stateSplit = (StateSplit)node).stateAfter()) != null) {
            if (frameState.outerFrameState() != null) {
                FrameState current = frameState;
                while (current.outerFrameState() != null) {
                    current = current.outerFrameState();
                }
                assert (method.equals((Object)current.getMethod())) : String.valueOf(method) + " != " + String.valueOf(current.getMethod());
                bci = current.bci;
            } else if (bci == -5) {
                bci = frameState.bci;
            }
        }
        return new BytecodePosition(null, method, bci);
    }
}

