/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hikaricp.internal;

import com.zaxxer.hikari.HikariConfig;
import java.util.Map;
import java.util.Properties;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;

public class HikariConfigurationUtil {
    public static final String CONFIG_PREFIX = "hibernate.hikari.";

    public static HikariConfig loadConfiguration(Map<String, Object> props) {
        Properties hikariProps = new Properties();
        HikariConfigurationUtil.copyProperty("hibernate.connection.autocommit", props, "autoCommit", hikariProps);
        HikariConfigurationUtil.copyProperty(props, "driverClassName", hikariProps, "jakarta.persistence.jdbc.driver", "hibernate.connection.driver_class", "javax.persistence.jdbc.driver");
        HikariConfigurationUtil.copyProperty(props, "jdbcUrl", hikariProps, "jakarta.persistence.jdbc.url", "hibernate.connection.url", "javax.persistence.jdbc.url");
        HikariConfigurationUtil.copyProperty(props, "username", hikariProps, "jakarta.persistence.jdbc.user", "hibernate.connection.username", "javax.persistence.jdbc.user");
        HikariConfigurationUtil.copyProperty(props, "password", hikariProps, "jakarta.persistence.jdbc.password", "hibernate.connection.password", "javax.persistence.jdbc.password");
        HikariConfigurationUtil.copyIsolationSetting(props, hikariProps);
        for (String key : props.keySet()) {
            if (!key.startsWith(CONFIG_PREFIX)) continue;
            hikariProps.setProperty(key.substring(CONFIG_PREFIX.length()), (String)props.get(key));
        }
        return new HikariConfig(hikariProps);
    }

    private static void copyProperty(String srcKey, Map<String, Object> src, String dstKey, Properties dst) {
        if (src.containsKey(srcKey)) {
            dst.setProperty(dstKey, (String)src.get(srcKey));
        }
    }

    private static void copyProperty(Map<String, Object> src, String dstKey, Properties dst, String ... srcKeys) {
        ConnectionProviderInitiator.consumeSetting(src, (name, value) -> dst.setProperty(dstKey, value), (String[])srcKeys);
    }

    private static void copyIsolationSetting(Map<String, Object> props, Properties hikariProps) {
        Integer isolation = ConnectionProviderInitiator.extractIsolation(props);
        if (isolation != null) {
            hikariProps.put("transactionIsolation", ConnectionProviderInitiator.toIsolationConnectionConstantName((Integer)isolation));
        }
    }
}

