/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxool.internal;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.internal.DatabaseConnectionInfoImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.DatabaseConnectionInfo;
import org.hibernate.internal.log.ConnectionInfoLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.proxool.internal.ProxoolMessageLogger;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.configuration.JAXPConfigurator;
import org.logicalcobwebs.proxool.configuration.PropertyConfigurator;

public class ProxoolConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable,
ServiceRegistryAwareService {
    private static final String PROXOOL_JDBC_STEM = "proxool.";
    private String proxoolPoolAlias;
    private String proxoolAlias;
    private boolean existingPool;
    private Integer isolation;
    private boolean autocommit;
    private ClassLoaderService classLoaderService;

    public Connection getConnection() throws SQLException {
        Connection connection = DriverManager.getConnection(this.proxoolAlias);
        if (this.isolation != null) {
            connection.setTransactionIsolation(this.isolation);
        }
        if (connection.getAutoCommit() != this.autocommit) {
            connection.setAutoCommit(this.autocommit);
        }
        return connection;
    }

    public boolean isUnwrappableAs(Class<?> unwrapType) {
        return ConnectionProvider.class.equals(unwrapType) || ProxoolConnectionProvider.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || ProxoolConnectionProvider.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.classLoaderService = (ClassLoaderService)serviceRegistry.getService(ClassLoaderService.class);
    }

    public void configure(Map<String, Object> props) {
        ConnectionInfoLogger.INSTANCE.configureConnectionPool("Proxool");
        String jaxpFile = (String)props.get("hibernate.proxool.xml");
        String propFile = (String)props.get("hibernate.proxool.properties");
        String externalConfig = (String)props.get("hibernate.proxool.existing_pool");
        this.proxoolAlias = this.proxoolPoolAlias = (String)props.get("hibernate.proxool.pool_alias");
        if ("true".equals(externalConfig)) {
            if (!StringHelper.isNotEmpty((String)this.proxoolAlias)) {
                String msg = "Cannot configure Proxool Provider to use an existing in memory pool without the hibernate.proxool.pool_alias property set.";
                throw new HibernateException("Cannot configure Proxool Provider to use an existing in memory pool without the hibernate.proxool.pool_alias property set.");
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            this.existingPool = true;
            ProxoolMessageLogger.PROXOOL_MESSAGE_LOGGER.configuringProxoolProviderUsingExistingPool(this.proxoolAlias);
        } else if (StringHelper.isNotEmpty((String)jaxpFile)) {
            ProxoolMessageLogger.PROXOOL_MESSAGE_LOGGER.configuringProxoolProviderUsingJaxpConfigurator(jaxpFile);
            if (!StringHelper.isNotEmpty((String)this.proxoolAlias)) {
                String msg = "Cannot configure Proxool Provider to use JAXP without the hibernate.proxool.pool_alias property set.";
                throw new HibernateException("Cannot configure Proxool Provider to use JAXP without the hibernate.proxool.pool_alias property set.");
            }
            try {
                JAXPConfigurator.configure((Reader)this.getConfigStreamReader(jaxpFile), (boolean)false);
            }
            catch (ProxoolException e) {
                String msg = "Proxool Provider unable to load JAXP configurator file: " + jaxpFile;
                throw new HibernateException(msg, (Throwable)e);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            ProxoolMessageLogger.PROXOOL_MESSAGE_LOGGER.configuringProxoolProviderToUsePoolAlias(this.proxoolAlias);
        } else if (StringHelper.isNotEmpty((String)propFile)) {
            ProxoolMessageLogger.PROXOOL_MESSAGE_LOGGER.configuringProxoolProviderUsingPropertiesFile(propFile);
            if (!StringHelper.isNotEmpty((String)this.proxoolAlias)) {
                String msg = "Cannot configure Proxool Provider to use Properties File without the hibernate.proxool.pool_alias property set.";
                throw new HibernateException("Cannot configure Proxool Provider to use Properties File without the hibernate.proxool.pool_alias property set.");
            }
            try {
                PropertyConfigurator.configure((Properties)this.getConfigProperties(propFile));
            }
            catch (ProxoolException e) {
                String msg = "Proxool Provider unable to load Property configurator file: " + propFile;
                throw new HibernateException(msg, (Throwable)e);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            ProxoolMessageLogger.PROXOOL_MESSAGE_LOGGER.configuringProxoolProviderToUsePoolAlias(this.proxoolAlias);
        }
        this.isolation = ConnectionProviderInitiator.extractIsolation(props);
        this.autocommit = ConfigurationHelper.getBoolean((String)"hibernate.connection.autocommit", props);
    }

    private Reader getConfigStreamReader(String resource) {
        return new InputStreamReader(this.classLoaderService.locateResourceStream(resource));
    }

    private Properties getConfigProperties(String resource) {
        try {
            Properties properties = new Properties();
            properties.load(this.classLoaderService.locateResourceStream(resource));
            return properties;
        }
        catch (IOException e) {
            throw new HibernateException("Unable to load properties from specified config file: " + resource, (Throwable)e);
        }
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public void stop() {
        if (this.existingPool) {
            return;
        }
        ConnectionInfoLogger.INSTANCE.cleaningUpConnectionPool("proxool");
        try {
            if (ProxoolFacade.getAliases().length == 1) {
                ProxoolFacade.shutdown((int)0);
            } else {
                ProxoolFacade.removeConnectionPool((String)this.proxoolAlias.substring(PROXOOL_JDBC_STEM.length()));
            }
        }
        catch (Exception e) {
            ConnectionInfoLogger.INSTANCE.unableToDestroyConnectionPool(e);
        }
    }

    public DatabaseConnectionInfo getDatabaseConnectionInfo(Dialect dialect) {
        try {
            ConnectionPoolDefinitionIF cpd = ProxoolFacade.getConnectionPoolDefinition((String)this.proxoolPoolAlias);
            return new DatabaseConnectionInfoImpl(cpd.getUrl(), cpd.getDriver(), dialect.getVersion(), ConnectionProviderInitiator.toIsolationNiceName((Integer)this.isolation), Boolean.toString(this.autocommit), Integer.valueOf(cpd.getMinimumConnectionCount()), Integer.valueOf(cpd.getMaximumConnectionCount()));
        }
        catch (ProxoolException e) {
            ProxoolMessageLogger.PROXOOL_MESSAGE_LOGGER.warn("Error while obtaining the database pool information", e);
            return new DatabaseConnectionInfoImpl(dialect);
        }
    }

    @Deprecated
    public void close() throws HibernateException {
        this.stop();
    }
}

